/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink;

import java.util.Collections;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.connector.ChangelogMode;
import org.apache.paimon.CoreOptions;
import org.apache.paimon.flink.sink.FlinkTableSink;
import org.apache.paimon.flink.source.DataTableSource;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.fs.local.LocalFileIO;
import org.apache.paimon.options.Options;
import org.apache.paimon.schema.Schema;
import org.apache.paimon.schema.SchemaManager;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.table.FileStoreTableFactory;
import org.apache.paimon.table.Table;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.IntType;
import org.apache.paimon.types.RowType;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class ChangelogModeTest {
    @TempDir
    java.nio.file.Path temp;
    private final ObjectIdentifier identifier = ObjectIdentifier.of((String)"c", (String)"d", (String)"t");
    private Path path;

    @BeforeEach
    public void beforeEach() {
        this.path = new Path(this.temp.toUri().toString());
    }

    private void test(Options options, ChangelogMode expectSource, ChangelogMode expectSink) throws Exception {
        new SchemaManager((FileIO)LocalFileIO.create(), this.path).createTable(new Schema(RowType.of((DataType[])new DataType[]{new IntType(), new IntType()}).getFields(), Collections.emptyList(), Collections.singletonList("f0"), options.toMap(), ""));
        FileStoreTable table = FileStoreTableFactory.create((FileIO)LocalFileIO.create(), (Path)this.path);
        DataTableSource source = new DataTableSource(this.identifier, (Table)table, true, null, null);
        Assertions.assertThat((Object)source.getChangelogMode()).isEqualTo((Object)expectSource);
        FlinkTableSink sink = new FlinkTableSink(this.identifier, (Table)table, null, null);
        Assertions.assertThat((Object)sink.getChangelogMode(ChangelogMode.all())).isEqualTo((Object)expectSink);
    }

    @Test
    public void testDefault() throws Exception {
        this.test(new Options(), ChangelogMode.upsert(), ChangelogMode.upsert());
    }

    @Test
    public void testInputChangelogProducer() throws Exception {
        Options options = new Options();
        options.set(CoreOptions.CHANGELOG_PRODUCER, (Object)CoreOptions.ChangelogProducer.INPUT);
        this.test(options, ChangelogMode.all(), ChangelogMode.all());
    }

    @Test
    public void testChangelogModeAll() throws Exception {
        Options options = new Options();
        options.set(CoreOptions.LOG_CHANGELOG_MODE, (Object)CoreOptions.LogChangelogMode.ALL);
        this.test(options, ChangelogMode.all(), ChangelogMode.all());
    }
}

