/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.configuration.ReadableConfig;
import org.apache.flink.table.catalog.ObjectIdentifier;
import org.apache.flink.table.factories.DynamicTableFactory;
import org.apache.flink.table.factories.FactoryUtil;
import org.apache.flink.table.types.logical.IntType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.VarCharType;
import org.apache.paimon.flink.AbstractFlinkTableFactory;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.testcontainers.shaded.com.google.common.collect.ImmutableMap;

public class AbstractFlinkTableFactoryTest {
    @Test
    public void testSchemaEquals() {
        this.innerTest(RowType.of((boolean)false, (LogicalType[])new LogicalType[0]), RowType.of((boolean)true, (LogicalType[])new LogicalType[0]), true);
        this.innerTest(RowType.of((boolean)false, (LogicalType[])new LogicalType[0]), RowType.of((boolean)false, (LogicalType[])new LogicalType[]{new VarCharType()}), false);
        this.innerTest(RowType.of((LogicalType[])new LogicalType[]{new VarCharType()}, (String[])new String[]{"foo"}), RowType.of((LogicalType[])new LogicalType[]{new VarCharType()}), false);
        this.innerTest(new RowType(true, Arrays.asList(new RowType.RowField("foo", (LogicalType)new VarCharType(), "comment about foo"), new RowType.RowField("bar", (LogicalType)new IntType()))), new RowType(false, Arrays.asList(new RowType.RowField("foo", (LogicalType)new VarCharType()), new RowType.RowField("bar", (LogicalType)new IntType(), "comment about bar"))), true);
    }

    @Test
    public void testGetDynamicOptions() {
        Configuration configuration = new Configuration();
        configuration.setString("paimon.catalog1.db.T.k1", "v1");
        configuration.setString("paimon.*.db.*.k2", "v2");
        ObjectIdentifier identifier = ObjectIdentifier.of((String)"catalog1", (String)"db", (String)"T");
        FactoryUtil.DefaultDynamicTableContext context = new FactoryUtil.DefaultDynamicTableContext(identifier, null, new HashMap(), (ReadableConfig)configuration, AbstractFlinkTableFactoryTest.class.getClassLoader(), false);
        Map options = AbstractFlinkTableFactory.getDynamicTableConfigOptions((DynamicTableFactory.Context)context);
        Assertions.assertThat((Map)options).isEqualTo((Object)ImmutableMap.of((Object)"k1", (Object)"v1", (Object)"k2", (Object)"v2"));
    }

    private void innerTest(RowType r1, RowType r2, boolean expectEquals) {
        Assertions.assertThat((boolean)AbstractFlinkTableFactory.schemaEquals((RowType)r1, (RowType)r2)).isEqualTo(expectEquals);
    }
}

