/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.action.cdc.mysql;

import com.ververica.cdc.connectors.mysql.source.MySqlSource;
import com.ververica.cdc.connectors.mysql.source.MySqlSourceBuilder;
import com.ververica.cdc.connectors.mysql.source.config.MySqlSourceOptions;
import com.ververica.cdc.connectors.mysql.source.offset.BinlogOffset;
import com.ververica.cdc.connectors.mysql.source.offset.BinlogOffsetBuilder;
import com.ververica.cdc.connectors.mysql.table.StartupOptions;
import com.ververica.cdc.debezium.DebeziumDeserializationSchema;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.flink.configuration.ConfigOption;
import org.apache.flink.configuration.ConfigOptions;
import org.apache.flink.configuration.Configuration;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.flink.action.cdc.CdcSourceRecord;
import org.apache.paimon.flink.action.cdc.TypeMapping;
import org.apache.paimon.flink.action.cdc.mysql.MySqlTypeUtils;
import org.apache.paimon.flink.action.cdc.schema.JdbcSchemaUtils;
import org.apache.paimon.flink.action.cdc.schema.JdbcSchemasInfo;
import org.apache.paimon.flink.action.cdc.serialization.CdcDebeziumDeserializationSchema;
import org.apache.paimon.options.OptionsUtils;
import org.apache.paimon.schema.Schema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MySqlActionUtils {
    private static final Logger LOG = LoggerFactory.getLogger(MySqlActionUtils.class);
    public static final ConfigOption<Boolean> SCAN_NEWLY_ADDED_TABLE_ENABLED = ConfigOptions.key((String)"scan.newly-added-table.enabled").booleanType().defaultValue((Object)true).withDescription("Whether capture the scan the newly added tables or not, by default is true.");

    static Connection getConnection(Configuration mySqlConfig, Map<String, String> jdbcProperties) throws Exception {
        String paramString = "";
        if (!jdbcProperties.isEmpty()) {
            paramString = "?" + jdbcProperties.entrySet().stream().map(e -> (String)e.getKey() + "=" + (String)e.getValue()).collect(Collectors.joining("&"));
        }
        String url = String.format("jdbc:mysql://%s:%d%s", mySqlConfig.get(MySqlSourceOptions.HOSTNAME), mySqlConfig.get(MySqlSourceOptions.PORT), paramString);
        LOG.info("Connect to MySQL server using url: {}", (Object)url);
        return DriverManager.getConnection(url, (String)mySqlConfig.get(MySqlSourceOptions.USERNAME), (String)mySqlConfig.get(MySqlSourceOptions.PASSWORD));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static JdbcSchemasInfo getMySqlTableInfos(Configuration mySqlConfig, Predicate<String> monitorTablePredication, List<Identifier> excludedTables, TypeMapping typeMapping) throws Exception {
        Pattern databasePattern = Pattern.compile((String)mySqlConfig.get(MySqlSourceOptions.DATABASE_NAME));
        JdbcSchemasInfo mySqlSchemasInfo = new JdbcSchemasInfo();
        Map<String, String> jdbcProperties = MySqlActionUtils.getJdbcProperties(typeMapping, mySqlConfig);
        try (Connection conn = MySqlActionUtils.getConnection(mySqlConfig, jdbcProperties);){
            DatabaseMetaData metaData = conn.getMetaData();
            try (ResultSet schemas = metaData.getCatalogs();){
                while (schemas.next()) {
                    ResultSet tables;
                    block36: {
                        String databaseName = schemas.getString("TABLE_CAT");
                        Matcher databaseMatcher = databasePattern.matcher(databaseName);
                        if (!databaseMatcher.matches()) continue;
                        tables = metaData.getTables(databaseName, null, "%", new String[]{"TABLE"});
                        Throwable throwable = null;
                        try {
                            while (tables.next()) {
                                String tableName = tables.getString("TABLE_NAME");
                                String tableComment = tables.getString("REMARKS");
                                Identifier identifier = Identifier.create((String)databaseName, (String)tableName);
                                if (monitorTablePredication.test(tableName)) {
                                    Schema schema = JdbcSchemaUtils.buildSchema(metaData, databaseName, tableName, tableComment, typeMapping, MySqlTypeUtils.toPaimonTypeVisitor());
                                    mySqlSchemasInfo.addSchema(identifier, schema);
                                    continue;
                                }
                                excludedTables.add(identifier);
                            }
                            if (tables == null) continue;
                            if (throwable == null) break block36;
                        }
                        catch (Throwable throwable2) {
                            try {
                                throwable = throwable2;
                                throw throwable2;
                            }
                            catch (Throwable throwable3) {
                                if (tables == null) throw throwable3;
                                if (throwable != null) {
                                    try {
                                        tables.close();
                                        throw throwable3;
                                    }
                                    catch (Throwable throwable4) {
                                        throwable.addSuppressed(throwable4);
                                        throw throwable3;
                                    }
                                }
                                tables.close();
                                throw throwable3;
                            }
                        }
                        try {
                            tables.close();
                            continue;
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                            continue;
                        }
                    }
                    tables.close();
                }
                return mySqlSchemasInfo;
            }
        }
    }

    public static MySqlSource<CdcSourceRecord> buildMySqlSource(Configuration mySqlConfig, String tableList, TypeMapping typeMapping) {
        MySqlSourceBuilder sourceBuilder = MySqlSource.builder();
        sourceBuilder.hostname((String)mySqlConfig.get(MySqlSourceOptions.HOSTNAME)).port(((Integer)mySqlConfig.get(MySqlSourceOptions.PORT)).intValue()).username((String)mySqlConfig.get(MySqlSourceOptions.USERNAME)).password((String)mySqlConfig.get(MySqlSourceOptions.PASSWORD)).databaseList(new String[]{(String)mySqlConfig.get(MySqlSourceOptions.DATABASE_NAME)}).tableList(new String[]{tableList});
        mySqlConfig.getOptional(MySqlSourceOptions.SERVER_ID).ifPresent(arg_0 -> ((MySqlSourceBuilder)sourceBuilder).serverId(arg_0));
        mySqlConfig.getOptional(MySqlSourceOptions.SERVER_TIME_ZONE).ifPresent(arg_0 -> ((MySqlSourceBuilder)sourceBuilder).serverTimeZone(arg_0));
        mySqlConfig.getOptional(MySqlSourceOptions.SCAN_INCREMENTAL_SNAPSHOT_CHUNK_SIZE).ifPresent(arg_0 -> ((MySqlSourceBuilder)sourceBuilder).splitSize(arg_0));
        mySqlConfig.getOptional(MySqlSourceOptions.CONNECT_TIMEOUT).ifPresent(arg_0 -> ((MySqlSourceBuilder)sourceBuilder).connectTimeout(arg_0));
        mySqlConfig.getOptional(MySqlSourceOptions.CONNECT_MAX_RETRIES).ifPresent(arg_0 -> ((MySqlSourceBuilder)sourceBuilder).connectMaxRetries(arg_0));
        mySqlConfig.getOptional(MySqlSourceOptions.CONNECTION_POOL_SIZE).ifPresent(arg_0 -> ((MySqlSourceBuilder)sourceBuilder).connectionPoolSize(arg_0));
        mySqlConfig.getOptional(MySqlSourceOptions.HEARTBEAT_INTERVAL).ifPresent(arg_0 -> ((MySqlSourceBuilder)sourceBuilder).heartbeatInterval(arg_0));
        String startupMode = (String)mySqlConfig.get(MySqlSourceOptions.SCAN_STARTUP_MODE);
        if ("initial".equalsIgnoreCase(startupMode)) {
            sourceBuilder.startupOptions(StartupOptions.initial());
        } else if ("earliest-offset".equalsIgnoreCase(startupMode)) {
            sourceBuilder.startupOptions(StartupOptions.earliest());
        } else if ("latest-offset".equalsIgnoreCase(startupMode)) {
            sourceBuilder.startupOptions(StartupOptions.latest());
        } else if ("specific-offset".equalsIgnoreCase(startupMode)) {
            BinlogOffsetBuilder offsetBuilder = BinlogOffset.builder();
            String file = (String)mySqlConfig.get(MySqlSourceOptions.SCAN_STARTUP_SPECIFIC_OFFSET_FILE);
            Long pos = (Long)mySqlConfig.get(MySqlSourceOptions.SCAN_STARTUP_SPECIFIC_OFFSET_POS);
            if (file != null && pos != null) {
                offsetBuilder.setBinlogFilePosition(file, pos.longValue());
            }
            mySqlConfig.getOptional(MySqlSourceOptions.SCAN_STARTUP_SPECIFIC_OFFSET_GTID_SET).ifPresent(arg_0 -> ((BinlogOffsetBuilder)offsetBuilder).setGtidSet(arg_0));
            mySqlConfig.getOptional(MySqlSourceOptions.SCAN_STARTUP_SPECIFIC_OFFSET_SKIP_EVENTS).ifPresent(arg_0 -> ((BinlogOffsetBuilder)offsetBuilder).setSkipEvents(arg_0));
            mySqlConfig.getOptional(MySqlSourceOptions.SCAN_STARTUP_SPECIFIC_OFFSET_SKIP_ROWS).ifPresent(arg_0 -> ((BinlogOffsetBuilder)offsetBuilder).setSkipRows(arg_0));
            sourceBuilder.startupOptions(StartupOptions.specificOffset((BinlogOffset)offsetBuilder.build()));
        } else if ("timestamp".equalsIgnoreCase(startupMode)) {
            sourceBuilder.startupOptions(StartupOptions.timestamp((long)((Long)mySqlConfig.get(MySqlSourceOptions.SCAN_STARTUP_TIMESTAMP_MILLIS))));
        }
        Properties jdbcProperties = new Properties();
        jdbcProperties.putAll(MySqlActionUtils.getJdbcProperties(typeMapping, mySqlConfig));
        sourceBuilder.jdbcProperties(jdbcProperties);
        Properties debeziumProperties = new Properties();
        debeziumProperties.putAll((Map<?, ?>)OptionsUtils.convertToPropertiesPrefixKey((Map)mySqlConfig.toMap(), (String)"debezium."));
        sourceBuilder.debeziumProperties(debeziumProperties);
        HashMap<String, Object> customConverterConfigs = new HashMap<String, Object>();
        customConverterConfigs.put("decimal.format", "numeric");
        CdcDebeziumDeserializationSchema schema = new CdcDebeziumDeserializationSchema(true, customConverterConfigs);
        boolean scanNewlyAddedTables = (Boolean)mySqlConfig.get(SCAN_NEWLY_ADDED_TABLE_ENABLED);
        return sourceBuilder.deserializer((DebeziumDeserializationSchema)schema).includeSchemaChanges(true).scanNewlyAddedTableEnabled(scanNewlyAddedTables).build();
    }

    private static Map<String, String> getJdbcProperties(TypeMapping typeMapping, Configuration mySqlConfig) {
        Map jdbcProperties = OptionsUtils.convertToPropertiesPrefixKey((Map)mySqlConfig.toMap(), (String)"jdbc.properties.");
        if (typeMapping.containsMode(TypeMapping.TypeMappingMode.TINYINT1_NOT_BOOL)) {
            String tinyInt1isBit = (String)jdbcProperties.get("tinyInt1isBit");
            if (tinyInt1isBit == null) {
                jdbcProperties.put("tinyInt1isBit", "false");
            } else if ("true".equals(jdbcProperties.get("tinyInt1isBit"))) {
                throw new IllegalArgumentException("Type mapping option 'tinyint1-not-bool' conflicts with jdbc properties 'jdbc.properties.tinyInt1isBit=true'. Option 'tinyint1-not-bool' is equal to 'jdbc.properties.tinyInt1isBit=false'.");
            }
        }
        return jdbcProperties;
    }

    public static void registerJdbcDriver() {
        try {
            Class.forName("com.mysql.cj.jdbc.Driver");
        }
        catch (ClassNotFoundException ex) {
            LOG.warn("Cannot find class com.mysql.cj.jdbc.Driver. Try to load class com.mysql.jdbc.Driver.");
            try {
                Class.forName("com.mysql.jdbc.Driver");
            }
            catch (Exception e) {
                throw new RuntimeException("No suitable driver found. Cannot find class com.mysql.cj.jdbc.Driver and com.mysql.jdbc.Driver.");
            }
        }
    }
}

