/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.action.cdc;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.paimon.flink.action.cdc.CdcMetadataConverter;
import org.apache.paimon.flink.action.cdc.SyncJobHandler;
import org.apache.paimon.utils.Preconditions;

public enum CdcMetadataProcessor {
    MYSQL_METADATA_PROCESSOR(SyncJobHandler.SourceType.MYSQL, new CdcMetadataConverter.DatabaseNameConverter(), new CdcMetadataConverter.TableNameConverter(), new CdcMetadataConverter.OpTsConverter()),
    POSTGRES_METADATA_PROCESSOR(SyncJobHandler.SourceType.POSTGRES, new CdcMetadataConverter.DatabaseNameConverter(), new CdcMetadataConverter.TableNameConverter(), new CdcMetadataConverter.SchemaNameConverter(), new CdcMetadataConverter.OpTsConverter());

    private final SyncJobHandler.SourceType sourceType;
    private final CdcMetadataConverter[] cdcMetadataConverters;
    private static final Map<SyncJobHandler.SourceType, Map<String, CdcMetadataConverter>> METADATA_CONVERTERS;

    private CdcMetadataProcessor(SyncJobHandler.SourceType sourceType, CdcMetadataConverter ... cdcMetadataConverters) {
        this.sourceType = sourceType;
        this.cdcMetadataConverters = cdcMetadataConverters;
    }

    public static CdcMetadataConverter converter(SyncJobHandler.SourceType sourceType, String column) {
        return (CdcMetadataConverter)Preconditions.checkNotNull(((Map)Preconditions.checkNotNull(METADATA_CONVERTERS.get((Object)sourceType))).get(column));
    }

    private CdcMetadataConverter[] cdcMetadataConverters() {
        return this.cdcMetadataConverters;
    }

    private SyncJobHandler.SourceType sourceType() {
        return this.sourceType;
    }

    static {
        METADATA_CONVERTERS = Arrays.stream(CdcMetadataProcessor.values()).collect(Collectors.toMap(CdcMetadataProcessor::sourceType, value -> Arrays.stream(value.cdcMetadataConverters()).collect(Collectors.toMap(CdcMetadataConverter::columnName, Function.identity()))));
    }
}

