/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.action.cdc.mysql;

import io.debezium.relational.history.TableChanges;
import java.io.IOException;
import java.net.URL;
import java.util.Iterator;
import org.apache.paimon.flink.action.cdc.mysql.format.DebeziumEvent;
import org.apache.paimon.shade.guava30.com.google.common.collect.Iterators;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.core.JsonParser;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.databind.DeserializationFeature;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class DebeziumEventTest {
    private ObjectMapper objectMapper;

    @BeforeEach
    public void before() {
        this.objectMapper = new ObjectMapper();
        this.objectMapper.configure(JsonParser.Feature.ALLOW_COMMENTS, true).configure(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS, true).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    @Test
    public void testDeserialize() throws IOException {
        URL url = DebeziumEventTest.class.getClassLoader().getResource("mysql/debezium-event-change.json");
        Assertions.assertThat((URL)url).isNotNull();
        DebeziumEvent debeziumEvent = (DebeziumEvent)this.objectMapper.readValue(url, DebeziumEvent.class);
        Assertions.assertThat((Object)debeziumEvent).isNotNull();
        Assertions.assertThat((boolean)debeziumEvent.payload().hasHistoryRecord()).isTrue();
        Iterator tableChanges = debeziumEvent.payload().getTableChanges();
        Assertions.assertThat((int)Iterators.size((Iterator)tableChanges)).isEqualTo(1);
        tableChanges.forEachRemaining(tableChange -> {
            Assertions.assertThat((Comparable)tableChange.getType()).isEqualTo((Object)TableChanges.TableChangeType.ALTER);
            Assertions.assertThat((String)tableChange.getTable().id().toString()).isEqualTo("tinyint1_not_bool_test.t1");
        });
    }
}

