/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.utils;

import java.io.Serializable;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.ExecutionConfig;
import org.apache.flink.api.common.typeinfo.AtomicType;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.api.common.typeutils.TypeComparator;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.java.typeutils.runtime.GenericTypeComparator;
import org.apache.flink.util.Preconditions;
import org.apache.paimon.flink.utils.JavaSerializer;

public class JavaTypeInfo<T extends Serializable>
extends TypeInformation<T>
implements AtomicType<T> {
    private static final long serialVersionUID = 1L;
    private final Class<T> typeClass;

    public JavaTypeInfo(Class<T> typeClass) {
        this.typeClass = (Class)Preconditions.checkNotNull(typeClass);
    }

    @PublicEvolving
    public boolean isBasicType() {
        return false;
    }

    @PublicEvolving
    public boolean isTupleType() {
        return false;
    }

    @PublicEvolving
    public int getArity() {
        return 1;
    }

    @PublicEvolving
    public int getTotalFields() {
        return 1;
    }

    @PublicEvolving
    public Class<T> getTypeClass() {
        return this.typeClass;
    }

    @PublicEvolving
    public boolean isKeyType() {
        return Comparable.class.isAssignableFrom(this.typeClass);
    }

    public TypeSerializer<T> createSerializer(ExecutionConfig config) {
        return new JavaSerializer<T>(this.typeClass);
    }

    public TypeComparator<T> createComparator(boolean sortOrderAscending, ExecutionConfig executionConfig) {
        if (this.isKeyType()) {
            GenericTypeComparator comparator = new GenericTypeComparator(sortOrderAscending, this.createSerializer(executionConfig), this.typeClass);
            return comparator;
        }
        throw new UnsupportedOperationException("Types that do not implement java.lang.Comparable cannot be used as keys.");
    }

    public int hashCode() {
        return this.typeClass.hashCode();
    }

    public boolean canEqual(Object obj) {
        return obj instanceof JavaTypeInfo;
    }

    public boolean equals(Object obj) {
        if (obj instanceof JavaTypeInfo) {
            JavaTypeInfo genericTypeInfo = (JavaTypeInfo)((Object)obj);
            return this.typeClass == genericTypeInfo.typeClass;
        }
        return false;
    }

    public String toString() {
        return "JavaType<" + this.typeClass.getCanonicalName() + ">";
    }
}

