/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.utils;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.apache.flink.api.common.typeutils.GenericTypeSerializerSnapshot;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.api.common.typeutils.TypeSerializerSnapshot;
import org.apache.flink.api.java.typeutils.runtime.DataInputViewStream;
import org.apache.flink.api.java.typeutils.runtime.DataOutputViewStream;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.util.InstantiationUtil;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaSerializer<T extends Serializable>
extends TypeSerializer<T> {
    private static final long serialVersionUID = 3L;
    private static final Logger LOG = LoggerFactory.getLogger(JavaSerializer.class);
    private final Class<T> type;

    public JavaSerializer(Class<T> type) {
        this.type = (Class)Preconditions.checkNotNull(type);
    }

    public boolean isImmutableType() {
        return false;
    }

    public JavaSerializer<T> duplicate() {
        return new JavaSerializer<T>(this.type);
    }

    public T createInstance() {
        try {
            return (T)((Serializable)this.type.newInstance());
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    public T copy(T from) {
        try {
            return (T)InstantiationUtil.clone(from);
        }
        catch (IOException | ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public T copy(T from, T reuse) {
        return this.copy(from);
    }

    public int getLength() {
        return -1;
    }

    public void serialize(T record, DataOutputView target) throws IOException {
        InstantiationUtil.serializeObject((OutputStream)new DataOutputViewStream(target), record);
    }

    public T deserialize(DataInputView source) throws IOException {
        try {
            return (T)((Serializable)InstantiationUtil.deserializeObject((InputStream)new DataInputViewStream(source), (ClassLoader)((Object)((Object)this)).getClass().getClassLoader()));
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public T deserialize(T reuse, DataInputView source) throws IOException {
        return (T)this.deserialize(source);
    }

    public void copy(DataInputView source, DataOutputView target) throws IOException {
        this.serialize((T)this.deserialize(source), target);
    }

    public int hashCode() {
        return this.type.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof JavaSerializer) {
            JavaSerializer other = (JavaSerializer)((Object)obj);
            return this.type == other.type;
        }
        return false;
    }

    public TypeSerializerSnapshot<T> snapshotConfiguration() {
        return new JavaSerializerSnapshot<T>(this.type);
    }

    public static final class JavaSerializerSnapshot<T extends Serializable>
    extends GenericTypeSerializerSnapshot<T, JavaSerializer> {
        public JavaSerializerSnapshot() {
        }

        JavaSerializerSnapshot(Class<T> typeClass) {
            super(typeClass);
        }

        protected TypeSerializer<T> createSerializer(Class<T> typeClass) {
            return new JavaSerializer<T>(typeClass);
        }

        protected Class<T> getTypeClass(JavaSerializer serializer) {
            return serializer.type;
        }

        protected Class<?> serializerClass() {
            return JavaSerializer.class;
        }
    }
}

