/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.source;

import java.util.regex.Pattern;
import org.apache.flink.api.common.typeinfo.TypeInformation;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.paimon.catalog.Catalog;
import org.apache.paimon.flink.LogicalTypeConversion;
import org.apache.paimon.flink.source.operator.MultiTablesBatchCompactorSourceFunction;
import org.apache.paimon.flink.source.operator.MultiTablesStreamingCompactorSourceFunction;
import org.apache.paimon.table.system.BucketsTable;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.Preconditions;

public class MultiTablesCompactorSourceBuilder {
    private final Catalog.Loader catalogLoader;
    private final Pattern includingPattern;
    private final Pattern excludingPattern;
    private final Pattern databasePattern;
    private final long monitorInterval;
    private boolean isContinuous = false;
    private StreamExecutionEnvironment env;

    public MultiTablesCompactorSourceBuilder(Catalog.Loader catalogLoader, Pattern databasePattern, Pattern includingPattern, Pattern excludingPattern, long monitorInterval) {
        this.catalogLoader = catalogLoader;
        this.includingPattern = includingPattern;
        this.excludingPattern = excludingPattern;
        this.databasePattern = databasePattern;
        this.monitorInterval = monitorInterval;
    }

    public MultiTablesCompactorSourceBuilder withContinuousMode(boolean isContinuous) {
        this.isContinuous = isContinuous;
        return this;
    }

    public MultiTablesCompactorSourceBuilder withEnv(StreamExecutionEnvironment env) {
        this.env = env;
        return this;
    }

    public DataStream<RowData> build() {
        Preconditions.checkArgument(this.env != null, "StreamExecutionEnvironment should not be null.");
        RowType produceType = BucketsTable.getRowType();
        if (this.isContinuous) {
            return MultiTablesStreamingCompactorSourceFunction.buildSource(this.env, "MultiTables-StreamingCompactorSource", (TypeInformation<RowData>)InternalTypeInfo.of((org.apache.flink.table.types.logical.RowType)LogicalTypeConversion.toLogicalType(produceType)), this.catalogLoader, this.includingPattern, this.excludingPattern, this.databasePattern, this.monitorInterval);
        }
        return MultiTablesBatchCompactorSourceFunction.buildSource(this.env, "MultiTables-BatchCompactorSource", (TypeInformation<RowData>)InternalTypeInfo.of((org.apache.flink.table.types.logical.RowType)LogicalTypeConversion.toLogicalType(produceType)), this.catalogLoader, this.includingPattern, this.excludingPattern, this.databasePattern, this.monitorInterval);
    }
}

