/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.sink;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.annotation.Nullable;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.metrics.MetricGroup;
import org.apache.flink.runtime.io.disk.iomanager.IOManager;
import org.apache.paimon.Snapshot;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.flink.sink.Committable;
import org.apache.paimon.flink.sink.StoreSinkWriteImpl;
import org.apache.paimon.flink.sink.StoreSinkWriteState;
import org.apache.paimon.memory.MemorySegmentPool;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.table.sink.SinkRecord;
import org.apache.paimon.table.source.snapshot.FullCompactedStartingScanner;
import org.apache.paimon.utils.SnapshotManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlobalFullCompactionSinkWrite
extends StoreSinkWriteImpl {
    private static final Logger LOG = LoggerFactory.getLogger(GlobalFullCompactionSinkWrite.class);
    private final int deltaCommits;
    private final String tableName;
    private final SnapshotManager snapshotManager;
    private final Set<Tuple2<BinaryRow, Integer>> currentWrittenBuckets;
    private final NavigableMap<Long, Set<Tuple2<BinaryRow, Integer>>> writtenBuckets;
    private static final String WRITTEN_BUCKETS_STATE_NAME = "paimon_written_buckets";
    private final TreeSet<Long> commitIdentifiersToCheck;

    public GlobalFullCompactionSinkWrite(FileStoreTable table, String commitUser, StoreSinkWriteState state, IOManager ioManager, boolean ignorePreviousFiles, boolean waitCompaction, int deltaCommits, boolean isStreaming, @Nullable MemorySegmentPool memoryPool, MetricGroup metricGroup) {
        super(table, commitUser, state, ioManager, ignorePreviousFiles, waitCompaction, isStreaming, memoryPool, metricGroup);
        this.deltaCommits = deltaCommits;
        this.tableName = table.name();
        this.snapshotManager = table.snapshotManager();
        this.currentWrittenBuckets = new HashSet<Tuple2<BinaryRow, Integer>>();
        this.writtenBuckets = new TreeMap<Long, Set<Tuple2<BinaryRow, Integer>>>();
        List<StoreSinkWriteState.StateValue> writtenBucketStateValues = state.get(this.tableName, WRITTEN_BUCKETS_STATE_NAME);
        if (writtenBucketStateValues != null) {
            for (StoreSinkWriteState.StateValue stateValue : writtenBucketStateValues) {
                this.writtenBuckets.computeIfAbsent(GlobalFullCompactionSinkWrite.bytesToLong(stateValue.value()), k -> new HashSet()).add(Tuple2.of((Object)stateValue.partition(), (Object)stateValue.bucket()));
            }
        }
        this.commitIdentifiersToCheck = new TreeSet();
    }

    @Override
    @Nullable
    public SinkRecord write(InternalRow rowData) throws Exception {
        SinkRecord sinkRecord = super.write(rowData);
        if (sinkRecord != null) {
            this.touchBucket(sinkRecord.partition(), sinkRecord.bucket());
        }
        return sinkRecord;
    }

    @Override
    @Nullable
    public SinkRecord write(InternalRow rowData, int bucket) throws Exception {
        SinkRecord sinkRecord = super.write(rowData, bucket);
        if (sinkRecord != null) {
            this.touchBucket(sinkRecord.partition(), bucket);
        }
        return sinkRecord;
    }

    @Override
    public void compact(BinaryRow partition, int bucket, boolean fullCompaction) throws Exception {
        super.compact(partition, bucket, fullCompaction);
        this.touchBucket(partition, bucket);
    }

    private void touchBucket(BinaryRow partition, int bucket) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("touch partition {}, bucket {}", (Object)partition, (Object)bucket);
        }
        if (!this.currentWrittenBuckets.contains(Tuple2.of((Object)partition, (Object)bucket))) {
            this.currentWrittenBuckets.add((Tuple2<BinaryRow, Integer>)Tuple2.of((Object)partition.copy(), (Object)bucket));
        }
    }

    @Override
    public List<Committable> prepareCommit(boolean waitCompaction, long checkpointId) throws IOException {
        this.checkSuccessfulFullCompaction();
        if (!this.currentWrittenBuckets.isEmpty()) {
            this.writtenBuckets.computeIfAbsent(checkpointId, k -> new HashSet()).addAll(this.currentWrittenBuckets);
            this.currentWrittenBuckets.clear();
        }
        if (LOG.isDebugEnabled()) {
            for (Map.Entry checkpointIdAndBuckets : this.writtenBuckets.entrySet()) {
                LOG.debug("Written buckets for checkpoint #{} are:", checkpointIdAndBuckets.getKey());
                for (Tuple2 bucket : (Set)checkpointIdAndBuckets.getValue()) {
                    LOG.debug("  * partition {}, bucket {}", bucket.f0, bucket.f1);
                }
            }
        }
        if (!this.writtenBuckets.isEmpty() && FullCompactedStartingScanner.isFullCompactedIdentifier(checkpointId, this.deltaCommits)) {
            waitCompaction = true;
        }
        if (waitCompaction) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Submit full compaction for checkpoint #{}", (Object)checkpointId);
            }
            this.submitFullCompaction(checkpointId);
            this.commitIdentifiersToCheck.add(checkpointId);
        }
        return super.prepareCommit(waitCompaction, checkpointId);
    }

    private void checkSuccessfulFullCompaction() {
        if (this.commitIdentifiersToCheck.isEmpty()) {
            return;
        }
        this.snapshotManager.traversalSnapshotsFromLatestSafely(this::checkSuccessfulFullCompaction);
    }

    private boolean checkSuccessfulFullCompaction(Snapshot snapshot) {
        long commitIdentifier;
        if (snapshot.commitUser().equals(this.commitUser) && snapshot.commitKind() == Snapshot.CommitKind.COMPACT && this.commitIdentifiersToCheck.contains(commitIdentifier = snapshot.commitIdentifier())) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Found full compaction snapshot #{} with identifier {}", (Object)snapshot.id(), (Object)commitIdentifier);
            }
            this.writtenBuckets.headMap(commitIdentifier, true).clear();
            this.commitIdentifiersToCheck.headSet(commitIdentifier).clear();
            return true;
        }
        return false;
    }

    private void submitFullCompaction(long currentCheckpointId) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Submit full compaction for checkpoint #{}", (Object)currentCheckpointId);
        }
        HashSet compactedBuckets = new HashSet();
        this.writtenBuckets.forEach((checkpointId, buckets) -> {
            for (Tuple2 bucket : buckets) {
                if (compactedBuckets.contains(bucket)) continue;
                compactedBuckets.add(bucket);
                try {
                    this.write.compact((BinaryRow)bucket.f0, (Integer)bucket.f1, true);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    @Override
    public void snapshotState() throws Exception {
        super.snapshotState();
        ArrayList<StoreSinkWriteState.StateValue> writtenBucketList = new ArrayList<StoreSinkWriteState.StateValue>();
        for (Map.Entry entry : this.writtenBuckets.entrySet()) {
            for (Tuple2 bucket : (Set)entry.getValue()) {
                writtenBucketList.add(new StoreSinkWriteState.StateValue((BinaryRow)bucket.f0, (Integer)bucket.f1, GlobalFullCompactionSinkWrite.longToBytes((Long)entry.getKey())));
            }
        }
        this.state.put(this.tableName, WRITTEN_BUCKETS_STATE_NAME, writtenBucketList);
    }

    private static byte[] longToBytes(long l) {
        byte[] result = new byte[8];
        for (int i = 7; i >= 0; --i) {
            result[i] = (byte)(l & 0xFFL);
            l >>= 8;
        }
        return result;
    }

    private static long bytesToLong(byte[] b) {
        long result = 0L;
        for (int i = 0; i < 8; ++i) {
            result <<= 8;
            result |= (long)(b[i] & 0xFF);
        }
        return result;
    }
}

