/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.sink;

import org.apache.flink.table.data.RowData;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.table.sink.ChannelComputer;
import org.apache.paimon.utils.SerializationUtils;

public class BucketsRowChannelComputer
implements ChannelComputer<RowData> {
    private transient int numberOfChannels;

    @Override
    public void setup(int numberOfChannels) {
        this.numberOfChannels = numberOfChannels;
    }

    @Override
    public int channel(RowData rowData) {
        BinaryRow partition = SerializationUtils.deserializeBinaryRow(rowData.getBinary(1));
        int bucket = rowData.getInt(2);
        return ChannelComputer.select(partition, bucket, this.numberOfChannels);
    }

    public String toString() {
        return "compactor-partitioner";
    }
}

