/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.procedure.privilege;

import org.apache.flink.table.procedure.ProcedureContext;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.flink.procedure.privilege.PrivilegeProcedureBase;
import org.apache.paimon.privilege.PrivilegeType;

public class RevokePrivilegeFromUserProcedure
extends PrivilegeProcedureBase {
    public static final String IDENTIFIER = "revoke_privilege_from_user";

    public String[] call(ProcedureContext procedureContext, String user, String privilege) {
        int count = this.getPrivilegedCatalog().revokePrivilegeOnCatalog(user, PrivilegeType.valueOf(privilege));
        return new String[]{String.format("User %s is revoked with privilege %s on the catalog.", user, privilege), "Number of privileges revoked: " + count};
    }

    public String[] call(ProcedureContext procedureContext, String user, String privilege, String database) {
        int count = this.getPrivilegedCatalog().revokePrivilegeOnDatabase(user, database, PrivilegeType.valueOf(privilege));
        return new String[]{String.format("User %s is revoked with privilege %s on database %s.", user, privilege, database), "Number of privileges revoked: " + count};
    }

    public String[] call(ProcedureContext procedureContext, String user, String privilege, String database, String table) {
        Identifier identifier = Identifier.create(database, table);
        int count = this.getPrivilegedCatalog().revokePrivilegeOnTable(user, identifier, PrivilegeType.valueOf(privilege));
        return new String[]{String.format("User %s is revoked with privilege %s on table %s.", user, privilege, identifier), "Number of privileges revoked: " + count};
    }

    @Override
    public String identifier() {
        return IDENTIFIER;
    }
}

