/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.procedure.privilege;

import org.apache.flink.table.procedure.ProcedureContext;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.flink.procedure.privilege.PrivilegeProcedureBase;
import org.apache.paimon.privilege.PrivilegeType;

public class GrantPrivilegeToUserProcedure
extends PrivilegeProcedureBase {
    public static final String IDENTIFIER = "grant_privilege_to_user";

    public String[] call(ProcedureContext procedureContext, String user, String privilege) {
        this.getPrivilegedCatalog().grantPrivilegeOnCatalog(user, PrivilegeType.valueOf(privilege));
        return new String[]{String.format("User %s is granted with privilege %s on the catalog.", user, privilege)};
    }

    public String[] call(ProcedureContext procedureContext, String user, String privilege, String database) {
        this.getPrivilegedCatalog().grantPrivilegeOnDatabase(user, database, PrivilegeType.valueOf(privilege));
        return new String[]{String.format("User %s is granted with privilege %s on database %s.", user, privilege, database)};
    }

    public String[] call(ProcedureContext procedureContext, String user, String privilege, String database, String table) {
        Identifier identifier = Identifier.create(database, table);
        this.getPrivilegedCatalog().grantPrivilegeOnTable(user, identifier, PrivilegeType.valueOf(privilege));
        return new String[]{String.format("User %s is granted with privilege %s on table %s.", user, privilege, identifier)};
    }

    @Override
    public String identifier() {
        return IDENTIFIER;
    }
}

