/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.procedure;

import org.apache.flink.table.procedure.ProcedureContext;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.flink.procedure.ProcedureBase;
import org.apache.paimon.operation.OrphanFilesClean;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.table.Table;
import org.apache.paimon.utils.Preconditions;
import org.apache.paimon.utils.StringUtils;

public class RemoveOrphanFilesProcedure
extends ProcedureBase {
    public static final String IDENTIFIER = "remove_orphan_files";

    public String[] call(ProcedureContext procedureContext, String tableId) throws Exception {
        return this.call(procedureContext, tableId, "");
    }

    public String[] call(ProcedureContext procedureContext, String tableId, String olderThan) throws Exception {
        Identifier identifier = Identifier.fromString(tableId);
        Table table = this.catalog.getTable(identifier);
        Preconditions.checkArgument(table instanceof FileStoreTable, "Only FileStoreTable supports remove-orphan-files action. The table type is '%s'.", table.getClass().getName());
        OrphanFilesClean orphanFilesClean = new OrphanFilesClean((FileStoreTable)table);
        if (!StringUtils.isBlank(olderThan)) {
            orphanFilesClean.olderThan(olderThan);
        }
        int deleted = orphanFilesClean.clean();
        return new String[]{"Deleted=" + deleted};
    }

    @Override
    public String identifier() {
        return IDENTIFIER;
    }
}

