/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.procedure;

import java.util.Collections;
import java.util.Map;
import org.apache.flink.table.annotation.ArgumentHint;
import org.apache.flink.table.annotation.DataTypeHint;
import org.apache.flink.table.annotation.ProcedureHint;
import org.apache.flink.table.procedure.ProcedureContext;
import org.apache.paimon.catalog.Identifier;
import org.apache.paimon.flink.action.CompactAction;
import org.apache.paimon.flink.action.SortCompactAction;
import org.apache.paimon.flink.procedure.ProcedureBase;
import org.apache.paimon.utils.ParameterUtils;
import org.apache.paimon.utils.StringUtils;

public class CompactProcedure
extends ProcedureBase {
    public static final String IDENTIFIER = "compact";

    @ProcedureHint(argument={@ArgumentHint(name="table", type=@DataTypeHint(value="STRING")), @ArgumentHint(name="partitions", type=@DataTypeHint(value="STRING"), isOptional=true), @ArgumentHint(name="order_strategy", type=@DataTypeHint(value="STRING"), isOptional=true), @ArgumentHint(name="order_by", type=@DataTypeHint(value="STRING"), isOptional=true), @ArgumentHint(name="options", type=@DataTypeHint(value="STRING"), isOptional=true)})
    public String[] call(ProcedureContext procedureContext, String tableId, String partitions, String orderStrategy, String orderByColumns, String tableOptions) throws Exception {
        String jobName;
        CompactAction action;
        String warehouse = this.catalog.warehouse();
        Map<String, String> catalogOptions = this.catalog.options();
        Map<String, String> tableConf = StringUtils.isBlank(tableOptions) ? Collections.emptyMap() : ParameterUtils.parseCommaSeparatedKeyValues(tableOptions);
        Identifier identifier = Identifier.fromString(tableId);
        if (StringUtils.isBlank(orderStrategy) && StringUtils.isBlank(orderByColumns)) {
            action = new CompactAction(warehouse, identifier.getDatabaseName(), identifier.getObjectName(), catalogOptions, tableConf);
            jobName = "Compact Job";
        } else if (!StringUtils.isBlank(orderStrategy) && !StringUtils.isBlank(orderByColumns)) {
            action = new SortCompactAction(warehouse, identifier.getDatabaseName(), identifier.getObjectName(), catalogOptions, tableConf).withOrderStrategy(orderStrategy).withOrderColumns(orderByColumns.split(","));
            jobName = "Sort Compact Job";
        } else {
            throw new IllegalArgumentException("You must specify 'order strategy' and 'order by columns' both.");
        }
        if (!StringUtils.isBlank(partitions)) {
            action.withPartitions(ParameterUtils.getPartitions(partitions.split(";")));
        }
        return this.execute(procedureContext, action, jobName);
    }

    @Override
    public String identifier() {
        return IDENTIFIER;
    }
}

