/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.memory;

import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.flink.runtime.memory.MemoryManager;
import org.apache.paimon.memory.MemorySegment;
import org.apache.paimon.utils.Preconditions;

public class MemorySegmentAllocator {
    private final Object owner;
    private final MemoryManager memoryManager;
    private final List<org.apache.flink.core.memory.MemorySegment> allocatedSegments;
    private final List<org.apache.flink.core.memory.MemorySegment> segments;
    private final Field offHeapBufferField;

    public MemorySegmentAllocator(Object owner, MemoryManager memoryManager) {
        this.owner = owner;
        this.memoryManager = memoryManager;
        this.allocatedSegments = new ArrayList<org.apache.flink.core.memory.MemorySegment>();
        this.segments = new ArrayList<org.apache.flink.core.memory.MemorySegment>(1);
        try {
            this.offHeapBufferField = org.apache.flink.core.memory.MemorySegment.class.getDeclaredField("offHeapBuffer");
            this.offHeapBufferField.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(e);
        }
    }

    public MemorySegment allocate() {
        this.segments.clear();
        try {
            this.memoryManager.allocatePages(this.owner, this.segments, 1);
            org.apache.flink.core.memory.MemorySegment segment = this.segments.remove(0);
            Preconditions.checkNotNull(segment, "Allocate null segment from memory manager for paimon.");
            Preconditions.checkArgument(segment.isOffHeap(), "Segment is not off heap from memory manager.");
            this.allocatedSegments.add(segment);
            return MemorySegment.wrapOffHeapMemory((ByteBuffer)this.offHeapBufferField.get(segment));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void release() {
        this.memoryManager.release(this.allocatedSegments);
    }
}

