/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.flink.action.cdc.postgres;

import javax.annotation.Nullable;
import org.apache.paimon.flink.action.cdc.JdbcToPaimonTypeVisitor;
import org.apache.paimon.flink.action.cdc.TypeMapping;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypes;

public class PostgresTypeUtils {
    private static final String PG_BIT = "bit";
    private static final String PG_VARBIT = "varbit";
    private static final String PG_SMALLSERIAL = "smallserial";
    private static final String PG_SERIAL = "serial";
    private static final String PG_BIGSERIAL = "bigserial";
    private static final String PG_BYTEA = "bytea";
    private static final String PG_BYTEA_ARRAY = "_bytea";
    private static final String PG_SMALLINT = "int2";
    private static final String PG_SMALLINT_ARRAY = "_int2";
    private static final String PG_INTEGER = "int4";
    private static final String PG_INTEGER_ARRAY = "_int4";
    private static final String PG_BIGINT = "int8";
    private static final String PG_BIGINT_ARRAY = "_int8";
    private static final String PG_REAL = "float4";
    private static final String PG_REAL_ARRAY = "_float4";
    private static final String PG_DOUBLE_PRECISION = "float8";
    private static final String PG_DOUBLE_PRECISION_ARRAY = "_float8";
    private static final String PG_NUMERIC = "numeric";
    private static final String PG_NUMERIC_ARRAY = "_numeric";
    private static final String PG_BOOLEAN = "bool";
    private static final String PG_BOOLEAN_ARRAY = "_bool";
    private static final String PG_TIMESTAMP = "timestamp";
    private static final String PG_TIMESTAMP_ARRAY = "_timestamp";
    private static final String PG_TIMESTAMPTZ = "timestamptz";
    private static final String PG_TIMESTAMPTZ_ARRAY = "_timestamptz";
    private static final String PG_DATE = "date";
    private static final String PG_DATE_ARRAY = "_date";
    private static final String PG_TIME = "time";
    private static final String PG_TIME_ARRAY = "_time";
    private static final String PG_TEXT = "text";
    private static final String PG_TEXT_ARRAY = "_text";
    private static final String PG_CHAR = "bpchar";
    private static final String PG_CHAR_ARRAY = "_bpchar";
    private static final String PG_CHARACTER = "character";
    private static final String PG_CHARACTER_ARRAY = "_character";
    private static final String PG_CHARACTER_VARYING = "varchar";
    private static final String PG_CHARACTER_VARYING_ARRAY = "_varchar";
    private static final String PG_JSON = "json";
    private static final String PG_ENUM = "enum";

    public static DataType toDataType(String typeName, @Nullable Integer precision, @Nullable Integer scale, TypeMapping typeMapping) {
        if (typeMapping.containsMode(TypeMapping.TypeMappingMode.TO_STRING)) {
            return DataTypes.STRING();
        }
        precision = precision == null ? 0 : precision;
        scale = scale == null ? 0 : scale;
        switch (typeName.toLowerCase()) {
            case "bit": 
            case "varbit": {
                if (precision <= 1) {
                    return DataTypes.BOOLEAN();
                }
                int length = precision == Integer.MAX_VALUE ? precision / 8 : (precision + 7) / 8;
                return DataTypes.BINARY(length);
            }
            case "bool": {
                return DataTypes.BOOLEAN();
            }
            case "_bool": {
                return DataTypes.ARRAY(DataTypes.BOOLEAN());
            }
            case "bytea": {
                return DataTypes.BYTES();
            }
            case "_bytea": {
                return DataTypes.ARRAY(DataTypes.BYTES());
            }
            case "int2": 
            case "smallserial": {
                return DataTypes.SMALLINT();
            }
            case "_int2": {
                return DataTypes.ARRAY(DataTypes.SMALLINT());
            }
            case "int4": 
            case "serial": {
                return DataTypes.INT();
            }
            case "_int4": {
                return DataTypes.ARRAY(DataTypes.INT());
            }
            case "int8": 
            case "bigserial": {
                return DataTypes.BIGINT();
            }
            case "_int8": {
                return DataTypes.ARRAY(DataTypes.BIGINT());
            }
            case "float4": {
                return DataTypes.FLOAT();
            }
            case "_float4": {
                return DataTypes.ARRAY(DataTypes.FLOAT());
            }
            case "float8": {
                return DataTypes.DOUBLE();
            }
            case "_float8": {
                return DataTypes.ARRAY(DataTypes.DOUBLE());
            }
            case "numeric": {
                if (precision > 0) {
                    return DataTypes.DECIMAL(precision, scale);
                }
                return DataTypes.DECIMAL(38, 18);
            }
            case "_numeric": {
                if (precision > 0) {
                    return DataTypes.ARRAY(DataTypes.DECIMAL(precision, scale));
                }
                return DataTypes.ARRAY(DataTypes.DECIMAL(38, 18));
            }
            case "bpchar": 
            case "character": {
                return DataTypes.CHAR(precision);
            }
            case "_bpchar": 
            case "_character": {
                return DataTypes.ARRAY(DataTypes.CHAR(precision));
            }
            case "varchar": {
                return DataTypes.VARCHAR(precision);
            }
            case "_varchar": {
                return DataTypes.ARRAY(DataTypes.VARCHAR(precision));
            }
            case "text": 
            case "json": 
            case "enum": {
                return DataTypes.STRING();
            }
            case "_text": {
                return DataTypes.ARRAY(DataTypes.STRING());
            }
            case "timestamp": {
                return DataTypes.TIMESTAMP(scale);
            }
            case "_timestamp": {
                return DataTypes.ARRAY(DataTypes.TIMESTAMP(scale));
            }
            case "timestamptz": {
                return DataTypes.TIMESTAMP_WITH_LOCAL_TIME_ZONE(scale);
            }
            case "_timestamptz": {
                return DataTypes.ARRAY(DataTypes.TIMESTAMP_WITH_LOCAL_TIME_ZONE(scale));
            }
            case "time": {
                return DataTypes.TIME(scale);
            }
            case "_time": {
                return DataTypes.ARRAY(DataTypes.TIME(scale));
            }
            case "date": {
                return DataTypes.DATE();
            }
            case "_date": {
                return DataTypes.ARRAY(DataTypes.DATE());
            }
        }
        throw new UnsupportedOperationException(String.format("Doesn't support Postgres type '%s' yet", typeName));
    }

    public static JdbcToPaimonTypeVisitor toPaimonTypeVisitor() {
        return PostgresToPaimonTypeVisitor.INSTANCE;
    }

    private static class PostgresToPaimonTypeVisitor
    implements JdbcToPaimonTypeVisitor {
        private static final PostgresToPaimonTypeVisitor INSTANCE = new PostgresToPaimonTypeVisitor();

        private PostgresToPaimonTypeVisitor() {
        }

        @Override
        public DataType visit(String type, @Nullable Integer length, @Nullable Integer scale, TypeMapping typeMapping) {
            return PostgresTypeUtils.toDataType(type, length, scale, typeMapping);
        }
    }
}

