/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.types;

import java.util.Objects;
import org.apache.paimon.annotation.Public;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.DataTypeRoot;
import org.apache.paimon.types.DataTypeVisitor;

@Public
public class CharType
extends DataType {
    private static final long serialVersionUID = 1L;
    public static final int MIN_LENGTH = 1;
    public static final int MAX_LENGTH = Integer.MAX_VALUE;
    public static final int DEFAULT_LENGTH = 1;
    private static final String FORMAT = "CHAR(%d)";
    private final int length;

    public CharType(boolean isNullable, int length) {
        super(isNullable, DataTypeRoot.CHAR);
        if (length < 1) {
            throw new IllegalArgumentException(String.format("Character string length must be between %d and %d (both inclusive).", 1, Integer.MAX_VALUE));
        }
        this.length = length;
    }

    public CharType(int length) {
        this(true, length);
    }

    public CharType() {
        this(1);
    }

    public int getLength() {
        return this.length;
    }

    @Override
    public DataType copy(boolean isNullable) {
        return new CharType(isNullable, this.length);
    }

    @Override
    public String asSQLString() {
        return this.withNullability(FORMAT, this.length);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CharType charType = (CharType)o;
        return this.length == charType.length;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.length);
    }

    @Override
    public <R> R accept(DataTypeVisitor<R> visitor) {
        return visitor.visit(this);
    }
}

