/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.factories;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import org.apache.paimon.factories.Factory;
import org.apache.paimon.factories.FactoryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FactoryUtil {
    private static final Logger LOG = LoggerFactory.getLogger(FactoryUtil.class);

    public static <T extends Factory> T discoverFactory(ClassLoader classLoader, Class<T> factoryClass, String identifier) {
        List<Factory> factories = FactoryUtil.discoverFactories(classLoader);
        List foundFactories = factories.stream().filter(f -> factoryClass.isAssignableFrom(f.getClass())).collect(Collectors.toList());
        if (foundFactories.isEmpty()) {
            throw new FactoryException(String.format("Could not find any factories that implement '%s' in the classpath.", factoryClass.getName()));
        }
        List matchingFactories = foundFactories.stream().filter(f -> f.identifier().equals(identifier)).collect(Collectors.toList());
        if (matchingFactories.isEmpty()) {
            throw new FactoryException(String.format("Could not find any factory for identifier '%s' that implements '%s' in the classpath.\n\nAvailable factory identifiers are:\n\n%s", identifier, factoryClass.getName(), foundFactories.stream().map(Factory::identifier).collect(Collectors.joining("\n"))));
        }
        if (matchingFactories.size() > 1) {
            throw new FactoryException(String.format("Multiple factories for identifier '%s' that implement '%s' found in the classpath.\n\nAmbiguous factory classes are:\n\n%s", identifier, factoryClass.getName(), matchingFactories.stream().map(f -> f.getClass().getName()).sorted().collect(Collectors.joining("\n"))));
        }
        return (T)((Factory)matchingFactories.get(0));
    }

    public static <T extends Factory> List<String> discoverIdentifiers(ClassLoader classLoader, Class<T> factoryClass) {
        List<Factory> factories = FactoryUtil.discoverFactories(classLoader);
        return factories.stream().filter(f -> factoryClass.isAssignableFrom(f.getClass())).map(Factory::identifier).collect(Collectors.toList());
    }

    private static List<Factory> discoverFactories(ClassLoader classLoader) {
        Iterator<Factory> serviceLoaderIterator = ServiceLoader.load(Factory.class, classLoader).iterator();
        ArrayList<Factory> loadResults = new ArrayList<Factory>();
        while (true) {
            try {
                while (serviceLoaderIterator.hasNext()) {
                    loadResults.add(serviceLoaderIterator.next());
                }
            }
            catch (Throwable t) {
                if (t instanceof NoClassDefFoundError) {
                    LOG.debug("NoClassDefFoundError when loading a " + Factory.class.getCanonicalName() + ". This is expected when trying to load factory but no implementation is loaded.", t);
                    continue;
                }
                throw new RuntimeException("Unexpected error when trying to load service provider.", t);
            }
            break;
        }
        return loadResults;
    }
}

