/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.codegen;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;

public class SortSpec {
    public static final SortSpec ANY = new SortSpec(new SortFieldSpec[0]);
    private final SortFieldSpec[] fieldSpecs;

    public SortSpec(SortFieldSpec[] fieldSpecs) {
        this.fieldSpecs = fieldSpecs;
    }

    public SortFieldSpec[] getFieldSpecs() {
        return this.fieldSpecs;
    }

    public SortFieldSpec getFieldSpec(int index) {
        return this.fieldSpecs[index];
    }

    public int getFieldSize() {
        return this.fieldSpecs.length;
    }

    public static SortSpecBuilder builder() {
        return new SortSpecBuilder();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SortSpec sortSpec = (SortSpec)o;
        return Arrays.equals(this.fieldSpecs, sortSpec.fieldSpecs);
    }

    public int hashCode() {
        return Arrays.hashCode(this.fieldSpecs);
    }

    public String toString() {
        return "Sort{fields=" + Arrays.toString(this.fieldSpecs) + '}';
    }

    public static class SortFieldSpec {
        private final int fieldIndex;
        private final boolean isAscendingOrder;
        private final boolean nullIsLast;

        public SortFieldSpec(int fieldIndex, boolean isAscendingOrder, boolean nullIsLast) {
            this.fieldIndex = fieldIndex;
            this.isAscendingOrder = isAscendingOrder;
            this.nullIsLast = nullIsLast;
        }

        public int getFieldIndex() {
            return this.fieldIndex;
        }

        public boolean getIsAscendingOrder() {
            return this.isAscendingOrder;
        }

        public boolean getNullIsLast() {
            return this.nullIsLast;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SortFieldSpec that = (SortFieldSpec)o;
            return this.fieldIndex == that.fieldIndex && this.isAscendingOrder == that.isAscendingOrder && this.nullIsLast == that.nullIsLast;
        }

        public int hashCode() {
            return Objects.hash(this.fieldIndex, this.isAscendingOrder, this.nullIsLast);
        }

        public String toString() {
            return "SortField{fieldIndex=" + this.fieldIndex + ", isAscendingOrder=" + this.isAscendingOrder + ", nullIsLast=" + this.nullIsLast + '}';
        }
    }

    public static class SortSpecBuilder {
        private final List<SortFieldSpec> fieldSpecs = new LinkedList<SortFieldSpec>();

        public SortSpecBuilder addField(int fieldIndex, boolean isAscendingOrder, boolean nullIsLast) {
            this.fieldSpecs.add(new SortFieldSpec(fieldIndex, isAscendingOrder, nullIsLast));
            return this;
        }

        public SortSpec build() {
            return new SortSpec(this.fieldSpecs.toArray(new SortFieldSpec[0]));
        }
    }
}

