/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.codegen;

import java.util.List;
import org.apache.paimon.codegen.CodeGenerator;
import org.apache.paimon.codegen.CodeGeneratorContext;
import org.apache.paimon.codegen.ComparatorCodeGenerator;
import org.apache.paimon.codegen.EqualiserCodeGenerator;
import org.apache.paimon.codegen.GeneratedClass;
import org.apache.paimon.codegen.NormalizedKeyComputer;
import org.apache.paimon.codegen.Projection;
import org.apache.paimon.codegen.ProjectionCodeGenerator;
import org.apache.paimon.codegen.RecordComparator;
import org.apache.paimon.codegen.RecordEqualiser;
import org.apache.paimon.codegen.SortCodeGenerator;
import org.apache.paimon.codegen.SortSpec;
import org.apache.paimon.types.DataType;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.TypeUtils;

public class CodeGeneratorImpl
implements CodeGenerator {
    public GeneratedClass<Projection> generateProjection(String name, RowType inputType, int[] inputMapping) {
        RowType outputType = TypeUtils.project((RowType)inputType, (int[])inputMapping);
        return ProjectionCodeGenerator.generateProjection((CodeGeneratorContext)new CodeGeneratorContext(), (String)name, (RowType)inputType, (RowType)outputType, (int[])inputMapping);
    }

    public GeneratedClass<NormalizedKeyComputer> generateNormalizedKeyComputer(List<DataType> fieldTypes, String name) {
        return new SortCodeGenerator(RowType.builder().fields(fieldTypes).build(), this.getAscendingSortSpec(fieldTypes.size())).generateNormalizedKeyComputer(name);
    }

    public GeneratedClass<RecordComparator> generateRecordComparator(List<DataType> fieldTypes, String name) {
        return ComparatorCodeGenerator.gen((String)name, (RowType)RowType.builder().fields(fieldTypes).build(), (SortSpec)this.getAscendingSortSpec(fieldTypes.size()));
    }

    public GeneratedClass<RecordEqualiser> generateRecordEqualiser(List<DataType> fieldTypes, String name) {
        return new EqualiserCodeGenerator(RowType.builder().fields(fieldTypes).build()).generateRecordEqualiser(name);
    }

    private SortSpec getAscendingSortSpec(int numFields) {
        SortSpec.SortSpecBuilder builder = SortSpec.builder();
        for (int i = 0; i < numFields; ++i) {
            builder.addField(i, true, false);
        }
        return builder.build();
    }
}

