/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.utils;

import org.apache.paimon.data.BinaryString;
import org.apache.paimon.data.Decimal;
import org.apache.paimon.data.InternalArray;
import org.apache.paimon.data.InternalMap;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.data.Timestamp;
import org.apache.paimon.types.RowKind;

public class OffsetRow
implements InternalRow {
    private final int arity;
    private final int offset;
    private InternalRow row;

    public OffsetRow(int arity, int offset) {
        this.arity = arity;
        this.offset = offset;
    }

    public OffsetRow replace(InternalRow row) {
        this.row = row;
        return this;
    }

    @Override
    public int getFieldCount() {
        return this.arity;
    }

    @Override
    public RowKind getRowKind() {
        return this.row.getRowKind();
    }

    @Override
    public void setRowKind(RowKind kind) {
        this.row.setRowKind(kind);
    }

    @Override
    public boolean isNullAt(int pos) {
        return this.row.isNullAt(this.offset + pos);
    }

    @Override
    public boolean getBoolean(int pos) {
        return this.row.getBoolean(this.offset + pos);
    }

    @Override
    public byte getByte(int pos) {
        return this.row.getByte(this.offset + pos);
    }

    @Override
    public short getShort(int pos) {
        return this.row.getShort(this.offset + pos);
    }

    @Override
    public int getInt(int pos) {
        return this.row.getInt(this.offset + pos);
    }

    @Override
    public long getLong(int pos) {
        return this.row.getLong(this.offset + pos);
    }

    @Override
    public float getFloat(int pos) {
        return this.row.getFloat(this.offset + pos);
    }

    @Override
    public double getDouble(int pos) {
        return this.row.getDouble(this.offset + pos);
    }

    @Override
    public BinaryString getString(int pos) {
        return this.row.getString(this.offset + pos);
    }

    @Override
    public Decimal getDecimal(int pos, int precision, int scale) {
        return this.row.getDecimal(this.offset + pos, precision, scale);
    }

    @Override
    public Timestamp getTimestamp(int pos, int precision) {
        return this.row.getTimestamp(this.offset + pos, precision);
    }

    @Override
    public byte[] getBinary(int pos) {
        return this.row.getBinary(this.offset + pos);
    }

    @Override
    public InternalArray getArray(int pos) {
        return this.row.getArray(this.offset + pos);
    }

    @Override
    public InternalMap getMap(int pos) {
        return this.row.getMap(this.offset + pos);
    }

    @Override
    public InternalRow getRow(int pos, int numFields) {
        return this.row.getRow(this.offset + pos, numFields);
    }
}

