/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.utils;

import org.apache.paimon.memory.MemorySegment;

public final class MurmurHashUtils {
    private static final int C1 = -862048943;
    private static final int C2 = 461845907;
    public static final int DEFAULT_SEED = 42;

    private MurmurHashUtils() {
    }

    public static int hashUnsafeBytesByWords(Object base, long offset, int lengthInBytes) {
        return MurmurHashUtils.hashUnsafeBytesByWords(base, offset, lengthInBytes, 42);
    }

    public static int hashBytesPositive(byte[] bytes) {
        return MurmurHashUtils.hashBytes(bytes) & Integer.MAX_VALUE;
    }

    public static int hashBytes(byte[] bytes) {
        return MurmurHashUtils.hashUnsafeBytes(bytes, MemorySegment.BYTE_ARRAY_BASE_OFFSET, bytes.length, 42);
    }

    public static int hashUnsafeBytes(Object base, long offset, int lengthInBytes) {
        return MurmurHashUtils.hashUnsafeBytes(base, offset, lengthInBytes, 42);
    }

    public static int hashBytesByWords(MemorySegment segment, int offset, int lengthInBytes) {
        return MurmurHashUtils.hashBytesByWords(segment, offset, lengthInBytes, 42);
    }

    public static int hashBytes(MemorySegment segment, int offset, int lengthInBytes) {
        return MurmurHashUtils.hashBytes(segment, offset, lengthInBytes, 42);
    }

    private static int hashUnsafeBytesByWords(Object base, long offset, int lengthInBytes, int seed) {
        int h1 = MurmurHashUtils.hashUnsafeBytesByInt(base, offset, lengthInBytes, seed);
        return MurmurHashUtils.fmix(h1, lengthInBytes);
    }

    private static int hashBytesByWords(MemorySegment segment, int offset, int lengthInBytes, int seed) {
        int h1 = MurmurHashUtils.hashBytesByInt(segment, offset, lengthInBytes, seed);
        return MurmurHashUtils.fmix(h1, lengthInBytes);
    }

    private static int hashBytes(MemorySegment segment, int offset, int lengthInBytes, int seed) {
        int lengthAligned = lengthInBytes - lengthInBytes % 4;
        int h1 = MurmurHashUtils.hashBytesByInt(segment, offset, lengthAligned, seed);
        for (int i = lengthAligned; i < lengthInBytes; ++i) {
            int k1 = MurmurHashUtils.mixK1(segment.get(offset + i));
            h1 = MurmurHashUtils.mixH1(h1, k1);
        }
        return MurmurHashUtils.fmix(h1, lengthInBytes);
    }

    private static int hashUnsafeBytes(Object base, long offset, int lengthInBytes, int seed) {
        assert (lengthInBytes >= 0) : "lengthInBytes cannot be negative";
        int lengthAligned = lengthInBytes - lengthInBytes % 4;
        int h1 = MurmurHashUtils.hashUnsafeBytesByInt(base, offset, lengthAligned, seed);
        for (int i = lengthAligned; i < lengthInBytes; ++i) {
            byte halfWord = MemorySegment.UNSAFE.getByte(base, offset + (long)i);
            int k1 = MurmurHashUtils.mixK1(halfWord);
            h1 = MurmurHashUtils.mixH1(h1, k1);
        }
        return MurmurHashUtils.fmix(h1, lengthInBytes);
    }

    private static int hashUnsafeBytesByInt(Object base, long offset, int lengthInBytes, int seed) {
        assert (lengthInBytes % 4 == 0);
        int h1 = seed;
        for (int i = 0; i < lengthInBytes; i += 4) {
            int halfWord = MemorySegment.UNSAFE.getInt(base, offset + (long)i);
            int k1 = MurmurHashUtils.mixK1(halfWord);
            h1 = MurmurHashUtils.mixH1(h1, k1);
        }
        return h1;
    }

    private static int hashBytesByInt(MemorySegment segment, int offset, int lengthInBytes, int seed) {
        assert (lengthInBytes % 4 == 0);
        int h1 = seed;
        for (int i = 0; i < lengthInBytes; i += 4) {
            int halfWord = segment.getInt(offset + i);
            int k1 = MurmurHashUtils.mixK1(halfWord);
            h1 = MurmurHashUtils.mixH1(h1, k1);
        }
        return h1;
    }

    private static int mixK1(int k1) {
        k1 *= -862048943;
        k1 = Integer.rotateLeft(k1, 15);
        return k1 *= 461845907;
    }

    private static int mixH1(int h1, int k1) {
        h1 ^= k1;
        h1 = Integer.rotateLeft(h1, 13);
        h1 = h1 * 5 + -430675100;
        return h1;
    }

    private static int fmix(int h1, int length) {
        return MurmurHashUtils.fmix(h1 ^= length);
    }

    public static int fmix(int h) {
        h ^= h >>> 16;
        h *= -2048144789;
        h ^= h >>> 13;
        h *= -1028477387;
        h ^= h >>> 16;
        return h;
    }

    public static long fmix(long h) {
        h ^= h >>> 33;
        h *= -49064778989728563L;
        h ^= h >>> 33;
        h *= -4265267296055464877L;
        h ^= h >>> 33;
        return h;
    }
}

