/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table.system;

import java.io.IOException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.paimon.Snapshot;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.data.GenericRow;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.data.Timestamp;
import org.apache.paimon.disk.IOManager;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.predicate.Predicate;
import org.apache.paimon.reader.RecordReader;
import org.apache.paimon.shade.guava30.com.google.common.collect.Iterators;
import org.apache.paimon.table.FileStoreTable;
import org.apache.paimon.table.ReadonlyTable;
import org.apache.paimon.table.Table;
import org.apache.paimon.table.source.InnerTableRead;
import org.apache.paimon.table.source.InnerTableScan;
import org.apache.paimon.table.source.ReadOnceTableScan;
import org.apache.paimon.table.source.Split;
import org.apache.paimon.table.source.TableRead;
import org.apache.paimon.table.source.TableScan;
import org.apache.paimon.types.BigIntType;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.RowType;
import org.apache.paimon.types.TimestampType;
import org.apache.paimon.utils.IteratorRecordReader;
import org.apache.paimon.utils.ProjectedRow;
import org.apache.paimon.utils.SerializationUtils;
import org.apache.paimon.utils.SnapshotManager;

public class SnapshotsTable
implements ReadonlyTable {
    private static final long serialVersionUID = 1L;
    public static final String SNAPSHOTS = "snapshots";
    public static final RowType TABLE_TYPE = new RowType(Arrays.asList(new DataField(0, "snapshot_id", new BigIntType(false)), new DataField(1, "schema_id", new BigIntType(false)), new DataField(2, "commit_user", SerializationUtils.newStringType(false)), new DataField(3, "commit_identifier", new BigIntType(false)), new DataField(4, "commit_kind", SerializationUtils.newStringType(false)), new DataField(5, "commit_time", new TimestampType(false, 3)), new DataField(6, "base_manifest_list", SerializationUtils.newStringType(false)), new DataField(7, "delta_manifest_list", SerializationUtils.newStringType(false)), new DataField(8, "changelog_manifest_list", SerializationUtils.newStringType(true)), new DataField(9, "total_record_count", new BigIntType(true)), new DataField(10, "delta_record_count", new BigIntType(true)), new DataField(11, "changelog_record_count", new BigIntType(true)), new DataField(12, "watermark", new BigIntType(true))));
    private final FileIO fileIO;
    private final Path location;
    private final FileStoreTable dataTable;

    public SnapshotsTable(FileIO fileIO, Path location, FileStoreTable dataTable) {
        this.fileIO = fileIO;
        this.location = location;
        this.dataTable = dataTable;
    }

    @Override
    public String name() {
        return this.location.getName() + "$" + SNAPSHOTS;
    }

    @Override
    public RowType rowType() {
        return TABLE_TYPE;
    }

    @Override
    public List<String> primaryKeys() {
        return Collections.singletonList("snapshot_id");
    }

    @Override
    public InnerTableScan newScan() {
        return new SnapshotsScan();
    }

    @Override
    public InnerTableRead newRead() {
        return new SnapshotsRead(this.fileIO);
    }

    @Override
    public Table copy(Map<String, String> dynamicOptions) {
        return new SnapshotsTable(this.fileIO, this.location, (FileStoreTable)this.dataTable.copy((Map)dynamicOptions));
    }

    private static class SnapshotsRead
    implements InnerTableRead {
        private final FileIO fileIO;
        private int[][] projection;

        public SnapshotsRead(FileIO fileIO) {
            this.fileIO = fileIO;
        }

        @Override
        public InnerTableRead withFilter(Predicate predicate) {
            return this;
        }

        @Override
        public InnerTableRead withProjection(int[][] projection) {
            this.projection = projection;
            return this;
        }

        @Override
        public TableRead withIOManager(IOManager ioManager) {
            return this;
        }

        @Override
        public RecordReader<InternalRow> createReader(Split split) throws IOException {
            if (!(split instanceof SnapshotsSplit)) {
                throw new IllegalArgumentException("Unsupported split: " + split.getClass());
            }
            Path location = ((SnapshotsSplit)split).location;
            Iterator<Snapshot> snapshots = new SnapshotManager(this.fileIO, location).snapshots();
            Iterator rows = Iterators.transform(snapshots, this::toRow);
            if (this.projection != null) {
                rows = Iterators.transform(rows, row -> ProjectedRow.from(this.projection).replaceRow((InternalRow)row));
            }
            return new IteratorRecordReader<InternalRow>(rows);
        }

        private InternalRow toRow(Snapshot snapshot) {
            return GenericRow.of(snapshot.id(), snapshot.schemaId(), BinaryString.fromString(snapshot.commitUser()), snapshot.commitIdentifier(), BinaryString.fromString(snapshot.commitKind().toString()), Timestamp.fromLocalDateTime(LocalDateTime.ofInstant(Instant.ofEpochMilli(snapshot.timeMillis()), ZoneId.systemDefault())), BinaryString.fromString(snapshot.baseManifestList()), BinaryString.fromString(snapshot.deltaManifestList()), BinaryString.fromString(snapshot.changelogManifestList()), snapshot.totalRecordCount(), snapshot.deltaRecordCount(), snapshot.changelogRecordCount(), snapshot.watermark());
        }
    }

    private static class SnapshotsSplit
    implements Split {
        private static final long serialVersionUID = 1L;
        private final long rowCount;
        private final Path location;

        private SnapshotsSplit(long rowCount, Path location) {
            this.location = location;
            this.rowCount = rowCount;
        }

        @Override
        public long rowCount() {
            return this.rowCount;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SnapshotsSplit that = (SnapshotsSplit)o;
            return Objects.equals(this.location, that.location);
        }

        public int hashCode() {
            return Objects.hash(this.location);
        }
    }

    private class SnapshotsScan
    extends ReadOnceTableScan {
        private SnapshotsScan() {
        }

        @Override
        public InnerTableScan withFilter(Predicate predicate) {
            return this;
        }

        @Override
        public TableScan.Plan innerPlan() {
            long rowCount;
            try {
                rowCount = new SnapshotManager(SnapshotsTable.this.fileIO, SnapshotsTable.this.location).snapshotCount();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return () -> Collections.singletonList(new SnapshotsSplit(rowCount, SnapshotsTable.this.location));
        }
    }
}

