/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.table.source.snapshot;

import org.apache.paimon.Snapshot;
import org.apache.paimon.table.source.snapshot.AbstractStartingScanner;
import org.apache.paimon.table.source.snapshot.SnapshotReader;
import org.apache.paimon.table.source.snapshot.StartingScanner;
import org.apache.paimon.utils.SnapshotManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContinuousCompactorStartingScanner
extends AbstractStartingScanner {
    private static final Logger LOG = LoggerFactory.getLogger(ContinuousCompactorStartingScanner.class);

    public ContinuousCompactorStartingScanner(SnapshotManager snapshotManager) {
        super(snapshotManager);
        this.startingSnapshotId = snapshotManager.earliestSnapshotId();
    }

    @Override
    public StartingScanner.Result scan(SnapshotReader snapshotReader) {
        Long latestSnapshotId = this.snapshotManager.latestSnapshotId();
        Long earliestSnapshotId = this.snapshotManager.earliestSnapshotId();
        if (latestSnapshotId == null || earliestSnapshotId == null) {
            LOG.debug("There is currently no snapshot. Wait for the snapshot generation.");
            return new StartingScanner.NoSnapshot();
        }
        for (long id = latestSnapshotId.longValue(); id >= earliestSnapshotId; --id) {
            Snapshot snapshot = this.snapshotManager.snapshot(id);
            if (snapshot.commitKind() != Snapshot.CommitKind.COMPACT) continue;
            LOG.debug("Found latest compact snapshot {}, reading from the next snapshot.", (Object)id);
            return new StartingScanner.NextSnapshot(id + 1L);
        }
        LOG.debug("No compact snapshot found, reading from the earliest snapshot {}.", (Object)earliestSnapshotId);
        return new StartingScanner.NextSnapshot(earliestSnapshotId);
    }
}

