/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.hive;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.time.Duration;
import java.util.Collections;
import java.util.concurrent.Callable;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.LockComponent;
import org.apache.hadoop.hive.metastore.api.LockLevel;
import org.apache.hadoop.hive.metastore.api.LockRequest;
import org.apache.hadoop.hive.metastore.api.LockResponse;
import org.apache.hadoop.hive.metastore.api.LockState;
import org.apache.hadoop.hive.metastore.api.LockType;
import org.apache.paimon.catalog.CatalogLock;
import org.apache.paimon.options.CatalogOptions;
import org.apache.paimon.utils.TimeUtils;
import org.apache.thrift.TException;

public class HiveCatalogLock
implements CatalogLock {
    static final String LOCK_IDENTIFIER = "hive";
    private final IMetaStoreClient client;
    private final long checkMaxSleep;
    private final long acquireTimeout;

    public HiveCatalogLock(IMetaStoreClient client, long checkMaxSleep, long acquireTimeout) {
        this.client = client;
        this.checkMaxSleep = checkMaxSleep;
        this.acquireTimeout = acquireTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> T runWithLock(String database, String table, Callable<T> callable) throws Exception {
        long lockId = this.lock(database, table);
        try {
            T t = callable.call();
            return t;
        }
        finally {
            this.unlock(lockId);
        }
    }

    private long lock(String database, String table) throws UnknownHostException, TException, InterruptedException {
        LockComponent lockComponent = new LockComponent(LockType.EXCLUSIVE, LockLevel.TABLE, database);
        lockComponent.setTablename(table);
        lockComponent.unsetOperationType();
        LockRequest lockRequest = new LockRequest(Collections.singletonList(lockComponent), System.getProperty("user.name"), InetAddress.getLocalHost().getHostName());
        LockResponse lockResponse = this.client.lock(lockRequest);
        long nextSleep = 50L;
        long startRetry = System.currentTimeMillis();
        while (lockResponse.getState() == LockState.WAITING) {
            if ((nextSleep *= 2L) > this.checkMaxSleep) {
                nextSleep = this.checkMaxSleep;
            }
            Thread.sleep(nextSleep);
            lockResponse = this.client.checkLock(lockResponse.getLockid());
            if (System.currentTimeMillis() - startRetry <= this.acquireTimeout) continue;
        }
        long retryDuration = System.currentTimeMillis() - startRetry;
        if (lockResponse.getState() != LockState.ACQUIRED) {
            if (lockResponse.getState() == LockState.WAITING) {
                this.client.unlock(lockResponse.getLockid());
            }
            throw new RuntimeException("Acquire lock failed with time: " + Duration.ofMillis(retryDuration));
        }
        return lockResponse.getLockid();
    }

    private void unlock(long lockId) throws TException {
        this.client.unlock(lockId);
    }

    @Override
    public void close() {
        this.client.close();
    }

    public static long checkMaxSleep(HiveConf conf) {
        return TimeUtils.parseDuration(conf.get(CatalogOptions.LOCK_CHECK_MAX_SLEEP.key(), TimeUtils.getStringInMillis(CatalogOptions.LOCK_CHECK_MAX_SLEEP.defaultValue()))).toMillis();
    }

    public static long acquireTimeout(HiveConf conf) {
        return TimeUtils.parseDuration(conf.get(CatalogOptions.LOCK_ACQUIRE_TIMEOUT.key(), TimeUtils.getStringInMillis(CatalogOptions.LOCK_ACQUIRE_TIMEOUT.defaultValue()))).toMillis();
    }
}

