/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.format.orc.filter;

import java.io.IOException;
import java.sql.Date;
import java.util.List;
import java.util.stream.IntStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.paimon.data.BinaryString;
import org.apache.paimon.data.Decimal;
import org.apache.paimon.data.Timestamp;
import org.apache.paimon.format.FieldStats;
import org.apache.paimon.format.TableStatsExtractor;
import org.apache.paimon.format.orc.OrcReaderFactory;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.shade.org.apache.orc.BooleanColumnStatistics;
import org.apache.paimon.shade.org.apache.orc.ColumnStatistics;
import org.apache.paimon.shade.org.apache.orc.DateColumnStatistics;
import org.apache.paimon.shade.org.apache.orc.DecimalColumnStatistics;
import org.apache.paimon.shade.org.apache.orc.DoubleColumnStatistics;
import org.apache.paimon.shade.org.apache.orc.IntegerColumnStatistics;
import org.apache.paimon.shade.org.apache.orc.Reader;
import org.apache.paimon.shade.org.apache.orc.StringColumnStatistics;
import org.apache.paimon.shade.org.apache.orc.TimestampColumnStatistics;
import org.apache.paimon.shade.org.apache.orc.TypeDescription;
import org.apache.paimon.statistics.FieldStatsCollector;
import org.apache.paimon.types.DataField;
import org.apache.paimon.types.DecimalType;
import org.apache.paimon.types.RowType;
import org.apache.paimon.utils.DateTimeUtils;
import org.apache.paimon.utils.Pair;
import org.apache.paimon.utils.Preconditions;

public class OrcTableStatsExtractor
implements TableStatsExtractor {
    private final RowType rowType;
    private final FieldStatsCollector.Factory[] statsCollectors;

    public OrcTableStatsExtractor(RowType rowType, FieldStatsCollector.Factory[] statsCollectors) {
        this.rowType = rowType;
        this.statsCollectors = statsCollectors;
        Preconditions.checkArgument(rowType.getFieldCount() == statsCollectors.length, "The stats collector is not aligned to write schema.");
    }

    @Override
    public FieldStats[] extract(FileIO fileIO, Path path) throws IOException {
        return this.extractWithFileInfo(fileIO, path).getLeft();
    }

    @Override
    public Pair<FieldStats[], TableStatsExtractor.FileInfo> extractWithFileInfo(FileIO fileIO, Path path) throws IOException {
        try (Reader reader = OrcReaderFactory.createReader(new Configuration(), fileIO, path);){
            long rowCount = reader.getNumberOfRows();
            ColumnStatistics[] columnStatistics = reader.getStatistics();
            TypeDescription schema = reader.getSchema();
            List<String> columnNames = schema.getFieldNames();
            List<TypeDescription> columnTypes = schema.getChildren();
            FieldStatsCollector[] collectors = FieldStatsCollector.create(this.statsCollectors);
            Pair<A[], TableStatsExtractor.FileInfo> pair = Pair.of(IntStream.range(0, this.rowType.getFieldCount()).mapToObj(i -> {
                DataField field = this.rowType.getFields().get(i);
                int fieldIdx = columnNames.indexOf(field.name());
                if (fieldIdx == -1) {
                    return collectors[i].convert(new FieldStats(null, null, null));
                }
                int colId = ((TypeDescription)columnTypes.get(fieldIdx)).getId();
                return this.toFieldStats(field, columnStatistics[colId], rowCount, collectors[i]);
            }).toArray(FieldStats[]::new), new TableStatsExtractor.FileInfo(rowCount));
            return pair;
        }
    }

    private FieldStats toFieldStats(DataField field, ColumnStatistics stats, long rowCount, FieldStatsCollector collector) {
        FieldStats fieldStats;
        long nullCount = rowCount - stats.getNumberOfValues();
        if (nullCount == rowCount) {
            return collector.convert(new FieldStats(null, null, nullCount));
        }
        Preconditions.checkState(nullCount > 0L == stats.hasNull(), "Bug in OrcFileStatsExtractor: nullCount is " + nullCount + " while stats.hasNull() is " + stats.hasNull() + "!");
        switch (field.type().getTypeRoot()) {
            case CHAR: 
            case VARCHAR: {
                this.assertStatsClass(field, stats, StringColumnStatistics.class);
                StringColumnStatistics stringStats = (StringColumnStatistics)stats;
                fieldStats = new FieldStats(BinaryString.fromString(stringStats.getMinimum()), BinaryString.fromString(stringStats.getMaximum()), nullCount);
                break;
            }
            case BOOLEAN: {
                this.assertStatsClass(field, stats, BooleanColumnStatistics.class);
                BooleanColumnStatistics boolStats = (BooleanColumnStatistics)stats;
                fieldStats = new FieldStats(boolStats.getFalseCount() == 0L, boolStats.getTrueCount() != 0L, nullCount);
                break;
            }
            case DECIMAL: {
                this.assertStatsClass(field, stats, DecimalColumnStatistics.class);
                DecimalColumnStatistics decimalStats = (DecimalColumnStatistics)stats;
                DecimalType decimalType = (DecimalType)field.type();
                int precision = decimalType.getPrecision();
                int scale = decimalType.getScale();
                fieldStats = new FieldStats(Decimal.fromBigDecimal(decimalStats.getMinimum().bigDecimalValue(), precision, scale), Decimal.fromBigDecimal(decimalStats.getMaximum().bigDecimalValue(), precision, scale), nullCount);
                break;
            }
            case TINYINT: {
                this.assertStatsClass(field, stats, IntegerColumnStatistics.class);
                IntegerColumnStatistics byteStats = (IntegerColumnStatistics)stats;
                fieldStats = new FieldStats((byte)byteStats.getMinimum(), (byte)byteStats.getMaximum(), nullCount);
                break;
            }
            case SMALLINT: {
                this.assertStatsClass(field, stats, IntegerColumnStatistics.class);
                IntegerColumnStatistics shortStats = (IntegerColumnStatistics)stats;
                fieldStats = new FieldStats((short)shortStats.getMinimum(), (short)shortStats.getMaximum(), nullCount);
                break;
            }
            case INTEGER: 
            case TIME_WITHOUT_TIME_ZONE: {
                this.assertStatsClass(field, stats, IntegerColumnStatistics.class);
                IntegerColumnStatistics intStats = (IntegerColumnStatistics)stats;
                fieldStats = new FieldStats(Long.valueOf(intStats.getMinimum()).intValue(), Long.valueOf(intStats.getMaximum()).intValue(), nullCount);
                break;
            }
            case BIGINT: {
                this.assertStatsClass(field, stats, IntegerColumnStatistics.class);
                IntegerColumnStatistics longStats = (IntegerColumnStatistics)stats;
                fieldStats = new FieldStats(longStats.getMinimum(), longStats.getMaximum(), nullCount);
                break;
            }
            case FLOAT: {
                this.assertStatsClass(field, stats, DoubleColumnStatistics.class);
                DoubleColumnStatistics floatStats = (DoubleColumnStatistics)stats;
                fieldStats = new FieldStats(Float.valueOf((float)floatStats.getMinimum()), Float.valueOf((float)floatStats.getMaximum()), nullCount);
                break;
            }
            case DOUBLE: {
                this.assertStatsClass(field, stats, DoubleColumnStatistics.class);
                DoubleColumnStatistics doubleStats = (DoubleColumnStatistics)stats;
                fieldStats = new FieldStats(doubleStats.getMinimum(), doubleStats.getMaximum(), nullCount);
                break;
            }
            case DATE: {
                this.assertStatsClass(field, stats, DateColumnStatistics.class);
                DateColumnStatistics dateStats = (DateColumnStatistics)stats;
                fieldStats = new FieldStats(DateTimeUtils.toInternal(new Date(dateStats.getMinimum().getTime())), DateTimeUtils.toInternal(new Date(dateStats.getMaximum().getTime())), nullCount);
                break;
            }
            case TIMESTAMP_WITHOUT_TIME_ZONE: 
            case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                this.assertStatsClass(field, stats, TimestampColumnStatistics.class);
                TimestampColumnStatistics timestampStats = (TimestampColumnStatistics)stats;
                fieldStats = new FieldStats(Timestamp.fromSQLTimestamp(timestampStats.getMinimum()), Timestamp.fromSQLTimestamp(timestampStats.getMaximum()), nullCount);
                break;
            }
            default: {
                fieldStats = new FieldStats(null, null, nullCount);
            }
        }
        return collector.convert(fieldStats);
    }

    private void assertStatsClass(DataField field, ColumnStatistics stats, Class<? extends ColumnStatistics> expectedClass) {
        if (!expectedClass.isInstance(stats)) {
            throw new IllegalArgumentException("Expecting " + expectedClass.getName() + " for field " + field.asSQLString() + " but found " + stats.getClass().getName());
        }
    }
}

