/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.container;

import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.InjectionPoint;
import jakarta.enterprise.inject.spi.InjectionTarget;
import java.util.Set;
import org.apache.webbeans.component.BeanAttributesImpl;
import org.apache.webbeans.component.creation.BeanAttributesBuilder;
import org.apache.webbeans.component.creation.ManagedBeanBuilder;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.container.InjectionTargetFactoryImpl;
import org.apache.webbeans.portable.InjectionTargetImpl;

public class ValidatingInjectionTargetFactory<T>
extends InjectionTargetFactoryImpl<T> {
    public ValidatingInjectionTargetFactory(AnnotatedType<T> annotatedType, WebBeansContext webBeansContext) {
        super(annotatedType, webBeansContext);
    }

    @Override
    public InjectionTarget<T> createInjectionTarget(Bean<T> bean) {
        AnnotatedType annotatedType = this.getAnnotatedType();
        InjectionTargetImpl injectionTarget = (InjectionTargetImpl)super.createInjectionTarget(bean);
        Set<InjectionPoint> injectionPoints = injectionTarget.getInjectionPoints();
        try {
            this.getWebBeansContext().getWebBeansUtil().validate(injectionPoints, null);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Problem while creating InjectionTarget", e);
        }
        if (this.getWebBeansContext().getWebBeansUtil().getNoArgConstructor(annotatedType.getJavaClass()) != null) {
            if (bean == null) {
                bean = this.getWebBeansContext().getBeanManagerImpl().getUnmanagedClassBeans().computeIfAbsent(annotatedType.getJavaClass(), c -> {
                    BeanAttributesImpl attributes = BeanAttributesBuilder.forContext(this.getWebBeansContext()).newBeanAttibutes(annotatedType).build();
                    ManagedBeanBuilder managedBeanCreator = new ManagedBeanBuilder(this.getWebBeansContext(), annotatedType, attributes, false);
                    return managedBeanCreator.getBean();
                });
            }
            injectionTarget.defineInterceptorStack(bean, annotatedType, this.getWebBeansContext());
        }
        return injectionTarget;
    }
}

