/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.context;

import java.io.Externalizable;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.inject.spi.Bean;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.context.AbstractContext;
import org.apache.webbeans.util.WebBeansUtil;

public abstract class PassivatingContext
extends AbstractContext
implements Externalizable {
    public PassivatingContext(Class<? extends Annotation> scopeType) {
        super(scopeType);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        WebBeansContext webBeansContext = WebBeansContext.currentInstance();
        this.scopeType = (Class)in.readObject();
        Map map = (Map)in.readObject();
        this.setComponentInstanceMap();
        for (Map.Entry beanBagEntry : map.entrySet()) {
            Bean<?> contextual;
            String id = (String)beanBagEntry.getKey();
            if (id == null || (contextual = webBeansContext.getBeanManagerImpl().getPassivationCapableBean(id)) == null) continue;
            this.componentInstanceMap.put(contextual, beanBagEntry.getValue());
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.scopeType);
        HashMap map = new HashMap(this.componentInstanceMap.size());
        for (Map.Entry beanBagEntry : this.componentInstanceMap.entrySet()) {
            Contextual contextual = (Contextual)beanBagEntry.getKey();
            String id = WebBeansUtil.getPassivationId(contextual);
            if (id == null) {
                throw new NotSerializableException("cannot serialize " + contextual.toString());
            }
            map.put(id, beanBagEntry.getValue());
        }
        out.writeObject(map);
    }
}

