/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.intercept;

import java.io.Externalizable;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.enterprise.inject.spi.InterceptionType;
import javax.enterprise.inject.spi.Interceptor;
import javax.inject.Provider;
import org.apache.webbeans.component.InjectionTargetBean;
import org.apache.webbeans.component.SelfInterceptorBean;
import org.apache.webbeans.component.WebBeansType;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.container.BeanManagerImpl;
import org.apache.webbeans.intercept.InterceptorInvocationContext;
import org.apache.webbeans.intercept.InterceptorResolutionService;
import org.apache.webbeans.portable.InjectionTargetImpl;
import org.apache.webbeans.proxy.InterceptorHandler;
import org.apache.webbeans.util.ExceptionUtil;
import org.apache.webbeans.util.WebBeansUtil;

public class DefaultInterceptorHandler<T>
implements InterceptorHandler,
Externalizable {
    private static final String SELF_KEY = "SELF_INTERCEPTOR";
    private T target;
    private T delegate;
    private String beanPassivationId;
    private Map<Method, List<Interceptor<?>>> interceptors;
    private Map<Interceptor<?>, ?> instances;

    public DefaultInterceptorHandler(T target, T delegate, Map<Method, List<Interceptor<?>>> interceptors, Map<Interceptor<?>, ?> instances, String beanPassivationId) {
        this.target = target;
        this.delegate = delegate;
        this.instances = instances;
        this.interceptors = interceptors;
        this.beanPassivationId = beanPassivationId;
    }

    public DefaultInterceptorHandler() {
    }

    public T getTarget() {
        return this.target;
    }

    public T getDelegate() {
        return this.delegate;
    }

    public Map<Interceptor<?>, ?> getInstances() {
        return this.instances;
    }

    public Map<Method, List<Interceptor<?>>> getInterceptors() {
        return this.interceptors;
    }

    @Override
    public Object invoke(Method method, Object[] parameters) {
        try {
            List<Object> methodInterceptors = this.interceptors.get(method);
            if (methodInterceptors == null) {
                methodInterceptors = Collections.emptyList();
            }
            InterceptorInvocationContext<T> ctx = new InterceptorInvocationContext<T>(new InstanceProvider<T>(this.delegate), InterceptionType.AROUND_INVOKE, methodInterceptors, this.instances, method, parameters);
            return ctx.proceed();
        }
        catch (Exception e) {
            return ExceptionUtil.throwAsRuntimeException(e);
        }
    }

    Object readResolve() throws ObjectStreamException {
        WebBeansContext webBeansContext = WebBeansContext.getInstance();
        BeanManagerImpl beanManager = webBeansContext.getBeanManagerImpl();
        Bean bean = beanManager.getPassivationCapableBean(this.beanPassivationId);
        return webBeansContext.getInterceptorDecoratorProxyFactory().createProxyInstance(webBeansContext.getInterceptorDecoratorProxyFactory().getCachedProxyClass(bean), this.target, this);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        Object key;
        out.writeObject(this.target);
        boolean noDecorator = this.target == this.delegate;
        out.writeBoolean(noDecorator);
        if (!noDecorator) {
            out.writeObject(this.delegate);
        }
        out.writeInt(this.instances.size());
        for (Map.Entry<Interceptor<?>, ?> entry : this.instances.entrySet()) {
            key = entry.getKey();
            if (!DefaultInterceptorHandler.serializeInterceptor(out, key)) continue;
            out.writeObject(entry.getValue());
        }
        out.writeInt(this.interceptors.size());
        for (Map.Entry<Object, Object> entry : this.interceptors.entrySet()) {
            key = (Method)entry.getKey();
            out.writeObject(((Method)key).getDeclaringClass());
            out.writeUTF(((Method)key).getName());
            out.writeObject(((Method)key).getParameterTypes());
            List value = (List)entry.getValue();
            out.writeInt(value.size());
            for (Interceptor i : value) {
                DefaultInterceptorHandler.serializeInterceptor(out, i);
            }
        }
        out.writeUTF(this.beanPassivationId);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.target = in.readObject();
        this.delegate = in.readBoolean() ? this.target : in.readObject();
        int instancesSize = in.readInt();
        WebBeansContext webBeansContext = WebBeansContext.getInstance();
        BeanManagerImpl beanManager = webBeansContext.getBeanManagerImpl();
        HashMap tmpInstances = new HashMap();
        for (int i = 0; i < instancesSize; ++i) {
            Interceptor<?> interceptor = DefaultInterceptorHandler.readInterceptor(in.readUTF(), beanManager);
            if (!SelfInterceptorBean.class.isInstance(interceptor)) {
                Object value = in.readObject();
                tmpInstances.put(interceptor, value);
                continue;
            }
            tmpInstances.put(interceptor, this.target);
        }
        this.instances = tmpInstances;
        int interceptorsSize = in.readInt();
        this.interceptors = new HashMap(interceptorsSize);
        for (int i = 0; i < interceptorsSize; ++i) {
            Method method;
            Class declaringClass = (Class)in.readObject();
            String name = in.readUTF();
            Class[] parameters = (Class[])in.readObject();
            try {
                method = declaringClass.getDeclaredMethod(name, parameters);
            }
            catch (NoSuchMethodException e) {
                throw new NotSerializableException(this.target.getClass().getName());
            }
            int interceptorListSize = in.readInt();
            ArrayList interceptorList = new ArrayList(interceptorListSize);
            for (int j = 0; j < interceptorListSize; ++j) {
                interceptorList.add(DefaultInterceptorHandler.readInterceptor(in.readUTF(), beanManager));
            }
            this.interceptors.put(method, interceptorList);
        }
        this.beanPassivationId = in.readUTF();
    }

    private static boolean serializeInterceptor(ObjectOutput out, Interceptor<?> key) throws IOException {
        if (SelfInterceptorBean.class.isInstance(key)) {
            String beanName = WebBeansUtil.getPassivationId(key).replace(WebBeansType.INTERCEPTOR.name(), WebBeansType.MANAGED.name());
            out.writeUTF(SELF_KEY + beanName);
            return false;
        }
        String id = WebBeansUtil.getPassivationId(key);
        if (id == null) {
            throw new NotSerializableException(key + " is not serializable");
        }
        out.writeUTF(id);
        return true;
    }

    private static Interceptor<?> readInterceptor(String id, BeanManager beanManager) throws IOException {
        if (id.startsWith(SELF_KEY)) {
            Bean bean = beanManager.getPassivationCapableBean(id.substring(SELF_KEY.length()));
            if (InjectionTargetBean.class.isInstance(bean)) {
                InjectionTarget it = ((InjectionTargetBean)InjectionTargetBean.class.cast(bean)).getInjectionTarget();
                if (InjectionTargetImpl.class.isInstance(it)) {
                    InterceptorResolutionService.BeanInterceptorInfo info = ((InjectionTargetImpl)InjectionTargetImpl.class.cast(it)).getInterceptorInfo();
                    return info.getSelfInterceptorBean();
                }
                throw new NotSerializableException("Can't find self interceptor");
            }
            throw new NotSerializableException("Can't find self interceptor");
        }
        return (Interceptor)beanManager.getPassivationCapableBean(id);
    }

    private static class InstanceProvider<T>
    implements Provider<T> {
        private final T value;

        public InstanceProvider(T delegate) {
            this.value = delegate;
        }

        public T get() {
            return this.value;
        }
    }
}

