/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.container;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.el.ELResolver;
import javax.el.ExpressionFactory;
import javax.enterprise.context.ContextNotActiveException;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.NormalScope;
import javax.enterprise.context.spi.AlterableContext;
import javax.enterprise.context.spi.Context;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.event.Event;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.InjectionException;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.Stereotype;
import javax.enterprise.inject.Vetoed;
import javax.enterprise.inject.spi.AnnotatedField;
import javax.enterprise.inject.spi.AnnotatedMember;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanAttributes;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Decorator;
import javax.enterprise.inject.spi.DefinitionException;
import javax.enterprise.inject.spi.DeploymentException;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.enterprise.inject.spi.InjectionTargetFactory;
import javax.enterprise.inject.spi.InterceptionFactory;
import javax.enterprise.inject.spi.InterceptionType;
import javax.enterprise.inject.spi.Interceptor;
import javax.enterprise.inject.spi.ObserverMethod;
import javax.enterprise.inject.spi.PassivationCapable;
import javax.enterprise.inject.spi.Producer;
import javax.enterprise.inject.spi.ProducerFactory;
import javax.inject.Scope;
import javax.interceptor.InterceptorBinding;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import org.apache.webbeans.annotation.AnyLiteral;
import org.apache.webbeans.annotation.DefaultLiteral;
import org.apache.webbeans.component.AbstractOwbBean;
import org.apache.webbeans.component.AbstractProducerBean;
import org.apache.webbeans.component.CdiInterceptorBean;
import org.apache.webbeans.component.DecoratorBean;
import org.apache.webbeans.component.EnterpriseBeanMarker;
import org.apache.webbeans.component.InjectionTargetBean;
import org.apache.webbeans.component.JmsBeanMarker;
import org.apache.webbeans.component.ManagedBean;
import org.apache.webbeans.component.NewBean;
import org.apache.webbeans.component.OwbBean;
import org.apache.webbeans.component.ProducerAwareInjectionTargetBean;
import org.apache.webbeans.component.WebBeansType;
import org.apache.webbeans.component.creation.BeanAttributesBuilder;
import org.apache.webbeans.component.creation.CdiInterceptorBeanBuilder;
import org.apache.webbeans.component.creation.DecoratorBeanBuilder;
import org.apache.webbeans.component.creation.FieldProducerFactory;
import org.apache.webbeans.component.creation.MethodProducerFactory;
import org.apache.webbeans.component.third.PassivationCapableThirdpartyBeanImpl;
import org.apache.webbeans.component.third.ThirdpartyBeanImpl;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.container.AnnotatedTypeWrapper;
import org.apache.webbeans.container.ExternalScope;
import org.apache.webbeans.container.InjectionResolver;
import org.apache.webbeans.container.InjectionTargetFactoryImpl;
import org.apache.webbeans.container.InterceptionFactoryImpl;
import org.apache.webbeans.container.ManagerObjectFactory;
import org.apache.webbeans.container.OwbCDI;
import org.apache.webbeans.container.SerializableBean;
import org.apache.webbeans.context.CustomAlterablePassivatingContextImpl;
import org.apache.webbeans.context.CustomPassivatingContextImpl;
import org.apache.webbeans.context.creational.CreationalContextImpl;
import org.apache.webbeans.decorator.DecoratorComparator;
import org.apache.webbeans.event.EventImpl;
import org.apache.webbeans.event.EventMetadataImpl;
import org.apache.webbeans.exception.DuplicateDefinitionException;
import org.apache.webbeans.exception.WebBeansConfigurationException;
import org.apache.webbeans.intercept.InterceptorUtil;
import org.apache.webbeans.plugins.OpenWebBeansJmsPlugin;
import org.apache.webbeans.portable.AnnotatedElementFactory;
import org.apache.webbeans.portable.LazyInterceptorDefinedInjectionTarget;
import org.apache.webbeans.portable.events.discovery.ErrorStack;
import org.apache.webbeans.portable.events.generics.GProcessInjectionPoint;
import org.apache.webbeans.portable.events.generics.GProcessInjectionTarget;
import org.apache.webbeans.spi.adaptor.ELAdaptor;
import org.apache.webbeans.spi.plugins.OpenWebBeansEjbPlugin;
import org.apache.webbeans.util.AnnotationUtil;
import org.apache.webbeans.util.Asserts;
import org.apache.webbeans.util.ClassUtil;
import org.apache.webbeans.util.GenericsUtil;
import org.apache.webbeans.util.WebBeansUtil;

public class BeanManagerImpl
implements BeanManager,
Referenceable {
    private static final long serialVersionUID = 2L;
    private Map<Class<? extends Annotation>, List<Context>> contextMap = new HashMap<Class<? extends Annotation>, List<Context>>();
    private Map<Class<? extends Annotation>, Context> singleContextMap = new HashMap<Class<? extends Annotation>, Context>();
    private Set<Bean<?>> deploymentBeans = new HashSet();
    private Map<Contextual<?>, Object> cacheProxies = new ConcurrentHashMap();
    private InjectionResolver injectionResolver;
    private List<Class<? extends Annotation>> additionalQualifiers = new ArrayList<Class<? extends Annotation>>();
    private Map<Class<?>, AnnotatedType<? extends Annotation>> additionalAnnotatedTypeQualifiers = new HashMap();
    private List<ExternalScope> additionalScopes = new ArrayList<ExternalScope>();
    private Set<Class<? extends Annotation>> scopeAnnotations = new HashSet<Class<? extends Annotation>>();
    private Set<Class<? extends Annotation>> nonscopeAnnotations = new HashSet<Class<? extends Annotation>>();
    private ConcurrentMap<Class<?>, ConcurrentMap<String, AnnotatedType<?>>> additionalAnnotatedTypes = new ConcurrentHashMap();
    private ErrorStack errorStack = new ErrorStack();
    private ConcurrentMap<String, Bean<?>> passivationBeans = new ConcurrentHashMap();
    private Map<Class<?>, Producer<?>> producersForJavaEeComponents = new ConcurrentHashMap();
    private AnnotatedElementFactory annotatedElementFactory;
    private final WebBeansContext webBeansContext;
    private boolean inUse;
    private LifecycleState beanDiscoveryState = LifecycleState.BEFORE_DISCOVERY;
    private boolean afterDeploymentValidationFired;
    private static Map<Class<? extends Annotation>, Boolean> isScopeTypeNormalCache = new ConcurrentHashMap<Class<? extends Annotation>, Boolean>();
    private Map<Bean<?>, Bean<?>> thirdPartyMapping = new HashMap();

    public BeanManagerImpl(WebBeansContext webBeansContext) {
        this.webBeansContext = webBeansContext;
        this.injectionResolver = new InjectionResolver(webBeansContext);
        this.annotatedElementFactory = webBeansContext.getAnnotatedElementFactory();
    }

    public WebBeansContext getWebBeansContext() {
        return this.webBeansContext;
    }

    public <T> void putProducerForJavaEeComponent(Class<T> javaEeComponentClass, Producer<T> wrapper) {
        Asserts.assertNotNull(javaEeComponentClass);
        Asserts.assertNotNull(wrapper);
        this.producersForJavaEeComponents.put(javaEeComponentClass, wrapper);
    }

    public <T> Producer<T> getProducerForJavaEeComponent(Class<T> javaEeComponentClass) {
        Asserts.assertNotNull(javaEeComponentClass);
        return this.producersForJavaEeComponents.get(javaEeComponentClass);
    }

    public ErrorStack getErrorStack() {
        return this.errorStack;
    }

    public InjectionResolver getInjectionResolver() {
        return this.injectionResolver;
    }

    public Context getContext(Class<? extends Annotation> scopeType) {
        Asserts.assertNotNull(scopeType, "scopeType");
        Context standardContext = this.webBeansContext.getContextsService().getCurrentContext(scopeType);
        if (standardContext != null && standardContext.isActive()) {
            return standardContext;
        }
        Context singleContext = this.singleContextMap.get(scopeType);
        if (singleContext != null) {
            if (!singleContext.isActive()) {
                throw new ContextNotActiveException("WebBeans context with scope type annotation @" + scopeType.getSimpleName() + " does not exist within current thread");
            }
            return singleContext;
        }
        List<Context> others = this.contextMap.get(scopeType);
        Context found = null;
        if (others != null) {
            for (Context otherContext : others) {
                if (!otherContext.isActive()) continue;
                if (found != null) {
                    throw new IllegalStateException("More than one active context exists with scope type annotation @" + scopeType.getSimpleName());
                }
                found = otherContext;
            }
        }
        if (found == null) {
            throw new ContextNotActiveException("WebBeans context with scope type annotation @" + scopeType.getSimpleName() + " does not exist within current thread");
        }
        return found;
    }

    public Instance<Object> createInstance() {
        return OwbCDI.current().select(new Annotation[]{DefaultLiteral.INSTANCE});
    }

    public BeanManager addBean(Bean<?> newBean) {
        this.inUse = true;
        return this.addInternalBean(newBean);
    }

    public <T> BeanManager addInternalBean(Bean<T> newBean) {
        if (newBean instanceof AbstractOwbBean) {
            this.addPassivationInfo(newBean);
            this.deploymentBeans.add(newBean);
        } else {
            ThirdpartyBeanImpl<T> bean = !PassivationCapable.class.isInstance(newBean) ? new ThirdpartyBeanImpl<T>(this.webBeansContext, newBean) : new PassivationCapableThirdpartyBeanImpl<T>(this.webBeansContext, newBean);
            this.addPassivationInfo(bean);
            this.deploymentBeans.add(bean);
            this.thirdPartyMapping.put(newBean, bean);
        }
        return this;
    }

    public void addPassivationInfo(Bean<?> bean) throws DefinitionException {
        Bean<?> oldBean;
        String id = null;
        if (bean instanceof OwbBean) {
            id = ((OwbBean)bean).getId();
        }
        if (id == null && bean instanceof PassivationCapable) {
            id = ((PassivationCapable)bean).getId();
        }
        if (id != null && (oldBean = this.passivationBeans.putIfAbsent(id, bean)) != null) {
            throw new DuplicateDefinitionException("PassivationCapable bean id is not unique: " + id + " bean:" + bean + ", existing: " + oldBean);
        }
    }

    public BeanManager addContext(Context context) {
        this.addContext(context.getScope(), this.wrapCustomContext(context));
        return this;
    }

    public Context wrapCustomContext(Context context) {
        if (this.isPassivatingScope(context.getScope())) {
            if (context instanceof AlterableContext) {
                return new CustomAlterablePassivatingContextImpl(this.webBeansContext.getSerializableBeanVault(), (AlterableContext)context);
            }
            return new CustomPassivatingContextImpl(this.webBeansContext.getSerializableBeanVault(), context);
        }
        return context;
    }

    public void fireEvent(Object event, Annotation ... bindings) {
        this.fireEvent(event, false, bindings);
    }

    public Event<Object> getEvent() {
        return new EventImpl<Object>(new EventMetadataImpl(null, (Type)((Object)Object.class), null, new Annotation[]{AnyLiteral.INSTANCE}, this.webBeansContext), this.webBeansContext);
    }

    public void fireEvent(Object event, boolean containerEvent, Annotation ... bindings) {
        Type type = event.getClass();
        if (GenericsUtil.hasTypeParameters(type)) {
            type = GenericsUtil.getParameterizedType(type);
        }
        this.fireEvent(event, new EventMetadataImpl(null, type, null, bindings, this.webBeansContext), containerEvent);
    }

    public void fireContextLifecyleEvent(Object payload, Annotation lifecycleQualifier) {
        if (this.webBeansContext.getNotificationManager().hasContextLifecycleObserver(lifecycleQualifier)) {
            this.fireEvent(payload, lifecycleQualifier);
        }
    }

    public void fireLifecycleEvent(Object event, Annotation ... bindings) {
        this.fireEvent(event, new EventMetadataImpl(null, event.getClass(), null, bindings, this.webBeansContext), true);
    }

    public void fireEvent(Object event, EventMetadataImpl metadata, boolean isLifecycleEvent) {
        this.webBeansContext.getNotificationManager().fireEvent(event, metadata, isLifecycleEvent, null);
    }

    public Set<Bean<?>> getComponents() {
        return this.deploymentBeans;
    }

    public List<Decorator<?>> resolveDecorators(Set<Type> types, Annotation ... bindingTypes) {
        this.webBeansContext.getAnnotationManager().checkDecoratorResolverParams(types, bindingTypes);
        return this.unsafeResolveDecorators(types, bindingTypes);
    }

    public List<Decorator<?>> unsafeResolveDecorators(Set<Type> types, Annotation[] bindingTypes) {
        this.webBeansContext.getAnnotationManager().checkQualifiersParams(types, bindingTypes);
        Set<Decorator<?>> intsSet = this.webBeansContext.getDecoratorsManager().findDeployedWebBeansDecorator(types, bindingTypes);
        ArrayList decoratorList = new ArrayList(intsSet);
        Collections.sort(decoratorList, new DecoratorComparator(this.webBeansContext));
        return decoratorList;
    }

    public List<Interceptor<?>> resolveInterceptors(InterceptionType type, Annotation ... interceptorBindings) {
        this.webBeansContext.getAnnotationManager().checkInterceptorResolverParams(interceptorBindings);
        return this.webBeansContext.getInterceptorsManager().resolveInterceptors(type, interceptorBindings);
    }

    public Set<Bean<?>> getBeans() {
        return this.deploymentBeans;
    }

    private void addContext(Class<? extends Annotation> scopeType, Context context) {
        Asserts.assertNotNull(scopeType, "scopeType");
        Asserts.assertNotNull(context, "context");
        List<Context> contextList = this.contextMap.get(scopeType);
        if (contextList == null) {
            Context singleContext = this.singleContextMap.get(scopeType);
            if (singleContext == null) {
                this.singleContextMap.put(scopeType, context);
            } else {
                contextList = new ArrayList<Context>();
                contextList.add(singleContext);
                contextList.add(context);
                this.contextMap.put(scopeType, contextList);
                this.singleContextMap.remove(scopeType);
            }
        } else {
            contextList.add(context);
        }
    }

    @Override
    public Reference getReference() throws NamingException {
        return new Reference(BeanManagerImpl.class.getName(), new StringRefAddr("ManagerImpl", "ManagerImpl"), ManagerObjectFactory.class.getName(), null);
    }

    public <T> AnnotatedType<T> createAnnotatedType(Class<T> type) {
        return this.annotatedElementFactory.newAnnotatedType(type);
    }

    public <T> CreationalContextImpl<T> createCreationalContext(Contextual<T> contextual) {
        if (contextual instanceof SerializableBean) {
            contextual = ((SerializableBean)contextual).getBean();
        }
        return this.webBeansContext.getCreationalContextFactory().getCreationalContext(contextual);
    }

    public Set<Bean<?>> getBeans(Type beanType, Annotation ... bindings) {
        if (ClassUtil.isTypeVariable(beanType)) {
            throw new IllegalArgumentException("Exception in getBeans method. Bean type can not be TypeVariable for bean type : " + beanType);
        }
        this.webBeansContext.getAnnotationManager().checkQualifierConditions(bindings);
        return this.injectionResolver.implResolveByType(false, beanType, bindings);
    }

    public Set<Bean<?>> getBeans(String name) {
        Asserts.assertNotNull(name, "name");
        return this.injectionResolver.implResolveByName(name);
    }

    public ELResolver getELResolver() {
        ELAdaptor elAdaptor = this.webBeansContext.getService(ELAdaptor.class);
        return elAdaptor.getOwbELResolver();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getInjectableReference(InjectionPoint injectionPoint, CreationalContext<?> ownerCreationalContext) {
        if (injectionPoint == null) {
            return null;
        }
        Object instance = null;
        Bean<?> injectedBean = this.injectionResolver.getInjectionPointBean(injectionPoint);
        if (WebBeansUtil.isDependent(injectedBean)) {
            if (!(ownerCreationalContext instanceof CreationalContextImpl)) {
                ownerCreationalContext = this.webBeansContext.getCreationalContextFactory().wrappedCreationalContext(ownerCreationalContext, injectionPoint.getBean());
            }
            if (injectionPoint.isDelegate() && ((CreationalContextImpl)ownerCreationalContext).getDelegate() != null) {
                return ((CreationalContextImpl)ownerCreationalContext).getDelegate();
            }
            ((CreationalContextImpl)ownerCreationalContext).putInjectionPoint(injectionPoint);
            try {
                instance = this.getReference(injectedBean, injectionPoint.getType(), ownerCreationalContext);
            }
            finally {
                ((CreationalContextImpl)ownerCreationalContext).removeInjectionPoint();
            }
        }
        CreationalContext injectedCreational = this.createCreationalContext((Contextual)injectedBean);
        injectedCreational.putInjectionPoint(injectionPoint);
        try {
            instance = this.getReference(injectedBean, injectionPoint.getType(), injectedCreational);
        }
        finally {
            injectedCreational.removeInjectionPoint();
        }
        return instance;
    }

    public Set<Annotation> getInterceptorBindingDefinition(Class<? extends Annotation> binding) {
        Annotation[] annotations = binding.getDeclaredAnnotations();
        HashSet<Annotation> set = new HashSet<Annotation>();
        if (binding.isAnnotationPresent(InterceptorBinding.class)) {
            Collections.addAll(set, annotations);
        }
        return set;
    }

    public Bean<?> getPassivationCapableBean(String id) {
        return (Bean)this.passivationBeans.get(id);
    }

    public Object getReference(Bean<?> providedBean, Type beanType, CreationalContext<?> creationalContext) {
        Object bean;
        Asserts.assertNotNull(providedBean, "bean parameter");
        Context context = null;
        Object instance = null;
        Bean<?> bean2 = bean = !OwbBean.class.isInstance(providedBean) ? this.thirdPartyMapping.get(providedBean) : providedBean;
        if (bean == null) {
            bean = providedBean;
        }
        if (bean instanceof SerializableBean) {
            bean = ((SerializableBean)bean).getBean();
        }
        if (!(creationalContext instanceof CreationalContextImpl)) {
            creationalContext = this.webBeansContext.getCreationalContextFactory().wrappedCreationalContext(creationalContext, bean);
        }
        if (ManagedBean.class.isInstance(bean)) {
            ((ManagedBean)ManagedBean.class.cast(bean)).valid();
        }
        if (beanType != null && beanType != Object.class) {
            boolean isProducer = AbstractProducerBean.class.isInstance(bean);
            if (!(isProducer || this.isBeanTypeAssignableToGivenType(bean.getTypes(), beanType, bean instanceof NewBean, isProducer) || GenericsUtil.satisfiesDependency(false, isProducer, beanType, bean.getBeanClass()) || GenericsUtil.satisfiesDependencyRaw(false, isProducer, beanType, bean.getBeanClass()))) {
                throw new IllegalArgumentException("Given bean type : " + beanType + " is not applicable for the bean instance : " + bean);
            }
        } else {
            beanType = bean instanceof OwbBean ? ((OwbBean)bean).getReturnType() : bean.getBeanClass();
        }
        if (this.isNormalScope(bean.getScope())) {
            instance = this.getEjbOrJmsProxyReference((Bean<?>)bean, beanType, creationalContext);
            if (instance != null) {
                return instance;
            }
            instance = this.cacheProxies.get(bean);
            if (instance == null) {
                instance = this.webBeansContext.getNormalScopeProxyFactory().createNormalScopeProxy(bean);
                this.cacheProxies.put((Contextual<?>)bean, instance);
            }
        } else {
            context = this.getContext(bean.getScope());
            instance = this.getEjbOrJmsProxyReference((Bean<?>)bean, beanType, creationalContext);
            if (instance != null) {
                return instance;
            }
            instance = context.get(bean, creationalContext);
        }
        return instance;
    }

    public BeanAttributes<?> createBeanAttributes(AnnotatedMember<?> member) {
        if (member instanceof AnnotatedField) {
            return BeanAttributesBuilder.forContext(this.webBeansContext).newBeanAttibutes((AnnotatedField)member).build();
        }
        if (member instanceof AnnotatedMethod) {
            return BeanAttributesBuilder.forContext(this.webBeansContext).newBeanAttibutes((AnnotatedMethod)member).build();
        }
        throw new IllegalArgumentException("Unsupported member type " + member.getClass().getName());
    }

    public InjectionPoint createInjectionPoint(AnnotatedField<?> field) {
        return this.webBeansContext.getInjectionPointFactory().buildInjectionPoint(null, field, false);
    }

    public InjectionPoint createInjectionPoint(AnnotatedParameter<?> parameter) {
        InjectionPoint injectionPoint = this.webBeansContext.getInjectionPointFactory().buildInjectionPoint(null, parameter, false);
        if (AnnotatedMethod.class.isInstance(parameter.getDeclaringCallable())) {
            try {
                this.validate(injectionPoint);
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e);
            }
        }
        GProcessInjectionPoint event = this.webBeansContext.getWebBeansUtil().fireProcessInjectionPointEvent(injectionPoint);
        injectionPoint = event.getInjectionPoint();
        event.setStarted();
        return injectionPoint;
    }

    public <X> ProducerFactory<X> getProducerFactory(AnnotatedField<? super X> field, Bean<X> bean) {
        return new FieldProducerFactory<X>(field, bean, this.webBeansContext);
    }

    public <X> ProducerFactory<X> getProducerFactory(AnnotatedMethod<? super X> method, Bean<X> bean) {
        return new MethodProducerFactory<X>(method, bean, this.webBeansContext);
    }

    public <X> InjectionTargetFactory<X> getInjectionTargetFactory(AnnotatedType<X> type) {
        return new InjectionTargetFactoryImpl<X>(type, this.webBeansContext);
    }

    public <T> Bean<T> createBean(BeanAttributes<T> attributes, Class<T> type, InjectionTargetFactory<T> factory) {
        AnnotatedType<T> annotatedType;
        AnnotatedType<T> annotatedType2 = annotatedType = InjectionTargetFactoryImpl.class.isInstance(factory) ? ((InjectionTargetFactoryImpl)InjectionTargetFactoryImpl.class.cast(factory)).getAnnotatedType() : this.getOrCreateAnnotatedType(type);
        if (WebBeansUtil.isDecorator(annotatedType)) {
            DecoratorBeanBuilder<T> dbb = new DecoratorBeanBuilder<T>(this.webBeansContext, annotatedType, attributes);
            DecoratorBean<T> decorator = null;
            if (dbb.isDecoratorEnabled()) {
                dbb.defineDecoratorRules();
                decorator = dbb.getBean();
                this.webBeansContext.getDecoratorsManager().addDecorator(decorator);
            }
            return decorator;
        }
        if (WebBeansUtil.isCdiInterceptor(annotatedType)) {
            CdiInterceptorBeanBuilder<T> ibb = new CdiInterceptorBeanBuilder<T>(this.webBeansContext, annotatedType, attributes);
            CdiInterceptorBean interceptor = null;
            if (ibb.isInterceptorEnabled()) {
                ibb.defineCdiInterceptorRules();
                interceptor = (CdiInterceptorBean)ibb.getBean();
                this.webBeansContext.getInterceptorsManager().addCdiInterceptor(interceptor);
            }
            return interceptor;
        }
        InjectionTargetBean<T> bean = new InjectionTargetBean<T>(this.webBeansContext, WebBeansType.THIRDPARTY, annotatedType, attributes, type, factory);
        if (this.webBeansContext.getOpenWebBeansConfiguration().supportsInterceptionOnProducers()) {
            bean.defineInterceptorsIfNeeded();
        }
        return bean;
    }

    private <T> AnnotatedType<T> getOrCreateAnnotatedType(Class<T> type) {
        AnnotatedType<T> annotatedType = this.webBeansContext.getAnnotatedElementFactory().getAnnotatedType(type);
        if (annotatedType == null) {
            annotatedType = this.webBeansContext.getAnnotatedElementFactory().newAnnotatedType(type);
        }
        return annotatedType;
    }

    private boolean isBeanTypeAssignableToGivenType(Set<Type> beanTypes, Type givenType, boolean newBean, boolean producer) {
        for (Type beanApiType : beanTypes) {
            Class<?> requiredType;
            if (GenericsUtil.satisfiesDependency(false, producer, givenType, beanApiType)) {
                return true;
            }
            if (!newBean || !ClassUtil.isParametrizedType(givenType) || !ClassUtil.isClassAssignableFrom(requiredType = ClassUtil.getClass(givenType), ClassUtil.getClass(beanApiType))) continue;
            return true;
        }
        return false;
    }

    private Object getEjbOrJmsProxyReference(Bean<?> bean, Type beanType, CreationalContext<?> creationalContext) {
        if (bean instanceof EnterpriseBeanMarker) {
            if (this.isNormalScope(bean.getScope()) && this.cacheProxies.containsKey(bean)) {
                return this.cacheProxies.get(bean);
            }
            OpenWebBeansEjbPlugin ejbPlugin = this.webBeansContext.getPluginLoader().getEjbPlugin();
            if (ejbPlugin == null) {
                throw new IllegalStateException("There is no EJB plugin provider. Injection is failed for bean : " + bean);
            }
            return ejbPlugin.getSessionBeanProxy(bean, ClassUtil.getClazz(beanType), creationalContext);
        }
        if (bean instanceof JmsBeanMarker) {
            OpenWebBeansJmsPlugin jmsPlugin = this.webBeansContext.getPluginLoader().getJmsPlugin();
            if (jmsPlugin == null) {
                throw new IllegalStateException("There is no JMS plugin provider. Injection is failed for bean : " + bean);
            }
            return jmsPlugin.getJmsBeanProxy(bean, ClassUtil.getClass(beanType));
        }
        return null;
    }

    public Set<Annotation> getStereotypeDefinition(Class<? extends Annotation> stereotype) {
        Annotation[] annotations = stereotype.getDeclaredAnnotations();
        HashSet<Annotation> set = new HashSet<Annotation>();
        if (stereotype.isAnnotationPresent(Stereotype.class)) {
            Collections.addAll(set, annotations);
        }
        return set;
    }

    public boolean isQualifier(Class<? extends Annotation> annotationType) {
        return this.webBeansContext.getAnnotationManager().isQualifierAnnotation(annotationType);
    }

    public boolean isInterceptorBinding(Class<? extends Annotation> annotationType) {
        return this.webBeansContext.getAnnotationManager().isInterceptorBindingAnnotation(annotationType);
    }

    public boolean isScope(Class<? extends Annotation> annotationType) {
        boolean isScopeAnnotation;
        if (this.nonscopeAnnotations.contains(annotationType)) {
            return false;
        }
        if (this.scopeAnnotations.contains(annotationType)) {
            return true;
        }
        boolean bl = isScopeAnnotation = annotationType.getAnnotation(Scope.class) != null || annotationType.getAnnotation(NormalScope.class) != null;
        if (!isScopeAnnotation) {
            for (ExternalScope es : this.getAdditionalScopes()) {
                if (!es.getScope().equals(annotationType)) continue;
                isScopeAnnotation = true;
                break;
            }
        }
        if (isScopeAnnotation) {
            this.scopeAnnotations.add(annotationType);
        } else {
            this.nonscopeAnnotations.add(annotationType);
        }
        return isScopeAnnotation;
    }

    public boolean isNormalScope(Class<? extends Annotation> scopeType) {
        Boolean isNormal = isScopeTypeNormalCache.get(scopeType);
        if (isNormal != null) {
            return isNormal;
        }
        for (ExternalScope extScope : this.additionalScopes) {
            if (!extScope.getScope().equals(scopeType)) continue;
            isScopeTypeNormalCache.put(scopeType, extScope.isNormal());
            return extScope.isNormal();
        }
        isNormal = scopeType.getAnnotation(NormalScope.class) != null;
        isScopeTypeNormalCache.put(scopeType, isNormal);
        return isNormal;
    }

    public boolean isPassivatingScope(Class<? extends Annotation> annotationType) {
        for (ExternalScope extScope : this.additionalScopes) {
            if (!extScope.getScope().equals(annotationType)) continue;
            return extScope.isPassivating();
        }
        NormalScope scope = annotationType.getAnnotation(NormalScope.class);
        if (scope != null) {
            return scope.passivating();
        }
        return false;
    }

    public boolean isStereotype(Class<? extends Annotation> annotationType) {
        return AnnotationUtil.hasAnnotation(annotationType.getDeclaredAnnotations(), Stereotype.class);
    }

    public boolean areInterceptorBindingsEquivalent(Annotation annotation1, Annotation annotation2) {
        return AnnotationUtil.isCdiAnnotationEqual(annotation1, annotation2);
    }

    public boolean areQualifiersEquivalent(Annotation annotation1, Annotation annotation2) {
        return AnnotationUtil.isCdiAnnotationEqual(annotation1, annotation2);
    }

    public int getInterceptorBindingHashCode(Annotation annotation) {
        return AnnotationUtil.getCdiAnnotationHashCode(annotation);
    }

    public int getQualifierHashCode(Annotation annotation) {
        return AnnotationUtil.getCdiAnnotationHashCode(annotation);
    }

    public <T> BeanAttributes<T> createBeanAttributes(AnnotatedType<T> type) {
        OpenWebBeansEjbPlugin ejbPlugin = this.webBeansContext.getPluginLoader().getEjbPlugin();
        if (ejbPlugin != null && ejbPlugin.isSessionBean(type.getJavaClass())) {
            return ejbPlugin.createBeanAttributes(type);
        }
        return BeanAttributesBuilder.forContext(this.webBeansContext).newBeanAttibutes(type).build();
    }

    public <T, X> Bean<T> createBean(BeanAttributes<T> attributes, Class<X> type, ProducerFactory<X> factory) {
        return new ProducerAwareInjectionTargetBean<T>(this.webBeansContext, WebBeansType.THIRDPARTY, attributes, this.findClass(factory, type), false, factory);
    }

    private Class<?> findClass(ProducerFactory<?> factory, Class<?> type) {
        if (MethodProducerFactory.class.isInstance(factory)) {
            return ((MethodProducerFactory)MethodProducerFactory.class.cast(factory)).getReturnType();
        }
        if (FieldProducerFactory.class.isInstance(factory)) {
            return ((FieldProducerFactory)FieldProducerFactory.class.cast(factory)).getReturnType();
        }
        return type;
    }

    public <T extends Extension> T getExtension(Class<T> type) {
        Extension extension = (Extension)this.webBeansContext.getExtensionLoader().getExtension(type);
        if (extension == null) {
            throw new IllegalArgumentException("extension " + type + " not registered");
        }
        return (T)extension;
    }

    public <X> Bean<? extends X> resolve(Set<Bean<? extends X>> beans) {
        return this.injectionResolver.resolve(beans, null);
    }

    public <T> InterceptionFactory<T> createInterceptionFactory(CreationalContext<T> creationalContext, Class<T> clazz) {
        return new InterceptionFactoryImpl<T>(this.webBeansContext, this.createAnnotatedType(clazz), AnnotationUtil.DEFAULT_AND_ANY_ANNOTATION_SET, (CreationalContextImpl)CreationalContextImpl.class.cast(creationalContext));
    }

    public void validate(InjectionPoint injectionPoint) {
        if (injectionPoint == null) {
            throw new IllegalArgumentException("InjectionPoint parameter must not be nul");
        }
        Bean bean = injectionPoint.getBean();
        this.injectionResolver.checkInjectionPointType(injectionPoint);
        Class<?> rawType = ClassUtil.getRawTypeForInjectionPoint(injectionPoint);
        if (rawType.equals(InjectionPoint.class)) {
            if (AnnotationUtil.hasAnnotation(AnnotationUtil.asArray(injectionPoint.getQualifiers()), Default.class) && !bean.getScope().equals(Dependent.class)) {
                throw new WebBeansConfigurationException("Bean " + bean.getBeanClass() + " scope can not define other scope except @Dependent to inject InjectionPoint");
            }
        } else {
            this.injectionResolver.checkInjectionPoint(injectionPoint);
        }
    }

    public <T> InjectionTarget<T> createInjectionTarget(AnnotatedType<T> type) {
        InjectionTargetFactoryImpl factory = new InjectionTargetFactoryImpl(type, this.webBeansContext);
        InterceptorUtil interceptorUtil = this.webBeansContext.getInterceptorUtil();
        LazyInterceptorDefinedInjectionTarget<T> injectionTarget = new LazyInterceptorDefinedInjectionTarget<T>(type, factory.createInjectionPoints(null), this.webBeansContext, interceptorUtil.getLifecycleMethods(type, PostConstruct.class), interceptorUtil.getLifecycleMethods(type, PreDestroy.class));
        if (this.isAfterBeanDiscoveryDone()) {
            try {
                this.webBeansContext.getWebBeansUtil().validate(injectionTarget.getInjectionPoints(), null);
            }
            catch (InjectionException ie) {
                throw new IllegalArgumentException(ie);
            }
            catch (WebBeansConfigurationException ie) {
                throw new IllegalArgumentException((Throwable)((Object)ie));
            }
            catch (DeploymentException ie) {
                throw new IllegalArgumentException(ie);
            }
        }
        GProcessInjectionTarget event = this.webBeansContext.getWebBeansUtil().fireProcessInjectionTargetEvent(injectionTarget, type);
        InjectionTarget it = event.getInjectionTarget();
        event.setStarted();
        return it;
    }

    public <T> Set<ObserverMethod<? super T>> resolveObserverMethods(T event, Annotation ... qualifiers) {
        return this.resolveObserverMethods(event, new EventMetadataImpl(null, event.getClass(), null, qualifiers, this.webBeansContext));
    }

    public <T> Set<ObserverMethod<? super T>> resolveObserverMethods(T event, EventMetadataImpl metadata) {
        LinkedList<ObserverMethod<T>> observerMethods = new LinkedList<ObserverMethod<T>>(this.webBeansContext.getNotificationManager().resolveObservers(event, metadata, false));
        Collections.sort(observerMethods, Comparator.comparingInt(ObserverMethod::getPriority));
        return new LinkedHashSet<ObserverMethod<? super T>>(observerMethods);
    }

    public ExpressionFactory wrapExpressionFactory(ExpressionFactory expressionFactory) {
        ELAdaptor elAdaptor = this.webBeansContext.getService(ELAdaptor.class);
        return elAdaptor.getOwbWrappedExpressionFactory(expressionFactory);
    }

    public void addAdditionalQualifier(Class<? extends Annotation> qualifier) {
        if (!this.additionalQualifiers.contains(qualifier)) {
            this.additionalQualifiers.add(qualifier);
        }
    }

    public void addAdditionalQualifier(AnnotatedType<? extends Annotation> qualifier) {
        if (qualifier != null && !this.additionalQualifiers.contains(qualifier.getJavaClass())) {
            this.additionalAnnotatedTypeQualifiers.put(qualifier.getJavaClass(), qualifier);
            this.additionalQualifiers.add(qualifier.getJavaClass());
        }
    }

    public void addAdditionalAnnotatedType(Object extension, AnnotatedType<?> annotatedType) {
        this.addAdditionalAnnotatedType(extension, annotatedType, extension.getClass().getName() + annotatedType + "OWB_DEFAULT_KEY");
    }

    public <T> void addAdditionalAnnotatedType(Object extension, AnnotatedType<T> inAnnotatedType, String id) {
        if (id == null) {
            this.addAdditionalAnnotatedType(extension, inAnnotatedType);
            return;
        }
        AnnotatedTypeWrapper<T> annotatedType = new AnnotatedTypeWrapper<T>((Extension)Extension.class.cast(extension), inAnnotatedType, id);
        if (annotatedType.getAnnotation(Vetoed.class) != null) {
            return;
        }
        this.webBeansContext.getAnnotatedElementFactory().setAnnotatedType(annotatedType, id);
        ConcurrentMap<String, AnnotatedTypeWrapper<Object>> annotatedTypes = (ConcurrentHashMap<String, AnnotatedTypeWrapper<T>>)this.additionalAnnotatedTypes.get(annotatedType.getJavaClass());
        if (annotatedTypes == null) {
            annotatedTypes = new ConcurrentHashMap<String, AnnotatedTypeWrapper<T>>();
            ConcurrentMap oldAnnotatedTypes = this.additionalAnnotatedTypes.putIfAbsent(annotatedType.getJavaClass(), annotatedTypes);
            if (oldAnnotatedTypes != null) {
                annotatedTypes = oldAnnotatedTypes;
            }
        }
        annotatedTypes.put(id, annotatedType);
    }

    public void removeAdditionalAnnotatedType(AnnotatedType<?> annotatedType) {
        this.removeAdditionalAnnotatedType(annotatedType, "OWB_DEFAULT_KEY");
    }

    public void removeAdditionalAnnotatedType(AnnotatedType<?> annotatedType, String id) {
        ConcurrentMap annotatedTypes = (ConcurrentMap)this.additionalAnnotatedTypes.get(annotatedType.getJavaClass());
        if (annotatedTypes == null) {
            return;
        }
        if (annotatedType.equals(annotatedTypes.get(id))) {
            annotatedTypes.remove(id);
        }
    }

    public List<Class<? extends Annotation>> getAdditionalQualifiers() {
        return this.additionalQualifiers;
    }

    public Map<Class<?>, AnnotatedType<? extends Annotation>> getAdditionalAnnotatedTypeQualifiers() {
        return this.additionalAnnotatedTypeQualifiers;
    }

    public void addAdditionalScope(ExternalScope additionalScope) {
        if (!this.additionalScopes.contains(additionalScope)) {
            this.additionalScopes.add(additionalScope);
        }
    }

    public List<ExternalScope> getAdditionalScopes() {
        return this.additionalScopes;
    }

    public Collection<AnnotatedType<?>> getAdditionalAnnotatedTypes() {
        ArrayList annotatedTypes = new ArrayList();
        for (ConcurrentMap types : this.additionalAnnotatedTypes.values()) {
            annotatedTypes.addAll(types.values());
        }
        return annotatedTypes;
    }

    public <T> AnnotatedType<T> getAdditionalAnnotatedType(Class<T> type, String id) {
        if (id == null) {
            return this.annotatedElementFactory.getAnnotatedType(type);
        }
        ConcurrentMap annotatedTypes = (ConcurrentMap)this.additionalAnnotatedTypes.get(type);
        if (annotatedTypes == null) {
            return null;
        }
        return (AnnotatedType)annotatedTypes.get(id);
    }

    public <T> String getId(Class<T> type, AnnotatedType<T> at) {
        ConcurrentMap additionals = (ConcurrentMap)this.additionalAnnotatedTypes.get(type);
        if (additionals != null) {
            for (Map.Entry entry : additionals.entrySet()) {
                if (entry.getValue() != at) continue;
                return (String)entry.getKey();
            }
        }
        return null;
    }

    public <T> Iterable<AnnotatedType<T>> getAnnotatedTypes(Class<T> type) {
        ArrayList<AnnotatedType<T>> types = new ArrayList<AnnotatedType<T>>(2);
        types.add(this.annotatedElementFactory.getAnnotatedType(type));
        ConcurrentMap aTypes = (ConcurrentMap)this.additionalAnnotatedTypes.get(type);
        if (aTypes != null) {
            for (AnnotatedType at : aTypes.values()) {
                types.add(at);
            }
        }
        return types;
    }

    public void clear() {
        this.additionalAnnotatedTypes.clear();
        this.additionalQualifiers.clear();
        this.additionalScopes.clear();
        this.scopeAnnotations.clear();
        this.nonscopeAnnotations.clear();
        this.clearCacheProxies();
        this.singleContextMap.clear();
        this.contextMap.clear();
        this.deploymentBeans.clear();
        this.errorStack.clear();
        this.producersForJavaEeComponents.clear();
        this.passivationBeans.clear();
        this.webBeansContext.getInterceptorsManager().clear();
        this.webBeansContext.getDecoratorsManager().clear();
        this.webBeansContext.getAnnotatedElementFactory().clear();
        this.injectionResolver.clearCaches();
        this.webBeansContext.getAnnotationManager().clearCaches();
        this.webBeansContext.clear();
    }

    public void clearCacheProxies() {
        this.cacheProxies.clear();
    }

    public boolean isInUse() {
        return this.inUse;
    }

    public boolean isAfterDeploymentValidationFired() {
        return this.afterDeploymentValidationFired;
    }

    public void setAfterDeploymentValidationFired(boolean afterDeploymentValidationFired) {
        this.afterDeploymentValidationFired = afterDeploymentValidationFired;
    }

    public void setAfterBeanDiscoveryStart() {
        this.beanDiscoveryState = LifecycleState.DISCOVERY;
    }

    public void setAfterBeanDiscoveryDone() {
        this.beanDiscoveryState = LifecycleState.AFTER_DISCOVERY;
    }

    public boolean isAfterBeanDiscoveryDone() {
        return this.beanDiscoveryState == LifecycleState.AFTER_DISCOVERY;
    }

    public boolean isAfterBeanDiscovery() {
        return this.beanDiscoveryState == LifecycleState.DISCOVERY;
    }

    private static enum LifecycleState {
        BEFORE_DISCOVERY,
        DISCOVERY,
        AFTER_DISCOVERY;

    }
}

