/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.portable;

import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.event.Event;
import javax.enterprise.inject.spi.InjectionPoint;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.context.creational.CreationalContextImpl;
import org.apache.webbeans.event.EventImpl;
import org.apache.webbeans.exception.WebBeansException;
import org.apache.webbeans.portable.AbstractProducer;

public class EventProducer<T>
extends AbstractProducer<Event<T>> {
    private WebBeansContext webBeansContext;

    public EventProducer(WebBeansContext webBeansContext) {
        this.webBeansContext = webBeansContext;
    }

    public Event<T> produce(CreationalContext<Event<T>> creationalContext) {
        EventImpl instance = null;
        InjectionPoint injectionPoint = null;
        if (creationalContext instanceof CreationalContextImpl) {
            injectionPoint = ((CreationalContextImpl)creationalContext).getInjectionPoint();
        }
        if (injectionPoint != null) {
            Type type = injectionPoint.getType();
            ParameterizedType pt = (ParameterizedType)type;
            Type[] eventActualTypeArgs = pt.getActualTypeArguments();
            Type eventType = eventActualTypeArgs[0];
            Annotation[] qualifiers = new Annotation[injectionPoint.getQualifiers().size()];
            qualifiers = injectionPoint.getQualifiers().toArray(qualifiers);
            try {
                instance = new EventImpl(qualifiers, eventType, injectionPoint, this.webBeansContext);
            }
            catch (Exception e) {
                throw new WebBeansException("Exception in creating Event implicit component for event type : " + eventType);
            }
            finally {
                if (creationalContext instanceof CreationalContextImpl) {
                    ((CreationalContextImpl)creationalContext).removeInjectionPoint();
                }
            }
        }
        return instance;
    }
}

