/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.ejb.common.component;

import java.util.List;
import java.util.Set;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.InjectionTarget;
import org.apache.webbeans.component.BeanAttributesImpl;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.ejb.common.component.BaseEjbBean;
import org.apache.webbeans.ejb.common.util.EjbValidator;
import org.apache.webbeans.portable.AbstractEjbInjectionTarget;
import org.apache.webbeans.util.Asserts;

public abstract class EjbBeanBuilder<T, E extends BaseEjbBean<T>> {
    protected final WebBeansContext webBeansContext;
    protected final AnnotatedType<T> annotatedType;
    protected final BeanAttributesImpl<T> beanAttributes;

    public EjbBeanBuilder(WebBeansContext webBeansContext, AnnotatedType<T> annotatedType, BeanAttributesImpl<T> beanAttributes) {
        Asserts.assertNotNull((Object)webBeansContext, (String)"webBeansContext may not be null");
        Asserts.assertNotNull(annotatedType, (String)"annotated type may not be null");
        Asserts.assertNotNull(beanAttributes, (String)"beanAttributes may not be null");
        this.webBeansContext = webBeansContext;
        this.annotatedType = annotatedType;
        this.beanAttributes = beanAttributes;
    }

    protected InjectionTarget<T> buildInjectionTarget(AnnotatedType<T> annotatedType, Set<InjectionPoint> points, WebBeansContext webBeansContext, List<AnnotatedMethod<?>> postConstructMethods, List<AnnotatedMethod<?>> preDestroyMethods) {
        return new AbstractEjbInjectionTarget<T>(annotatedType, points, webBeansContext){

            public T produce(CreationalContext<T> creationalContext) {
                return EjbBeanBuilder.this.getInstance(creationalContext);
            }
        };
    }

    protected final E createBean(Class<T> beanClass) {
        return this.createBean(beanClass, this.webBeansContext.getWebBeansUtil().isBeanEnabled(this.annotatedType, this.annotatedType.getJavaClass(), this.beanAttributes.getStereotypes()));
    }

    protected abstract E createBean(Class<T> var1, boolean var2);

    public E getBean() {
        E bean = this.createBean(this.annotatedType.getJavaClass());
        EjbValidator.validateDecoratorOrInterceptor(bean.getReturnType());
        EjbValidator.validateEjbScopeType(bean);
        EjbValidator.validateGenericBeanType(bean.getReturnType(), bean.getScope());
        return bean;
    }

    protected abstract T getInstance(CreationalContext<T> var1);
}

