/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.ejb.common.interceptor;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javassist.util.proxy.MethodHandler;
import javassist.util.proxy.ProxyFactory;
import javassist.util.proxy.ProxyObject;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.ejb.PostActivate;
import javax.ejb.PrePassivate;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.RequestScoped;
import javax.enterprise.context.spi.Context;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.interceptor.AroundInvoke;
import javax.interceptor.AroundTimeout;
import javax.interceptor.InvocationContext;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.context.ContextFactory;
import org.apache.webbeans.context.creational.CreationalContextImpl;
import org.apache.webbeans.decorator.DelegateHandler;
import org.apache.webbeans.decorator.WebBeansDecoratorConfig;
import org.apache.webbeans.decorator.WebBeansDecoratorInterceptor;
import org.apache.webbeans.ejb.common.component.BaseEjbBean;
import org.apache.webbeans.inject.OWBInjector;
import org.apache.webbeans.intercept.InterceptorData;
import org.apache.webbeans.intercept.InterceptorDataImpl;
import org.apache.webbeans.intercept.InterceptorType;
import org.apache.webbeans.intercept.InvocationContextImpl;
import org.apache.webbeans.logger.WebBeansLogger;
import org.apache.webbeans.proxy.JavassistProxyFactory;
import org.apache.webbeans.spi.ContextsService;
import org.apache.webbeans.util.WebBeansUtil;

public class OpenWebBeansEjbInterceptor
implements Serializable {
    private static final long serialVersionUID = -4317127341083031217L;
    private static final WebBeansLogger logger = WebBeansLogger.getLogger(OpenWebBeansEjbInterceptor.class);
    private static transient ThreadLocal<BaseEjbBean<?>> threadLocal = new ThreadLocal();
    private static transient ThreadLocal<CreationalContext<?>> threadLocalCreationalContext = new ThreadLocal();
    protected transient Map<Method, List<InterceptorData>> interceptedMethodMap = new WeakHashMap<Method, List<InterceptorData>>();
    protected transient Map<Method, List<InterceptorData>> nonCtxInterceptedMethodMap = new WeakHashMap<Method, List<InterceptorData>>();
    private transient OWBInjector injector;
    private transient Map<Class<?>, BaseEjbBean<?>> resolvedBeans = new HashMap();
    private CreationalContext<?> cc;
    private transient BaseEjbBean<?> contextual;
    private transient WebBeansContext webBeansContext;
    private CreationalKey ccKey;

    public static void setThreadLocal(BaseEjbBean<?> ejbBean, CreationalContext<?> creationalContext) {
        threadLocal.set(ejbBean);
        threadLocalCreationalContext.set(creationalContext);
    }

    public static void unsetThreadLocal() {
        threadLocal.set(null);
        threadLocalCreationalContext.set(null);
        threadLocal.remove();
        threadLocalCreationalContext.remove();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @AroundInvoke
    public Object callToOwbInterceptors(InvocationContext ejbContext) throws Exception {
        boolean requestCreated = false;
        boolean applicationCreated = false;
        boolean requestAlreadyActive = false;
        boolean applicationAlreadyActive = false;
        if (logger.wblWillLogDebug()) {
            logger.debug("Intercepting EJB method {0} ", new Object[]{ejbContext.getMethod()});
        }
        try {
            if (this.webBeansContext.getOpenWebBeansConfiguration().isUseEJBInterceptorActivation()) {
                int result = this.activateContexts(RequestScoped.class);
                if (result == 1) {
                    requestCreated = true;
                } else if (result == -1) {
                    requestAlreadyActive = true;
                }
                result = this.activateContexts(ApplicationScoped.class);
                if (result == 1) {
                    applicationCreated = true;
                } else if (result == -1) {
                    applicationAlreadyActive = true;
                }
            }
            if (this.contextual == null) {
                Object object = ejbContext.proceed();
                return object;
            }
            Object object = this.callInterceptorsAndDecorators(ejbContext.getMethod(), ejbContext.getTarget(), ejbContext.getParameters(), ejbContext);
            return object;
        }
        finally {
            if (this.webBeansContext.getOpenWebBeansConfiguration().isUseEJBInterceptorActivation()) {
                if (!requestAlreadyActive) {
                    this.deActivateContexts(requestCreated, RequestScoped.class);
                }
                if (!applicationAlreadyActive) {
                    this.deActivateContexts(applicationCreated, ApplicationScoped.class);
                }
            }
        }
    }

    public void lifecycleCommon(InvocationContext context, InterceptorType interceptorType) {
        try {
            if (this.contextual != null && WebBeansUtil.isContainsInterceptorMethod((List)this.contextual.getInterceptorStack(), (InterceptorType)interceptorType)) {
                InvocationContextImpl impl = new InvocationContextImpl(this.webBeansContext, this.contextual, context.getTarget(), null, null, this.webBeansContext.getInterceptorUtil().getInterceptorMethods(this.contextual.getInterceptorStack(), interceptorType), interceptorType);
                impl.setCreationalContext(this.cc);
                impl.setEJBInvocationContext(context);
                impl.setCcKey((Object)this.ccKey);
                impl.proceed();
            } else {
                context.proceed();
            }
        }
        catch (Exception e) {
            logger.error("ERROR_0008", (Throwable)e, new Object[]{interceptorType});
            throw new RuntimeException(e);
        }
    }

    @PostConstruct
    public void afterConstruct(InvocationContext context) {
        if (logger.wblWillLogDebug()) {
            logger.debug("entry");
        }
        if (this.webBeansContext == null) {
            this.webBeansContext = WebBeansContext.getInstance();
        }
        BaseEjbBean<?> injectionTarget = threadLocal.get();
        this.ccKey = new CreationalKey();
        if (injectionTarget == null) {
            this.contextual = this.findTargetBean(context.getTarget());
            if (this.contextual == null) {
                try {
                    context.proceed();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                return;
            }
        } else {
            this.contextual = injectionTarget;
            OpenWebBeansEjbInterceptor.unsetThreadLocal();
        }
        this.cc = this.webBeansContext.getBeanManagerImpl().createCreationalContext(this.contextual);
        if (logger.wblWillLogDebug()) {
            logger.debug("manager = {0} interceptor_instance = {1} contextual = {2} ", new Object[]{this.webBeansContext.getBeanManagerImpl(), this, this.contextual});
        }
        this.lifecycleCommon(context, InterceptorType.POST_CONSTRUCT);
        if (this.webBeansContext.getOpenWebBeansConfiguration().isUseEJBInterceptorInjection()) {
            Object instance = context.getTarget();
            this.injector = new OWBInjector(this.webBeansContext);
            try {
                this.injector.inject(instance, this.cc);
            }
            catch (Exception e) {
                logger.error("ERROR_0026", (Throwable)e, new Object[]{this.contextual});
            }
        }
    }

    @PreDestroy
    public void preDestroy(InvocationContext context) {
        this.lifecycleCommon(context, InterceptorType.PRE_DESTROY);
        if (this.injector != null) {
            this.injector.destroy();
        }
        this.interceptedMethodMap.clear();
        this.resolvedBeans.clear();
        this.nonCtxInterceptedMethodMap.clear();
        if (this.cc != null) {
            this.cc.release();
        }
    }

    private int activateContexts(Class<? extends Annotation> scopeType) {
        ContextsService service = (ContextsService)this.webBeansContext.getService(ContextsService.class);
        Context ctx = service.getCurrentContext(scopeType);
        ContextFactory contextFactory = this.webBeansContext.getContextFactory();
        if (scopeType == RequestScoped.class) {
            if (ctx != null && !ctx.isActive()) {
                contextFactory.activateContext(scopeType);
                return 0;
            }
            if (ctx == null) {
                contextFactory.initRequestContext(null);
                return 1;
            }
        }
        if ((ctx = service.getCurrentContext(scopeType)) != null && !ctx.isActive()) {
            contextFactory.activateContext(scopeType);
            return 0;
        }
        if (ctx == null) {
            contextFactory.initApplicationContext(null);
            return 1;
        }
        return -1;
    }

    private void deActivateContexts(boolean destroy, Class<? extends Annotation> scopeType) {
        ContextFactory contextFactory = this.webBeansContext.getContextFactory();
        if (scopeType == ApplicationScoped.class) {
            if (destroy) {
                contextFactory.destroyApplicationContext(null);
            } else {
                contextFactory.deActivateContext(ApplicationScoped.class);
            }
        } else if (destroy) {
            contextFactory.destroyRequestContext(null);
        } else {
            contextFactory.deActivateContext(RequestScoped.class);
        }
    }

    private BaseEjbBean<?> findTargetBean(Object instance) {
        if (instance == null) {
            return null;
        }
        BaseEjbBean ejbBean = this.resolvedBeans.get(instance.getClass());
        if (ejbBean == null) {
            Set beans = this.webBeansContext.getBeanManagerImpl().getComponents();
            for (Bean bean : beans) {
                if (!(bean instanceof BaseEjbBean) || bean.getBeanClass() != instance.getClass()) continue;
                ejbBean = (BaseEjbBean)bean;
                if (logger.wblWillLogDebug()) {
                    logger.debug("Found managed bean for [{0}] [{1}]", new Object[]{instance.getClass(), ejbBean});
                }
                this.resolvedBeans.put(instance.getClass(), ejbBean);
                break;
            }
        } else if (logger.wblWillLogDebug()) {
            logger.debug("Managed bean for [{0}] found in cache: [{1}]", new Object[]{instance.getClass(), ejbBean});
        }
        return ejbBean;
    }

    private Object callInterceptorsAndDecorators(Method method, Object instance, Object[] arguments, InvocationContext ejbContext) throws Exception {
        Object rv = null;
        BaseEjbBean<?> injectionTarget = this.contextual;
        InterceptorDataImpl decoratorInterceptorDataImpl = null;
        List decorators = null;
        DelegateHandler delegateHandler = null;
        List decoratorStack = injectionTarget.getDecoratorStack();
        List interceptorStack = injectionTarget.getInterceptorStack();
        if (logger.wblWillLogDebug()) {
            logger.debug("Decorator stack for target {0}", new Object[]{decoratorStack});
            logger.debug("Interceptor stack {0}", new Object[]{interceptorStack});
        }
        if (decoratorStack.size() > 0) {
            Class proxyClass;
            if (logger.wblWillLogDebug()) {
                logger.debug("Obtaining a delegate");
            }
            if ((proxyClass = (Class)this.webBeansContext.getJavassistProxyFactory().getInterceptorProxyClasses().get(injectionTarget)) == null) {
                JavassistProxyFactory proxyFactory = this.webBeansContext.getJavassistProxyFactory();
                ProxyFactory delegateFactory = proxyFactory.createProxyFactory(injectionTarget);
                proxyClass = proxyFactory.getProxyClass(delegateFactory);
                proxyFactory.getInterceptorProxyClasses().put(injectionTarget, proxyClass);
            }
            Object delegate = proxyClass.newInstance();
            delegateHandler = new DelegateHandler(this.contextual, ejbContext);
            ((ProxyObject)delegate).setHandler((MethodHandler)delegateHandler);
            decorators = WebBeansDecoratorConfig.getDecoratorStack(injectionTarget, (Object)instance, delegate, (CreationalContextImpl)((CreationalContextImpl)this.cc));
            delegateHandler.setDecorators(decorators);
        }
        if (interceptorStack.size() == 0) {
            rv = decoratorStack.size() == 0 ? ejbContext.proceed() : delegateHandler.invoke(instance, method, null, arguments);
        } else {
            ArrayList<InterceptorDataImpl> filteredInterceptorStack;
            if (this.interceptedMethodMap.get(method) == null) {
                filteredInterceptorStack = new ArrayList<InterceptorDataImpl>(interceptorStack);
                this.webBeansContext.getInterceptorUtil().filterCommonInterceptorStackList(filteredInterceptorStack, method);
                this.webBeansContext.getInterceptorUtil().filterOverridenAroundInvokeInterceptor(injectionTarget.getBeanClass(), filteredInterceptorStack);
                this.interceptedMethodMap.put(method, filteredInterceptorStack);
            }
            filteredInterceptorStack = new ArrayList(this.interceptedMethodMap.get(method));
            if (delegateHandler != null) {
                WebBeansDecoratorInterceptor lastInterceptor = new WebBeansDecoratorInterceptor(delegateHandler, instance);
                decoratorInterceptorDataImpl = new InterceptorDataImpl(true, lastInterceptor, this.webBeansContext);
                decoratorInterceptorDataImpl.setDefinedInInterceptorClass(true);
                decoratorInterceptorDataImpl.setAroundInvoke(this.webBeansContext.getSecurityService().doPrivilegedGetDeclaredMethods(lastInterceptor.getClass())[0]);
                filteredInterceptorStack.add(decoratorInterceptorDataImpl);
            }
            rv = this.webBeansContext.getInterceptorUtil().callAroundInvokes(this.webBeansContext, this.contextual, instance, (CreationalContextImpl)this.cc, method, arguments, this.webBeansContext.getInterceptorUtil().getInterceptorMethods(filteredInterceptorStack, InterceptorType.AROUND_INVOKE), ejbContext, (Object)this.ccKey);
        }
        return rv;
    }

    @AroundTimeout
    public Object callAroundTimeouts(InvocationContext context) throws Exception {
        Object rv = null;
        if (logger.wblWillLogDebug()) {
            logger.debug("OWBEI:: @AroundTimeout entry. Trying to run Interceptors.");
        }
        if (this.contextual != null && WebBeansUtil.isContainsInterceptorMethod((List)this.contextual.getInterceptorStack(), (InterceptorType)InterceptorType.AROUND_TIMEOUT)) {
            try {
                InvocationContextImpl impl = new InvocationContextImpl(this.webBeansContext, null, context.getTarget(), null, null, this.webBeansContext.getInterceptorUtil().getInterceptorMethods(this.contextual.getInterceptorStack(), InterceptorType.AROUND_TIMEOUT), InterceptorType.AROUND_TIMEOUT);
                impl.setCreationalContext(this.cc);
                impl.setEJBInvocationContext(context);
                impl.setCcKey((Object)this.ccKey);
                rv = impl.proceed();
            }
            catch (Exception e) {
                logger.error("ERROR_0008", (Throwable)e, new Object[]{"@AroundTimeout."});
                throw new RuntimeException(e);
            }
        } else {
            rv = context.proceed();
        }
        return rv;
    }

    @PrePassivate
    public void beforePassivate(InvocationContext context) {
        if (logger.wblWillLogDebug()) {
            logger.debug("manager = {0} interceptor_instance = {1} contextual = {2} ", new Object[]{this.webBeansContext.getBeanManagerImpl(), this, this.contextual});
        }
        this.lifecycleCommon(context, InterceptorType.PRE_PASSIVATE);
    }

    @PostActivate
    public void afterActivate(InvocationContext context) {
        this.contextual = this.findTargetBean(context.getTarget());
        if (logger.wblWillLogDebug()) {
            logger.debug("manager = {0} interceptor_instance = {1} contextual = {2} ", new Object[]{this.webBeansContext.getBeanManagerImpl(), this, this.contextual});
        }
        this.lifecycleCommon(context, InterceptorType.POST_ACTIVATE);
    }

    public static CreationalContext<?> getThreadCreationalContext() {
        return threadLocalCreationalContext.get();
    }

    public static BaseEjbBean<?> getEjbBean() {
        return threadLocal.get();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (logger.wblWillLogDebug()) {
            logger.debug("manager = {0} interceptor_instance = {1} contextual = {2} ", new Object[]{this.webBeansContext.getBeanManagerImpl(), this, this.contextual});
        }
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        if (logger.wblWillLogDebug()) {
            logger.debug("interceptor instance = " + this.hashCode());
        }
        this.interceptedMethodMap = new WeakHashMap<Method, List<InterceptorData>>();
        this.nonCtxInterceptedMethodMap = new WeakHashMap<Method, List<InterceptorData>>();
        this.resolvedBeans = new HashMap();
        s.defaultReadObject();
        this.webBeansContext = WebBeansContext.currentInstance();
        if (logger.wblWillLogDebug()) {
            logger.debug("manager = {0} interceptor_instance = {1} contextual = {2} ", new Object[]{this.webBeansContext.getBeanManagerImpl(), this, this.contextual});
        }
    }

    private class CreationalKey
    implements Serializable {
        private CreationalKey() {
        }
    }
}

