/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.ejb.common.component;

import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.spi.Context;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.SessionBeanType;
import org.apache.webbeans.component.AbstractInjectionTargetBean;
import org.apache.webbeans.component.EnterpriseBeanMarker;
import org.apache.webbeans.component.WebBeansType;
import org.apache.webbeans.container.BeanManagerImpl;
import org.apache.webbeans.util.ClassUtil;

public abstract class BaseEjbBean<T>
extends AbstractInjectionTargetBean<T>
implements EnterpriseBeanMarker {
    protected final SessionBeanType ejbType;
    private Map<Object, Object> dependentSFSBToBeRemoved = new ConcurrentHashMap<Object, Object>();

    public BaseEjbBean(Class<T> ejbClassType, SessionBeanType type) {
        super(WebBeansType.ENTERPRISE, ejbClassType);
        this.ejbType = type;
        this.setInheritedMetaData();
    }

    public void injectFields(T instance, CreationalContext<T> creationalContext) {
    }

    public boolean isPassivationCapable() {
        return this.getEjbType().equals((Object)SessionBeanType.STATEFUL);
    }

    public void injectFieldInInterceptor(Object instance, CreationalContext<?> creationalContext) {
        super.injectFields(instance, creationalContext);
    }

    protected T createComponentInstance(CreationalContext<T> creationalContext) {
        return this.getInstance(creationalContext);
    }

    protected abstract T getInstance(CreationalContext<T> var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void destroyComponentInstance(T instance, CreationalContext<T> creational) {
        if (!this.getEjbType().equals((Object)SessionBeanType.STATEFUL)) return;
        if (this.getScope() == Dependent.class) {
            try {
                Object ejbInstance = this.getDependentSFSBForProxy(instance);
                if (ejbInstance == null) return;
                this.destroyStatefulSessionBeanInstance(instance, ejbInstance);
                return;
            }
            finally {
                this.removeDependentSFSB(instance);
            }
        } else {
            Context webbeansContext = BeanManagerImpl.getManager().getContext(this.getScope());
            Object ejbInstance = webbeansContext.get((Contextual)this);
            if (ejbInstance == null) return;
            this.destroyStatefulSessionBeanInstance(instance, ejbInstance);
        }
    }

    protected void destroyStatefulSessionBeanInstance(T proxyInstance, Object ejbInstance) {
        Method removeMeth = null;
        for (Method m : this.getRemoveMethods()) {
            try {
                removeMeth = proxyInstance.getClass().getMethod(m.getName(), m.getParameterTypes());
                ClassUtil.callInstanceMethod((Method)removeMeth, proxyInstance, (Object[])ClassUtil.OBJECT_EMPTY);
            }
            catch (NoSuchMethodException e) {
                if (!this.logger.wblWillLogDebug()) continue;
                this.logger.debug("Error calling remove method: ", (Throwable)e);
            }
        }
    }

    public List<Method> getRemoveMethods() {
        return null;
    }

    public List<Class<?>> getBusinessLocalInterfaces() {
        return null;
    }

    public String getEjbName() {
        return null;
    }

    public SessionBeanType getEjbType() {
        return this.ejbType;
    }

    public void addDependentSFSB(Object dependentSFSB, Object proxy) {
        this.dependentSFSBToBeRemoved.put(proxy, dependentSFSB);
    }

    public void removeDependentSFSB(Object proxy) {
        this.dependentSFSBToBeRemoved.remove(proxy);
    }

    public Object getDependentSFSBForProxy(Object proxy) {
        return this.dependentSFSBToBeRemoved.get(proxy);
    }

    public boolean needsBeanLocalViewAddedToTypes() {
        return false;
    }
}

