/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.ejb;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.inject.spi.SessionBeanType;
import org.apache.openejb.Container;
import org.apache.openejb.DeploymentInfo;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.assembler.classic.AppInfo;
import org.apache.openejb.assembler.classic.Assembler;
import org.apache.openejb.assembler.classic.DeploymentListener;
import org.apache.openejb.assembler.classic.EjbJarInfo;
import org.apache.openejb.assembler.classic.EnterpriseBeanInfo;
import org.apache.openejb.assembler.classic.JndiBuilder;
import org.apache.openejb.core.CoreContainerSystem;
import org.apache.openejb.core.CoreDeploymentInfo;
import org.apache.openejb.core.singleton.SingletonContainer;
import org.apache.openejb.core.stateful.StatefulContainer;
import org.apache.openejb.core.stateless.StatelessContainer;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.spi.ContainerSystem;
import org.apache.webbeans.config.WebBeansFinder;
import org.apache.webbeans.ejb.common.component.BaseEjbBean;
import org.apache.webbeans.ejb.common.util.EjbDefinitionUtility;
import org.apache.webbeans.ejb.common.util.EjbUtility;
import org.apache.webbeans.ejb.component.OpenEjbBean;
import org.apache.webbeans.ejb.resource.EJBInstanceProxy;
import org.apache.webbeans.ejb.service.OpenEJBSecurityService;
import org.apache.webbeans.ejb.service.OpenEJBTransactionService;
import org.apache.webbeans.exception.WebBeansConfigurationException;
import org.apache.webbeans.logger.WebBeansLogger;
import org.apache.webbeans.plugins.PluginLoader;
import org.apache.webbeans.spi.SecurityService;
import org.apache.webbeans.spi.TransactionService;
import org.apache.webbeans.spi.plugins.AbstractOwbPlugin;
import org.apache.webbeans.spi.plugins.OpenWebBeansEjbPlugin;
import org.apache.webbeans.util.SecurityUtil;

public class EjbPlugin
extends AbstractOwbPlugin
implements OpenWebBeansEjbPlugin,
DeploymentListener {
    private static final WebBeansLogger logger = WebBeansLogger.getLogger(EjbPlugin.class);
    private ContainerSystem containerSystem = null;
    private Assembler assembler;
    private final Set<AppInfo> deployedApplications = new CopyOnWriteArraySet<AppInfo>();
    private Map<Class<?>, DeploymentInfo> statelessBeans = new ConcurrentHashMap();
    private Map<Class<?>, DeploymentInfo> statefulBeans = new ConcurrentHashMap();
    private Map<Class<?>, DeploymentInfo> singletonBeans = new ConcurrentHashMap();
    private Map<String, EJBInstanceProxy<?>> ejbInstances = new ConcurrentHashMap();
    private static final TransactionService TRANSACTION_SERVICE = new OpenEJBTransactionService();
    private static final SecurityService SECURITY_SERVICE = new OpenEJBSecurityService();
    private final Map<String, JndiBuilder.JndiNameStrategy> nameStrategies = new TreeMap<String, JndiBuilder.JndiNameStrategy>();
    private boolean useInTest = false;

    public void shutDown() throws WebBeansConfigurationException {
        try {
            super.shutDown();
            this.deployedApplications.clear();
            this.statelessBeans.clear();
            this.statefulBeans.clear();
            this.singletonBeans.clear();
            this.containerSystem = null;
            this.ejbInstances.clear();
            this.nameStrategies.clear();
            this.assembler.removeDeploymentListener((DeploymentListener)this);
        }
        catch (Exception e) {
            throw new WebBeansConfigurationException((Throwable)e);
        }
    }

    public <T> T getEjbInstance(String intfName, Class<T> intf) throws Exception {
        EJBInstanceProxy<?> proxy = this.ejbInstances.get(intfName);
        if (proxy != null) {
            return intf.cast(proxy.getObject());
        }
        return null;
    }

    public void startUp() throws WebBeansConfigurationException {
        try {
            super.startUp();
        }
        catch (Exception e) {
            throw new WebBeansConfigurationException((Throwable)e);
        }
        this.containerSystem = (CoreContainerSystem)SystemInstance.get().getComponent(ContainerSystem.class);
        this.assembler = (Assembler)SystemInstance.get().getComponent(Assembler.class);
        if (this.assembler != null) {
            this.assembler.addDeploymentListener((DeploymentListener)this);
            for (AppInfo appInfo : this.assembler.getDeployedApplications()) {
                this.afterApplicationCreated(appInfo);
            }
        }
    }

    public void setUseInTest(boolean useInTest) {
        this.useInTest = useInTest;
    }

    public void afterApplicationCreated(AppInfo appInfo) {
        logger.debug("Retrieving deployed EJB modules");
        if (this.deployedApplications.add(appInfo)) {
            ArrayList<DeploymentInfo> statelessList = new ArrayList<DeploymentInfo>();
            ArrayList<DeploymentInfo> statefulList = new ArrayList<DeploymentInfo>();
            ArrayList<DeploymentInfo> singletonList = new ArrayList<DeploymentInfo>();
            for (EjbJarInfo ejbJar : appInfo.ejbJars) {
                for (EnterpriseBeanInfo bean : ejbJar.enterpriseBeans) {
                    switch (bean.type) {
                        case 2: {
                            statelessList.add(this.containerSystem.getDeploymentInfo((Object)bean.ejbDeploymentId));
                            break;
                        }
                        case 1: {
                            statefulList.add(this.containerSystem.getDeploymentInfo((Object)bean.ejbDeploymentId));
                            break;
                        }
                        case 4: {
                            singletonList.add(this.containerSystem.getDeploymentInfo((Object)bean.ejbDeploymentId));
                            break;
                        }
                    }
                }
            }
            boolean result = this.addBeanDeploymentInfos(statelessList.toArray(new DeploymentInfo[statelessList.size()]), SessionBeanType.STATELESS);
            if (!result) {
                this.deployedApplications.remove(appInfo);
                return;
            }
            result = this.addBeanDeploymentInfos(statefulList.toArray(new DeploymentInfo[statefulList.size()]), SessionBeanType.STATEFUL);
            if (!result) {
                this.deployedApplications.remove(appInfo);
                return;
            }
            result = this.addBeanDeploymentInfos(singletonList.toArray(new DeploymentInfo[singletonList.size()]), SessionBeanType.SINGLETON);
            if (!result) {
                this.deployedApplications.remove(appInfo);
                return;
            }
        }
    }

    public void beforeApplicationDestroyed(AppInfo appInfo) {
        if (this.deployedApplications.contains(appInfo)) {
            this.deployedApplications.remove(appInfo);
            for (EjbJarInfo ejbJar : appInfo.ejbJars) {
                for (EnterpriseBeanInfo bean : ejbJar.enterpriseBeans) {
                    switch (bean.type) {
                        case 2: {
                            this.statelessBeans.remove(this.containerSystem.getDeploymentInfo((Object)bean.ejbDeploymentId).getBeanClass());
                            break;
                        }
                        case 1: {
                            this.statefulBeans.remove(this.containerSystem.getDeploymentInfo((Object)bean.ejbDeploymentId).getBeanClass());
                            break;
                        }
                        case 4: {
                            this.singletonBeans.remove(this.containerSystem.getDeploymentInfo((Object)bean.ejbDeploymentId).getBeanClass());
                            break;
                        }
                    }
                    this.ejbInstances.remove(bean.ejbName);
                }
            }
        }
    }

    public <T> Bean<T> defineSessionBean(Class<T> clazz, ProcessAnnotatedType<T> processAnnotatedTypeEvent) {
        if (!this.isSessionBean(clazz)) {
            throw new IllegalArgumentException("Given class is not an session bean class");
        }
        DeploymentInfo info = null;
        SessionBeanType type = SessionBeanType.STATELESS;
        if (this.isStatelessBean(clazz)) {
            info = this.statelessBeans.get(clazz);
        } else if (this.isStatefulBean(clazz)) {
            info = this.statefulBeans.get(clazz);
            type = SessionBeanType.STATEFUL;
        } else if (this.isSingletonBean(clazz)) {
            info = this.singletonBeans.get(clazz);
            type = SessionBeanType.SINGLETON;
        } else {
            throw new IllegalArgumentException("Illegal EJB type with class : " + clazz.getName());
        }
        OpenEjbBean<T> bean = new OpenEjbBean<T>(clazz, type);
        bean.setDeploymentInfo(info);
        EjbUtility.fireEvents(clazz, bean, processAnnotatedTypeEvent);
        return bean;
    }

    public boolean isSessionBean(Class<?> clazz) {
        if (this.containerSystem == null || this.useInTest) {
            Container[] containers;
            this.useInTest = false;
            this.containerSystem = (ContainerSystem)SystemInstance.get().getComponent(ContainerSystem.class);
            for (Container container : containers = this.containerSystem.containers()) {
                DeploymentInfo[] deployments = container.deployments();
                if (container instanceof StatelessContainer) {
                    this.addBeanDeploymentInfos(deployments, SessionBeanType.STATELESS);
                    continue;
                }
                if (container instanceof StatefulContainer) {
                    this.addBeanDeploymentInfos(deployments, SessionBeanType.STATEFUL);
                    continue;
                }
                if (!(container instanceof SingletonContainer)) continue;
                this.addBeanDeploymentInfos(deployments, SessionBeanType.SINGLETON);
            }
        }
        return this.isSingletonBean(clazz) || this.isStatelessBean(clazz) || this.isStatefulBean(clazz);
    }

    private boolean addBeanDeploymentInfos(DeploymentInfo[] deployments, SessionBeanType type) {
        boolean classLoaderEquality = false;
        if (deployments.length == 0) {
            return true;
        }
        for (DeploymentInfo deployment : deployments) {
            boolean inTest = Boolean.valueOf(SecurityUtil.doPrivilegedGetSystemProperty((String)"EjbPlugin.test", (String)"false"));
            classLoaderEquality = deployment.getBeanClass().getClassLoader().equals(WebBeansFinder.getSingletonClassLoader((Object)PluginLoader.getInstance()));
            if (!inTest && !classLoaderEquality) continue;
            if (type.equals((Object)SessionBeanType.STATELESS)) {
                this.statelessBeans.put(deployment.getBeanClass(), deployment);
            } else if (type.equals((Object)SessionBeanType.STATEFUL)) {
                this.statefulBeans.put(deployment.getBeanClass(), deployment);
            } else if (type.equals((Object)SessionBeanType.SINGLETON)) {
                this.singletonBeans.put(deployment.getBeanClass(), deployment);
            }
            Map<String, EJBInstanceProxy<?>> bindings = this.getEjbBindings((CoreDeploymentInfo)deployment);
            for (Map.Entry<String, EJBInstanceProxy<?>> entry : bindings.entrySet()) {
                String beanName = entry.getKey();
                if (this.ejbInstances.containsKey(beanName)) continue;
                EJBInstanceProxy<?> ejb = entry.getValue();
                this.ejbInstances.put(beanName, ejb);
                logger.info("Exported EJB " + deployment.getEjbName() + " with interface " + entry.getValue().getInterface().getName());
            }
        }
        return classLoaderEquality;
    }

    public void isManagedBean(Class<?> clazz) throws WebBeansConfigurationException {
        if (this.isSessionBean(clazz)) {
            throw new WebBeansConfigurationException("Managed Bean implementation class : " + clazz.getName() + " can not be sesion bean class");
        }
    }

    public boolean isSingletonBean(Class<?> clazz) {
        return this.singletonBeans.containsKey(clazz);
    }

    public boolean isStatefulBean(Class<?> clazz) {
        return this.statefulBeans.containsKey(clazz);
    }

    public boolean isStatelessBean(Class<?> clazz) {
        return this.statelessBeans.containsKey(clazz);
    }

    public Object getSessionBeanProxy(Bean<?> bean, Class<?> iface, CreationalContext<?> creationalContext) {
        return EjbDefinitionUtility.defineEjbBeanProxy((BaseEjbBean)((OpenEjbBean)bean), iface, creationalContext);
    }

    public <T> T getSupportedService(Class<T> serviceClass) {
        if (serviceClass == TransactionService.class) {
            return serviceClass.cast(TRANSACTION_SERVICE);
        }
        if (serviceClass == SecurityService.class) {
            return serviceClass.cast(SECURITY_SERVICE);
        }
        return null;
    }

    public boolean supportService(Class<?> serviceClass) {
        return serviceClass == TransactionService.class || serviceClass == SecurityService.class;
    }

    public JndiBuilder.JndiNameStrategy createStrategy(AppInfo appInfo, List<DeploymentInfo> deployments, DeploymentInfo deployment) throws OpenEJBException {
        JndiBuilder.JndiNameStrategy strategy = this.nameStrategies.get(deployment.getModuleID());
        if (strategy != null) {
            return strategy;
        }
        String deploymentId = (String)deployment.getDeploymentID();
        for (EjbJarInfo ejbJar : appInfo.ejbJars) {
            if (!ejbJar.moduleId.equals(deployment.getModuleID())) continue;
            TreeSet<String> moduleDeploymentIds = new TreeSet<String>();
            for (EnterpriseBeanInfo enterpriseBean : ejbJar.enterpriseBeans) {
                moduleDeploymentIds.add(enterpriseBean.ejbDeploymentId);
            }
            TreeMap<String, DeploymentInfo> moduleDeployments = new TreeMap<String, DeploymentInfo>();
            for (DeploymentInfo deploymentInfo : deployments) {
                if (!moduleDeploymentIds.contains(deploymentId)) continue;
                moduleDeployments.put((String)deploymentInfo.getDeploymentID(), deploymentInfo);
            }
            strategy = JndiBuilder.createStrategy((EjbJarInfo)ejbJar, moduleDeployments);
            for (String moduleDeploymentId : moduleDeploymentIds) {
                this.nameStrategies.put(moduleDeploymentId, strategy);
            }
            return strategy;
        }
        return null;
    }

    public Map<String, EJBInstanceProxy<?>> getEjbBindings(CoreDeploymentInfo deployment) {
        Class localHome;
        TreeMap bindings = new TreeMap();
        Class remoteHome = deployment.getHomeInterface();
        if (remoteHome != null) {
            bindings.put(remoteHome.getName(), new EJBInstanceProxy((DeploymentInfo)deployment, remoteHome));
        }
        if ((localHome = deployment.getLocalHomeInterface()) != null) {
            bindings.put(localHome.getName(), new EJBInstanceProxy((DeploymentInfo)deployment, remoteHome));
        }
        for (Class businessLocal : deployment.getBusinessLocalInterfaces()) {
            bindings.put(businessLocal.getName(), new EJBInstanceProxy((DeploymentInfo)deployment, businessLocal));
        }
        for (Class businessRemote : deployment.getBusinessRemoteInterfaces()) {
            bindings.put(businessRemote.getName(), new EJBInstanceProxy((DeploymentInfo)deployment, businessRemote));
        }
        return bindings;
    }
}

