/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.doccat;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import opennlp.tools.commons.Sample;

public class DocumentSample
implements Sample {
    private static final long serialVersionUID = -1775688015002177141L;
    private final String category;
    private final List<String> text;
    private final Map<String, Object> extraInformation;

    public DocumentSample(String category, String[] text) {
        this(category, text, null);
    }

    public DocumentSample(String category, String[] text, Map<String, Object> extraInformation) {
        Objects.requireNonNull(text, "text must not be null");
        this.category = Objects.requireNonNull(category, "category must not be null");
        this.text = Collections.unmodifiableList(new ArrayList<String>(Arrays.asList(text)));
        this.extraInformation = extraInformation == null ? Collections.emptyMap() : extraInformation;
    }

    public String getCategory() {
        return this.category;
    }

    public String[] getText() {
        return this.text.toArray(new String[this.text.size()]);
    }

    public Map<String, Object> getExtraInformation() {
        return this.extraInformation;
    }

    public String toString() {
        StringBuilder sampleString = new StringBuilder();
        sampleString.append(this.category).append('\t');
        for (String s : this.text) {
            sampleString.append(s).append(' ');
        }
        if (sampleString.length() > 0) {
            sampleString.setLength(sampleString.length() - 1);
        }
        return sampleString.toString();
    }

    public int hashCode() {
        return Objects.hash(this.getCategory(), Arrays.hashCode(this.getText()));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DocumentSample) {
            DocumentSample a = (DocumentSample)obj;
            return this.getCategory().equals(a.getCategory()) && Arrays.equals(this.getText(), a.getText());
        }
        return false;
    }
}

