/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.cmdline;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import opennlp.tools.cmdline.CmdLineUtil;
import opennlp.tools.cmdline.TerminateToolException;
import opennlp.tools.commons.Internal;
import opennlp.tools.util.InvalidFormatException;

@Internal
public abstract class ModelLoader<T> {
    private final String modelName;

    protected ModelLoader(String modelName) {
        this.modelName = Objects.requireNonNull(modelName, "modelName must not be null!");
    }

    protected abstract T loadModel(InputStream var1) throws IOException;

    public T load(File modelFile) {
        T model;
        long beginModelLoadingTime = System.currentTimeMillis();
        CmdLineUtil.checkInputFile(this.modelName + " model", modelFile);
        System.err.print("Loading " + this.modelName + " model ... ");
        try (BufferedInputStream modelIn = new BufferedInputStream(CmdLineUtil.openInFile(modelFile), 0x100000);){
            model = this.loadModel(modelIn);
        }
        catch (InvalidFormatException e) {
            System.err.println("failed");
            throw new TerminateToolException(-1, "Model has invalid format", e);
        }
        catch (IOException e) {
            System.err.println("failed");
            throw new TerminateToolException(-1, "IO error while loading model file '" + modelFile + "'", e);
        }
        long modelLoadingDuration = System.currentTimeMillis() - beginModelLoadingTime;
        System.err.printf("done (%.3fs)\n", (double)modelLoadingDuration / 1000.0);
        return model;
    }
}

