/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.tokenize;

import java.util.ArrayList;
import opennlp.tools.tokenize.AbstractTokenizer;
import opennlp.tools.util.Span;
import opennlp.tools.util.StringUtil;

public class WhitespaceTokenizer
extends AbstractTokenizer {
    public static final WhitespaceTokenizer INSTANCE = new WhitespaceTokenizer();

    private WhitespaceTokenizer() {
    }

    @Override
    public Span[] tokenizePos(String d) {
        int tokStart = -1;
        ArrayList<Span> tokens = new ArrayList<Span>();
        boolean inTok = false;
        int end = d.length();
        for (int i = 0; i < end; ++i) {
            if (StringUtil.isWhitespace(d.charAt(i))) {
                if (inTok) {
                    tokens.add(new Span(tokStart, i));
                    inTok = false;
                    tokStart = -1;
                }
                if (!this.keepNewLines || !this.isLineSeparator(d.charAt(i))) continue;
                tokStart = i;
                tokens.add(new Span(tokStart, tokStart + 1));
                tokStart = -1;
                continue;
            }
            if (inTok) continue;
            tokStart = i;
            inTok = true;
        }
        if (inTok) {
            tokens.add(new Span(tokStart, end));
        }
        return tokens.toArray(new Span[tokens.size()]);
    }

    private boolean isLineSeparator(char character) {
        return character == '\r' || character == '\n';
    }
}

