/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import opennlp.tools.cmdline.ArgumentParser;
import opennlp.tools.cmdline.CmdLineUtil;
import opennlp.tools.cmdline.StreamFactoryRegistry;
import opennlp.tools.cmdline.TerminateToolException;
import opennlp.tools.cmdline.params.EncodingParameter;
import opennlp.tools.doccat.DocumentSample;
import opennlp.tools.formats.AbstractSampleStreamFactory;
import opennlp.tools.formats.LeipzigDoccatSampleStream;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.ObjectStreamUtils;

@Deprecated
public class LeipzigDocumentSampleStreamFactory
extends AbstractSampleStreamFactory<DocumentSample> {
    protected <P> LeipzigDocumentSampleStreamFactory(Class<P> params) {
        super(params);
    }

    public static void registerFactory() {
        StreamFactoryRegistry.registerFactory(DocumentSample.class, "leipzig", new LeipzigDocumentSampleStreamFactory(Parameters.class));
    }

    @Override
    public ObjectStream<DocumentSample> create(String[] args) {
        Parameters params = ArgumentParser.parse(args, Parameters.class);
        File sentencesFileDir = params.getSentencesDir();
        File[] sentencesFiles = sentencesFileDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.contains("sentences") && name.endsWith(".txt");
            }
        });
        ObjectStream[] sampleStreams = new ObjectStream[sentencesFiles.length];
        for (int i = 0; i < sentencesFiles.length; ++i) {
            try {
                sampleStreams[i] = new LeipzigDoccatSampleStream(sentencesFiles[i].getName().substring(0, 3), 20, CmdLineUtil.createInputStreamFactory(sentencesFiles[i]));
                continue;
            }
            catch (IOException e) {
                throw new TerminateToolException(-1, "IO error while opening sample data: " + e.getMessage(), e);
            }
        }
        return ObjectStreamUtils.concatenateObjectStream(sampleStreams);
    }

    static interface Parameters
    extends EncodingParameter {
        @ArgumentParser.ParameterDescription(valueName="sentencesDir", description="dir with Leipig sentences to be used")
        public File getSentencesDir();
    }
}

