/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.slice.jdbc;

import java.security.AccessController;
import java.util.Map;
import org.apache.openjpa.conf.OpenJPAVersion;
import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.jdbc.kernel.JDBCBrokerFactory;
import org.apache.openjpa.kernel.AbstractBrokerFactory;
import org.apache.openjpa.lib.conf.Configuration;
import org.apache.openjpa.lib.conf.ConfigurationProvider;
import org.apache.openjpa.lib.util.J2DoPrivHelper;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.slice.DistributedBrokerFactory;
import org.apache.openjpa.slice.Slice;
import org.apache.openjpa.slice.jdbc.DistributedJDBCConfiguration;
import org.apache.openjpa.slice.jdbc.DistributedJDBCConfigurationImpl;
import org.apache.openjpa.slice.jdbc.DistributedJDBCStoreManager;

public class DistributedJDBCBrokerFactory
extends JDBCBrokerFactory
implements DistributedBrokerFactory {
    private static final Localizer _loc = Localizer.forPackage(DistributedJDBCBrokerFactory.class);

    public static DistributedJDBCBrokerFactory newInstance(ConfigurationProvider cp) {
        DistributedJDBCConfigurationImpl conf = new DistributedJDBCConfigurationImpl(cp);
        cp.setInto((Configuration)conf);
        return new DistributedJDBCBrokerFactory(conf);
    }

    public static JDBCBrokerFactory getInstance(ConfigurationProvider cp) {
        Map properties = cp.getProperties();
        Object key = DistributedJDBCBrokerFactory.toPoolKey((Map)properties);
        DistributedJDBCBrokerFactory factory = (DistributedJDBCBrokerFactory)DistributedJDBCBrokerFactory.getPooledFactoryForKey((Object)key);
        if (factory != null) {
            return factory;
        }
        factory = DistributedJDBCBrokerFactory.newInstance(cp);
        DistributedJDBCBrokerFactory.pool((Object)key, (AbstractBrokerFactory)factory);
        return factory;
    }

    public static synchronized JDBCBrokerFactory getInstance(JDBCConfiguration conf) {
        Map properties = conf.toProperties(false);
        Object key = DistributedJDBCBrokerFactory.toPoolKey((Map)properties);
        DistributedJDBCBrokerFactory factory = (DistributedJDBCBrokerFactory)DistributedJDBCBrokerFactory.getPooledFactoryForKey((Object)key);
        if (factory != null) {
            return factory;
        }
        factory = new DistributedJDBCBrokerFactory((DistributedJDBCConfiguration)conf);
        DistributedJDBCBrokerFactory.pool((Object)key, (AbstractBrokerFactory)factory);
        return factory;
    }

    public DistributedJDBCBrokerFactory(DistributedJDBCConfiguration conf) {
        super((JDBCConfiguration)conf);
    }

    public DistributedJDBCConfiguration getConfiguration() {
        return (DistributedJDBCConfiguration)super.getConfiguration();
    }

    public Slice addSlice(String name, Map properties) {
        Slice slice = this.getConfiguration().addSlice(name, properties);
        ClassLoader loader = (ClassLoader)AccessController.doPrivileged(J2DoPrivHelper.getContextClassLoaderAction());
        this.synchronizeMappings(loader, (JDBCConfiguration)slice.getConfiguration());
        return slice;
    }

    protected DistributedJDBCStoreManager newStoreManager() {
        return new DistributedJDBCStoreManager(this.getConfiguration());
    }

    protected Object getFactoryInitializationBanner() {
        return _loc.get("factory-init", (Object)OpenJPAVersion.VERSION_NUMBER);
    }
}

