/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.slice;

import org.apache.openjpa.kernel.FinalizingBrokerImpl;
import org.apache.openjpa.kernel.OpCallbacks;
import org.apache.openjpa.kernel.OpenJPAStateManager;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.slice.DistributedConfiguration;
import org.apache.openjpa.util.UserException;

public class DistributedBrokerImpl
extends FinalizingBrokerImpl {
    private transient String slice;
    private static final Localizer _loc = Localizer.forPackage(DistributedBrokerImpl.class);

    public OpenJPAStateManager persist(Object pc, Object id, boolean explicit, OpCallbacks call) {
        OpenJPAStateManager sm = this.getStateManager(pc);
        if (this.getOperatingSet().isEmpty() && (sm == null || sm.getImplData() == null)) {
            this.slice = this.getSlice(pc);
        }
        if ((sm = super.persist(pc, id, explicit, call)).getImplData() == null) {
            sm.setImplData((Object)this.slice, true);
        }
        return sm;
    }

    String getSlice(Object pc) {
        DistributedConfiguration conf = (DistributedConfiguration)this.getConfiguration();
        String slice = conf.getDistributionPolicyInstance().distribute(pc, conf.getActiveSliceNames(), (Object)this);
        if (!conf.getActiveSliceNames().contains(slice)) {
            throw new UserException(_loc.get("bad-policy-slice", new Object[]{conf.getDistributionPolicyInstance().getClass().getName(), slice, pc, conf.getActiveSliceNames()}));
        }
        return slice;
    }

    public boolean endOperation() {
        try {
            return super.endOperation();
        }
        catch (Exception exception) {
            return true;
        }
    }
}

