/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence;

import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.SharedCacheMode;
import jakarta.persistence.ValidationMode;
import jakarta.persistence.spi.PersistenceUnitInfo;
import jakarta.persistence.spi.PersistenceUnitTransactionType;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;
import org.apache.openjpa.conf.Compatibility;
import org.apache.openjpa.conf.OpenJPAConfiguration;
import org.apache.openjpa.conf.OpenJPAConfigurationImpl;
import org.apache.openjpa.conf.OpenJPAProductDerivation;
import org.apache.openjpa.conf.Specification;
import org.apache.openjpa.datacache.DataCacheMode;
import org.apache.openjpa.lib.conf.AbstractProductDerivation;
import org.apache.openjpa.lib.conf.Configuration;
import org.apache.openjpa.lib.conf.ConfigurationProvider;
import org.apache.openjpa.lib.conf.Configurations;
import org.apache.openjpa.lib.conf.MapConfigurationProvider;
import org.apache.openjpa.lib.conf.ProductDerivations;
import org.apache.openjpa.lib.conf.Value;
import org.apache.openjpa.lib.log.Log;
import org.apache.openjpa.lib.meta.XMLMetaDataParser;
import org.apache.openjpa.lib.meta.XMLVersionParser;
import org.apache.openjpa.lib.util.J2DoPrivHelper;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.lib.util.MultiClassLoader;
import org.apache.openjpa.lib.util.StringUtil;
import org.apache.openjpa.persistence.EntityManagerFactoryValue;
import org.apache.openjpa.persistence.JPAProperties;
import org.apache.openjpa.persistence.PersistenceMetaDataFactory;
import org.apache.openjpa.persistence.PersistenceProviderImpl;
import org.apache.openjpa.persistence.PersistenceUnitInfoImpl;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class PersistenceProductDerivation
extends AbstractProductDerivation
implements OpenJPAProductDerivation {
    public static final Specification SPEC_JPA = new Specification("jpa 2");
    public static final Specification ALIAS_EJB = new Specification("ejb 3");
    public static final String RSRC_GLOBAL = "META-INF/openjpa.xml";
    public static final String RSRC_DEFAULT = "META-INF/persistence.xml";
    public static final BigDecimal VERSION_1_0 = BigDecimal.valueOf(1.0);
    private static final Localizer _loc = Localizer.forPackage(PersistenceProductDerivation.class);
    private HashMap<String, PUNameCollision> _puNameCollisions = new HashMap();
    public static final String PREFIX = "jakarta.persistence";
    private static final String[] _invalidPersistenceProperties = new String[]{"jakarta.persistence.cache.storeMode", "jakarta.persistence.cache.retrieveMode"};
    private static Set<String> _hints = new HashSet<String>();
    protected String _providerImplName = PersistenceProviderImpl.class.getName();

    public void putBrokerFactoryAliases(Map<String, String> m) {
    }

    public int getType() {
        return 0;
    }

    public String getConfigurationPrefix() {
        return PREFIX;
    }

    public Set<String> getSupportedQueryHints() {
        return _hints;
    }

    public void validate() throws Exception {
        AccessController.doPrivileged(J2DoPrivHelper.getClassLoaderAction(EntityManagerFactory.class));
    }

    public boolean beforeConfigurationLoad(Configuration c) {
        if (!(c instanceof OpenJPAConfigurationImpl)) {
            return false;
        }
        OpenJPAConfigurationImpl conf = (OpenJPAConfigurationImpl)c;
        conf.metaFactoryPlugin.setAlias(ALIAS_EJB.getName(), PersistenceMetaDataFactory.class.getName());
        conf.metaFactoryPlugin.setAlias(SPEC_JPA.getName(), PersistenceMetaDataFactory.class.getName());
        conf.addValue((Value)new EntityManagerFactoryValue());
        conf.readLockLevel.setAlias("optimistic", String.valueOf(15));
        conf.readLockLevel.setAlias("optimistic-force-increment", String.valueOf(25));
        conf.readLockLevel.setAlias("pessimistic-read", String.valueOf(30));
        conf.readLockLevel.setAlias("pessimistic-write", String.valueOf(40));
        conf.readLockLevel.setAlias("pessimistic-force-increment", String.valueOf(50));
        conf.writeLockLevel.setAlias("optimistic", String.valueOf(15));
        conf.writeLockLevel.setAlias("optimistic-force-increment", String.valueOf(25));
        conf.writeLockLevel.setAlias("pessimistic-read", String.valueOf(30));
        conf.writeLockLevel.setAlias("pessimistic-write", String.valueOf(40));
        conf.writeLockLevel.setAlias("pessimistic-force-increment", String.valueOf(50));
        this.configureBeanValidation(conf);
        conf.dataCacheMode = conf.addString("jakarta.persistence.sharedCache.mode");
        conf.dataCacheMode.setDefault(DataCacheMode.UNSPECIFIED.toString());
        conf.dataCacheMode.set(DataCacheMode.UNSPECIFIED.toString());
        return true;
    }

    private void configureBeanValidation(OpenJPAConfigurationImpl conf) {
        conf.validationFactory = conf.addObject("jakarta.persistence.validation.factory");
        conf.validator = conf.addObject("Validator");
        conf.validationMode = conf.addString("jakarta.persistence.validation.mode");
        conf.validationGroupPrePersist = conf.addString("jakarta.persistence.validation.group.pre-persist");
        conf.validationGroupPreUpdate = conf.addString("jakarta.persistence.validation.group.pre-update");
        conf.validationGroupPreRemove = conf.addString("jakarta.persistence.validation.group.pre-remove");
        conf.validationMode.setDynamic(true);
        String[] aliases = new String[]{String.valueOf(ValidationMode.AUTO), String.valueOf(ValidationMode.AUTO).toLowerCase(Locale.ENGLISH), String.valueOf(ValidationMode.CALLBACK), String.valueOf(ValidationMode.CALLBACK).toLowerCase(Locale.ENGLISH), String.valueOf(ValidationMode.NONE), String.valueOf(ValidationMode.NONE).toLowerCase(Locale.ENGLISH)};
        conf.validationMode.setAliases(aliases);
        conf.validationMode.setAliasListComprehensive(true);
        conf.validationMode.setDefault(aliases[0]);
        conf.validationGroupPrePersist.setString("jakarta.validation.groups.Default");
        conf.validationGroupPrePersist.setDefault("");
        conf.validationGroupPrePersist.setDynamic(true);
        conf.validationGroupPreUpdate.setString("jakarta.validation.groups.Default");
        conf.validationGroupPreUpdate.setDefault("");
        conf.validationGroupPreUpdate.setDynamic(true);
        conf.validationGroupPreRemove.setDefault("");
        conf.validationGroupPreRemove.setDynamic(true);
        conf.validationFactory.setInstantiatingGetter("getValidationFactoryInstance");
        conf.validationFactory.setDynamic(true);
        conf.validator.setInstantiatingGetter("getValidatorInstance");
        conf.validator.setDynamic(true);
        conf.validator.makePrivate();
    }

    public boolean afterSpecificationSet(Configuration c) {
        if (!OpenJPAConfigurationImpl.class.isInstance(c) && !SPEC_JPA.isSame(((OpenJPAConfiguration)c).getSpecification())) {
            return false;
        }
        OpenJPAConfigurationImpl conf = (OpenJPAConfigurationImpl)c;
        conf.metaFactoryPlugin.setDefault(SPEC_JPA.getName());
        conf.metaFactoryPlugin.setString(SPEC_JPA.getName());
        conf.nontransactionalWrite.setDefault("true");
        conf.nontransactionalWrite.set(true);
        Specification spec = ((OpenJPAConfiguration)c).getSpecificationInstance();
        int specVersion = spec.getVersion();
        Compatibility compatibility = conf.getCompatibilityInstance();
        spec.setCompatibility(compatibility);
        if (specVersion < 2) {
            compatibility.setFlushBeforeDetach(true);
            compatibility.setCopyOnDetach(true);
            compatibility.setPrivatePersistentProperties(true);
            compatibility.setIgnoreDetachedStateFieldForProxySerialization(true);
            conf.validationMode.set(String.valueOf(ValidationMode.NONE));
        } else {
            compatibility.setAbstractMappingUniDirectional(true);
            compatibility.setNonDefaultMappingAllowed(true);
        }
        return true;
    }

    public ConfigurationProvider load(PersistenceUnitInfo pinfo, Map m) throws IOException {
        PersistenceUnitInfoImpl impl;
        if (pinfo == null) {
            return null;
        }
        if (!PersistenceProductDerivation.isOpenJPAPersistenceProvider(pinfo, null)) {
            PersistenceProductDerivation.warnUnknownProvider(pinfo);
            return null;
        }
        ConfigurationProviderImpl cp = new ConfigurationProviderImpl();
        cp.addProperties(PersistenceUnitInfoImpl.toOpenJPAProperties(pinfo));
        cp.addProperties(m);
        if (pinfo instanceof PersistenceUnitInfoImpl && (impl = (PersistenceUnitInfoImpl)pinfo).getPersistenceXmlFileUrl() != null) {
            cp.setSource(impl.getPersistenceXmlFileUrl().toString());
        }
        return cp;
    }

    public ConfigurationProvider load(String rsrc, String name, Map m) throws IOException {
        ConfigurationProviderImpl cp;
        Boolean ret;
        boolean explicit;
        boolean bl = explicit = !StringUtil.isEmpty((String)rsrc);
        if (!explicit) {
            rsrc = RSRC_DEFAULT;
        }
        if ((ret = this.load(cp = new ConfigurationProviderImpl(), rsrc, name, m, null, explicit)) != null) {
            return ret != false ? cp : null;
        }
        if (explicit) {
            return null;
        }
        PersistenceUnitInfoImpl pinfo = new PersistenceUnitInfoImpl();
        pinfo.fromUserProperties(m);
        if (!PersistenceProductDerivation.isOpenJPAPersistenceProvider(pinfo, null)) {
            PersistenceProductDerivation.warnUnknownProvider(pinfo);
            return null;
        }
        cp.addProperties(pinfo.toOpenJPAProperties());
        return cp;
    }

    public ConfigurationProvider load(String rsrc, String anchor, ClassLoader loader) throws IOException {
        if (rsrc != null && !rsrc.endsWith(".xml")) {
            return null;
        }
        ConfigurationProviderImpl cp = new ConfigurationProviderImpl();
        if (this.load(cp, rsrc, anchor, null, loader, true) == Boolean.TRUE) {
            return cp;
        }
        return null;
    }

    public ConfigurationProvider load(File file, String anchor) throws IOException {
        if (!file.getName().endsWith(".xml")) {
            return null;
        }
        ConfigurationParser parser = new ConfigurationParser(null);
        parser.parse(file);
        return this.load(this.findUnit(parser.getResults(), anchor, null), null);
    }

    public String getDefaultResourceLocation() {
        return RSRC_DEFAULT;
    }

    public List<String> getAnchorsInFile(File file) throws IOException {
        ConfigurationParser parser = new ConfigurationParser(null);
        try {
            parser.parse(file);
            return this.getUnitNames(parser);
        }
        catch (IOException e) {
            return null;
        }
    }

    private List<String> getUnitNames(ConfigurationParser parser) {
        List units = parser.getResults();
        ArrayList<String> names = new ArrayList<String>();
        for (PersistenceUnitInfoImpl unit : units) {
            String provider = unit.getPersistenceProviderClassName();
            if (provider != null && !provider.equals(this._providerImplName)) continue;
            names.add(unit.getPersistenceUnitName());
        }
        return names;
    }

    public List getAnchorsInResource(String resource) throws Exception {
        ConfigurationParser parser = new ConfigurationParser(null);
        try {
            ArrayList<String> results = new ArrayList<String>();
            ClassLoader loader = (ClassLoader)AccessController.doPrivileged(J2DoPrivHelper.getContextClassLoaderAction());
            List<URL> urls = PersistenceProductDerivation.getResourceURLs(resource, loader);
            if (urls != null) {
                for (URL url : urls) {
                    parser.parse(url);
                    results.addAll(this.getUnitNames(parser));
                }
            }
            return results;
        }
        catch (IOException e) {
            return null;
        }
    }

    public ConfigurationProvider loadGlobals(ClassLoader loader) throws IOException {
        int idx;
        String[] prefixes = ProductDerivations.getConfigurationPrefixes();
        String rsrc = null;
        for (int i = 0; i < prefixes.length && StringUtil.isEmpty(rsrc); ++i) {
            rsrc = (String)AccessController.doPrivileged(J2DoPrivHelper.getPropertyAction((String)(prefixes[i] + ".properties")));
        }
        boolean explicit = !StringUtil.isEmpty(rsrc);
        String anchor = null;
        int n = idx = !explicit ? -1 : rsrc.lastIndexOf(35);
        if (idx != -1) {
            if (idx < rsrc.length() - 1) {
                anchor = rsrc.substring(idx + 1);
            }
            rsrc = rsrc.substring(0, idx);
        }
        if (StringUtil.isEmpty((String)rsrc)) {
            rsrc = RSRC_GLOBAL;
        } else if (!rsrc.endsWith(".xml")) {
            return null;
        }
        ConfigurationProviderImpl cp = new ConfigurationProviderImpl();
        if (this.load(cp, rsrc, anchor, null, loader, explicit) == Boolean.TRUE) {
            return cp;
        }
        return null;
    }

    public ConfigurationProvider loadDefaults(ClassLoader loader) throws IOException {
        ConfigurationProviderImpl cp = new ConfigurationProviderImpl();
        if (this.load(cp, RSRC_DEFAULT, null, null, loader, false) == Boolean.TRUE) {
            return cp;
        }
        return null;
    }

    public boolean checkPuNameCollisions(Log logger, String puName) {
        PUNameCollision p = this._puNameCollisions.get(puName);
        if (p != null) {
            p.logCollision(logger);
            return true;
        }
        return false;
    }

    private static List<URL> getResourceURLs(String rsrc, ClassLoader loader) throws IOException {
        Enumeration urls = null;
        try {
            urls = (Enumeration)AccessController.doPrivileged(J2DoPrivHelper.getResourcesAction((ClassLoader)loader, (String)rsrc));
            if (!urls.hasMoreElements()) {
                if (!rsrc.startsWith("META-INF")) {
                    urls = (Enumeration)AccessController.doPrivileged(J2DoPrivHelper.getResourcesAction((ClassLoader)loader, (String)("META-INF/" + rsrc)));
                }
                if (!urls.hasMoreElements()) {
                    return null;
                }
            }
        }
        catch (PrivilegedActionException pae) {
            throw (IOException)pae.getException();
        }
        return Collections.list(urls);
    }

    private Boolean load(ConfigurationProviderImpl cp, String rsrc, String name, Map m, ClassLoader loader, boolean explicit) throws IOException {
        List<URL> urls;
        ClassLoader contextLoader = null;
        if (loader == null) {
            loader = contextLoader = (ClassLoader)AccessController.doPrivileged(J2DoPrivHelper.getContextClassLoaderAction());
        }
        if ((urls = PersistenceProductDerivation.getResourceURLs(rsrc, loader)) == null || urls.size() == 0) {
            return null;
        }
        ConfigurationParser parser = new ConfigurationParser(m);
        PersistenceUnitInfoImpl pinfo = this.parseResources(parser, urls, name, loader);
        if (pinfo == null) {
            if (!explicit) {
                return Boolean.FALSE;
            }
            throw new MissingResourceException(_loc.get("missing-xml-config", (Object)rsrc, (Object)String.valueOf(name)).getMessage(), ((Object)((Object)this)).getClass().getName(), rsrc);
        }
        if (!PersistenceProductDerivation.isOpenJPAPersistenceProvider(pinfo, loader)) {
            if (!explicit) {
                PersistenceProductDerivation.warnUnknownProvider(pinfo);
                return Boolean.FALSE;
            }
            throw new MissingResourceException(_loc.get("unknown-provider", (Object)rsrc, (Object)name, (Object)pinfo.getPersistenceProviderClassName()).getMessage(), ((Object)((Object)this)).getClass().getName(), rsrc);
        }
        if (loader != contextLoader && loader instanceof MultiClassLoader) {
            MultiClassLoader mutliClassLoader = (MultiClassLoader)loader;
            contextLoader = contextLoader != null ? contextLoader : (ClassLoader)AccessController.doPrivileged(J2DoPrivHelper.getContextClassLoaderAction());
            mutliClassLoader.addClassLoader(contextLoader);
            AccessController.doPrivileged(J2DoPrivHelper.setContextClassLoaderAction((ClassLoader)mutliClassLoader));
        }
        pinfo.processJarFileNames();
        if (contextLoader != null) {
            AccessController.doPrivileged(J2DoPrivHelper.setContextClassLoaderAction((ClassLoader)contextLoader));
        }
        cp.addProperties(pinfo.toOpenJPAProperties());
        cp.setSource(pinfo.getPersistenceXmlFileUrl().toString());
        return Boolean.TRUE;
    }

    private PersistenceUnitInfoImpl parseResources(ConfigurationParser parser, List<URL> urls, String name, ClassLoader loader) throws IOException {
        ArrayList<PersistenceUnitInfoImpl> pinfos = new ArrayList<PersistenceUnitInfoImpl>();
        for (URL url : urls) {
            parser.parse(url);
            pinfos.addAll(parser.getResults());
        }
        return this.findUnit(pinfos, name, loader);
    }

    private PersistenceUnitInfoImpl findUnit(List<PersistenceUnitInfoImpl> pinfos, String name, ClassLoader loader) {
        PersistenceUnitInfoImpl ojpa = null;
        PersistenceUnitInfoImpl result = null;
        for (PersistenceUnitInfoImpl pinfo : pinfos) {
            if (name != null) {
                if (!name.equals(pinfo.getPersistenceUnitName())) continue;
                if (result != null) {
                    this.addPuNameCollision(name, result.getPersistenceXmlFileUrl().toString(), pinfo.getPersistenceXmlFileUrl().toString());
                    continue;
                }
                result = pinfo;
                continue;
            }
            if (!PersistenceProductDerivation.isOpenJPAPersistenceProvider(pinfo, loader)) continue;
            if (StringUtil.isEmpty((String)pinfo.getPersistenceUnitName())) {
                return pinfo;
            }
            if (ojpa != null) continue;
            ojpa = pinfo;
        }
        if (result != null) {
            return result;
        }
        return ojpa;
    }

    private static boolean isOpenJPAPersistenceProvider(PersistenceUnitInfo pinfo, ClassLoader loader) {
        String provider = pinfo.getPersistenceProviderClassName();
        if (StringUtil.isEmpty((String)provider) || PersistenceProviderImpl.class.getName().equals(provider)) {
            return true;
        }
        if (loader == null) {
            loader = (ClassLoader)AccessController.doPrivileged(J2DoPrivHelper.getContextClassLoaderAction());
        }
        try {
            if (PersistenceProviderImpl.class.isAssignableFrom(Class.forName(provider, false, loader))) {
                return true;
            }
        }
        catch (Throwable t) {
            PersistenceProductDerivation.log(_loc.get("unloadable-provider", (Object)provider, (Object)t).getMessage());
            return false;
        }
        return false;
    }

    private static void warnUnknownProvider(PersistenceUnitInfo pinfo) {
        PersistenceProductDerivation.log(_loc.get("unrecognized-provider", (Object)pinfo.getPersistenceProviderClassName()).getMessage());
    }

    private static void log(String msg) {
        System.err.println(msg);
    }

    private void addPuNameCollision(String puName, String file1, String file2) {
        PUNameCollision pun = this._puNameCollisions.get(puName);
        if (pun != null) {
            pun.addCollision(file1, file2);
        } else {
            this._puNameCollisions.put(puName, new PUNameCollision(puName, file1, file2));
        }
    }

    static {
        _hints.add("jakarta.persistence.lock.timeout");
        _hints.add("jakarta.persistence.query.timeout");
        _hints.add("openjpa.FetchPlan.ExtendedPathLookup");
        _hints.add("openjpa.FetchBatchSize");
        _hints.add("openjpa.FetchPlan.FetchBatchSize");
        _hints.add("openjpa.MaxFetchDepth");
        _hints.add("openjpa.FetchPlan.MaxFetchDepth");
        _hints.add("openjpa.LockTimeout");
        _hints.add("openjpa.FetchPlan.LockTimeout");
        _hints.add("openjpa.QueryTimeout");
        _hints.add("openjpa.FetchPlan.QueryTimeout");
        _hints.add("openjpa.FlushBeforeQueries");
        _hints.add("openjpa.FetchPlan.FlushBeforeQueries");
        _hints.add("openjpa.ReadLockLevel");
        _hints.add("openjpa.FetchPlan.ReadLockLevel");
        _hints.add("openjpa.WriteLockLevel");
        _hints.add("openjpa.FetchPlan.WriteLockLevel");
        _hints.add("openjpa.FetchPlan.FetchBatchSize");
        _hints.add("openjpa.FetchPlan.LockScope");
        _hints.add("openjpa.FetchPlan.LockTimeout");
        _hints.add("openjpa.FetchPlan.MaxFetchDepth");
        _hints.add("openjpa.FetchPlan.QueryTimeout");
        _hints.add("openjpa.FetchPlan.ReadLockMode");
        _hints.add("openjpa.FetchPlan.WriteLockMode");
        _hints.add("openjpa.AggregateListener");
        _hints.add("openjpa.AggregateListeners");
        _hints.add("openjpa.FilterListener");
        _hints.add("openjpa.FilterListeners");
        _hints.add("openjpa.hint.IgnoreFinder");
        _hints.add("openjpa.hint.IgnorePreparedQuery");
        _hints.add("openjpa.hint.InvalidateFinder");
        _hints.add("openjpa.hint.InvalidatePreparedQuery");
        _hints.add("openjpa.hint.ParameterMarkerInQuery");
        _hints.add("openjpa.hint.RecacheFinder");
        _hints.add("openjpa.hint.OptimizeResultCount");
        _hints.add("openjpa.Subclasses");
        _hints.add("openjpa.hint.RelaxParameterTypeChecking");
        _hints.add("openjpa.hint.UseLiteralInSQL");
        _hints = Collections.unmodifiableSet(_hints);
    }

    private static class PUNameCollision {
        private String _puName;
        private Set<String> _resources = new LinkedHashSet<String>();

        PUNameCollision(String puName, String file1, String file2) {
            this._resources.add(file1);
            this._resources.add(file2);
            this._puName = puName;
        }

        void logCollision(Log logger) {
            if (logger.isWarnEnabled()) {
                logger.warn((Object)_loc.getFatal("dup-pu", new Object[]{this._puName, this._resources.toString(), this._resources.iterator().next()}));
            }
        }

        void addCollision(String file1, String file2) {
            this._resources.add(file1);
            this._resources.add(file2);
        }
    }

    public static class ConfigurationParser
    extends XMLMetaDataParser {
        private static final String PERSISTENCE_XSD_2_0 = "persistence_2_0.xsd";
        private static final String PERSISTENCE_XSD_2_1 = "persistence_2_1.xsd";
        private static final String PERSISTENCE_XSD_2_2 = "persistence_2_2.xsd";
        private static final String PERSISTENCE_XSD_3_0 = "persistence_3_0.xsd";
        private static final Localizer _loc = Localizer.forPackage(ConfigurationParser.class);
        private final Map _map;
        private PersistenceUnitInfoImpl _info = null;
        private URL _source = null;
        private String _persistenceVersion;
        private String _schemaLocation;
        private boolean _excludeUnlistedSet = false;

        public ConfigurationParser(Map map) {
            this._map = map;
            this.setCaching(false);
            this.setValidating(true);
            this.setParseText(true);
        }

        public void parse(URL url) throws IOException {
            this._source = url;
            XMLVersionParser vp = new XMLVersionParser("persistence");
            try {
                vp.parse(url);
                this._persistenceVersion = vp.getVersion();
                this._schemaLocation = vp.getSchemaLocation();
            }
            catch (Throwable t) {
                PersistenceProductDerivation.log(_loc.get("version-check-error", (Object)this._source.toString()).toString());
            }
            super.parse(url);
        }

        public void parse(File file) throws IOException {
            try {
                this._source = (URL)AccessController.doPrivileged(J2DoPrivHelper.toURLAction((File)file));
            }
            catch (PrivilegedActionException pae) {
                throw (MalformedURLException)pae.getException();
            }
            XMLVersionParser vp = new XMLVersionParser("persistence");
            try {
                vp.parse(file);
                this._persistenceVersion = vp.getVersion();
                this._schemaLocation = vp.getSchemaLocation();
            }
            catch (Throwable t) {
                PersistenceProductDerivation.log(_loc.get("version-check-error", (Object)this._source.toString()).toString());
            }
            super.parse(file);
        }

        protected Object getSchemaSource() {
            String persistencexsd = "persistence.xsd.rsrc";
            if ("2.0".equals(this._persistenceVersion) || this._schemaLocation != null && this._schemaLocation.indexOf(PERSISTENCE_XSD_2_0) != -1) {
                persistencexsd = "persistence_2_0.xsd.rsrc";
            } else if ("2.1".equals(this._persistenceVersion) || this._schemaLocation != null && this._schemaLocation.indexOf(PERSISTENCE_XSD_2_1) != -1) {
                persistencexsd = "persistence_2_1.xsd.rsrc";
            } else if ("2.2".equals(this._persistenceVersion) || this._schemaLocation != null && this._schemaLocation.indexOf(PERSISTENCE_XSD_2_2) != -1) {
                persistencexsd = "persistence_2_2.xsd.rsrc";
            } else if ("3.0".equals(this._persistenceVersion) || this._schemaLocation != null && this._schemaLocation.indexOf(PERSISTENCE_XSD_3_0) != -1) {
                persistencexsd = "persistence_3_0.xsd.rsrc";
            }
            return ((Object)((Object)this)).getClass().getResourceAsStream(persistencexsd);
        }

        protected void reset() {
            super.reset();
            this._info = null;
            this._source = null;
            this._excludeUnlistedSet = false;
        }

        protected boolean startElement(String name, Attributes attrs) throws SAXException {
            if (this.currentDepth() == 1) {
                this.startPersistenceUnit(attrs);
            } else if (this.currentDepth() == 3 && "property".equals(name)) {
                this._info.setProperty(attrs.getValue("name"), attrs.getValue("value"));
            }
            return true;
        }

        protected void endElement(String name) throws SAXException {
            if (this.currentDepth() == 1) {
                this.endPersistenceUnit();
                this._info.fromUserProperties(this._map);
                this.addResult(this._info);
            }
            if (this.currentDepth() != 2) {
                return;
            }
            switch (name.charAt(0)) {
                case 'c': {
                    this._info.addManagedClassName(this.currentText());
                    break;
                }
                case 'e': {
                    this.setExcludeUnlistedClasses(this.currentText());
                    break;
                }
                case 'j': {
                    if ("jta-data-source".equals(name)) {
                        this._info.setJtaDataSourceName(this.currentText());
                        break;
                    }
                    try {
                        this._info.addJarFileName(this.currentText());
                        break;
                    }
                    catch (IllegalArgumentException iae) {
                        throw this.getException(iae.getMessage());
                    }
                }
                case 'm': {
                    this._info.addMappingFileName(this.currentText());
                    break;
                }
                case 'n': {
                    this._info.setNonJtaDataSourceName(this.currentText());
                    break;
                }
                case 'p': {
                    if (!"provider".equals(name)) break;
                    this._info.setPersistenceProviderClassName(this.currentText());
                    break;
                }
                case 's': {
                    this._info.setSharedCacheMode(JPAProperties.getEnumValue(SharedCacheMode.class, this.currentText()));
                    break;
                }
                case 'v': {
                    this._info.setValidationMode(JPAProperties.getEnumValue(ValidationMode.class, this.currentText()));
                }
            }
        }

        private void setExcludeUnlistedClasses(String value) {
            if (!this._excludeUnlistedSet) {
                BigDecimal version = this.getPersistenceVersion();
                boolean excludeUnlisted = version.compareTo(VERSION_1_0) > 0 ? !"false".equalsIgnoreCase(value) : "true".equalsIgnoreCase(value);
                this._info.setExcludeUnlistedClasses(excludeUnlisted);
                this._excludeUnlistedSet = true;
            }
        }

        private void startPersistenceUnit(Attributes attrs) throws SAXException {
            this._excludeUnlistedSet = false;
            this._info = new PersistenceUnitInfoImpl();
            this._info.setPersistenceUnitName(attrs.getValue("name"));
            this._info.setPersistenceXMLSchemaVersion(this._persistenceVersion);
            String val = attrs.getValue("transaction-type");
            if (val == null) {
                this._info.setTransactionType(PersistenceUnitTransactionType.RESOURCE_LOCAL);
            } else {
                this._info.setTransactionType(Enum.valueOf(PersistenceUnitTransactionType.class, val));
            }
            if (this._source != null) {
                this._info.setPersistenceXmlFileUrl(this._source);
            }
        }

        private void endPersistenceUnit() {
            if (!this._excludeUnlistedSet) {
                this.setExcludeUnlistedClasses(null);
            }
        }

        private BigDecimal getPersistenceVersion() {
            if (this._info.getPersistenceXMLSchemaVersion() != null) {
                try {
                    return new BigDecimal(this._info.getPersistenceXMLSchemaVersion());
                }
                catch (Throwable t) {
                    PersistenceProductDerivation.log(_loc.get("invalid-version-attribute", (Object)this._info.getPersistenceXMLSchemaVersion(), (Object)VERSION_1_0.toString()).toString());
                }
            }
            return VERSION_1_0;
        }
    }

    public static class ConfigurationProviderImpl
    extends MapConfigurationProvider {
        private String _source;

        public ConfigurationProviderImpl() {
        }

        public ConfigurationProviderImpl(Map props) {
            super(props);
        }

        public void setSource(String source) {
            this._source = source;
        }

        public void setInto(Configuration conf) {
            Log log;
            OpenJPAConfiguration oconf;
            if (conf instanceof OpenJPAConfiguration) {
                oconf = (OpenJPAConfiguration)conf;
                Object persistenceVersion = this.getProperties().get("PersistenceVersion");
                if (persistenceVersion == null) {
                    oconf.setSpecification(SPEC_JPA);
                } else {
                    oconf.setSpecification("jpa " + persistenceVersion.toString());
                }
                String orig = oconf.getMetaDataFactory();
                if (!StringUtil.isEmpty((String)orig)) {
                    String key = ProductDerivations.getConfigurationKey((String)"MetaDataFactory", (Map)this.getProperties());
                    Object override = this.getProperties().get(key);
                    if (override instanceof String) {
                        this.addProperty(key, Configurations.combinePlugins((String)orig, (String)((String)override)));
                    }
                }
            }
            super.setInto(conf, null);
            if (conf instanceof OpenJPAConfiguration) {
                Log log2;
                oconf = (OpenJPAConfiguration)conf;
                String dataCache = oconf.getDataCache();
                String sharedDataCacheMode = oconf.getDataCacheMode();
                if (DataCacheMode.NONE.toString().equals(sharedDataCacheMode) && dataCache != null && !"false".equals(dataCache) && (log2 = conf.getConfigurationLog()).isWarnEnabled()) {
                    log2.warn((Object)_loc.get("shared-cache-mode-take-precedence", (Object)dataCache));
                }
                if (!(dataCache != null && !"false".equals(dataCache) || DataCacheMode.NONE.toString().equals(sharedDataCacheMode) || DataCacheMode.UNSPECIFIED.toString().equals(sharedDataCacheMode))) {
                    oconf.setDataCache("true");
                }
                String rcp = oconf.getRemoteCommitProvider();
                dataCache = oconf.getDataCache();
                if (dataCache != null && !"false".equals(dataCache) && (rcp == null || "".equals(rcp))) {
                    oconf.setRemoteCommitProvider("sjvm");
                }
            }
            if ((log = conf.getConfigurationLog()).isWarnEnabled()) {
                Map props = this.getProperties();
                for (String propKey : _invalidPersistenceProperties) {
                    Object propValue = props.get(propKey);
                    if (propValue == null) continue;
                    log.warn((Object)_loc.get("invalid-persistence-property", new Object[]{propKey, propValue}));
                }
            }
            if (log.isTraceEnabled()) {
                String src = this._source == null ? "?" : this._source;
                log.trace((Object)_loc.get("conf-load", (Object)src, (Object)this.getProperties()));
            }
        }
    }
}

