/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence;

import jakarta.persistence.LockModeType;
import jakarta.persistence.PessimisticLockScope;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.openjpa.kernel.DataCacheRetrieveMode;
import org.apache.openjpa.kernel.DataCacheStoreMode;
import org.apache.openjpa.kernel.DelegatingFetchConfiguration;
import org.apache.openjpa.kernel.FetchConfiguration;
import org.apache.openjpa.persistence.FetchPlan;
import org.apache.openjpa.persistence.HintValueConverter;
import org.apache.openjpa.persistence.LockScopesHelper;
import org.apache.openjpa.persistence.MixedLockLevelsHelper;
import org.apache.openjpa.persistence.PersistenceExceptions;

public class FetchPlanImpl
implements FetchPlan {
    private final DelegatingFetchConfiguration _fetch;
    protected static Map<String, List<String>> _precedence = new HashMap<String, List<String>>();
    protected static Map<String, HintValueConverter[]> _hints = new HashMap<String, HintValueConverter[]>();

    protected static void registerHint(String[] keys, HintValueConverter ... converters) {
        for (String key : keys) {
            _hints.put(key, converters);
        }
        if (keys.length > 1) {
            for (int i = 0; i < keys.length - 1; ++i) {
                ArrayList<String> list = new ArrayList<String>(keys.length - i - 1);
                for (int j = i + 1; j < keys.length; ++j) {
                    list.add(keys[j]);
                }
                _precedence.put(keys[i], list);
            }
        }
    }

    public FetchPlanImpl(FetchConfiguration fetch) {
        this._fetch = this.newDelegatingFetchConfiguration(fetch);
    }

    protected DelegatingFetchConfiguration newDelegatingFetchConfiguration(FetchConfiguration fetch) {
        return new DelegatingFetchConfiguration(fetch, PersistenceExceptions.TRANSLATOR);
    }

    @Override
    public FetchConfiguration getDelegate() {
        return this._fetch.getDelegate();
    }

    @Override
    public int getMaxFetchDepth() {
        return this._fetch.getMaxFetchDepth();
    }

    @Override
    public FetchPlan setMaxFetchDepth(int depth) {
        this._fetch.setMaxFetchDepth(depth);
        return this;
    }

    @Override
    public int getFetchBatchSize() {
        return this._fetch.getFetchBatchSize();
    }

    @Override
    public FetchPlan setFetchBatchSize(int fetchBatchSize) {
        this._fetch.setFetchBatchSize(fetchBatchSize);
        return this;
    }

    @Override
    public boolean getQueryResultCacheEnabled() {
        return this._fetch.getQueryCacheEnabled();
    }

    @Override
    public FetchPlan setQueryResultCacheEnabled(boolean cache) {
        this._fetch.setQueryCacheEnabled(cache);
        return this;
    }

    @Override
    public boolean getQueryResultCache() {
        return this.getQueryResultCacheEnabled();
    }

    @Override
    public FetchPlan setQueryResultCache(boolean cache) {
        return this.setQueryResultCacheEnabled(cache);
    }

    @Override
    public Collection<String> getFetchGroups() {
        return this._fetch.getFetchGroups();
    }

    @Override
    public FetchPlan addFetchGroup(String group) {
        this._fetch.addFetchGroup(group);
        return this;
    }

    @Override
    public FetchPlan addFetchGroups(String ... groups) {
        return this.addFetchGroups(Arrays.asList(groups));
    }

    @Override
    public FetchPlan addFetchGroups(Collection groups) {
        this._fetch.addFetchGroups(groups);
        return this;
    }

    @Override
    public FetchPlan removeFetchGroup(String group) {
        this._fetch.removeFetchGroup(group);
        return this;
    }

    @Override
    public FetchPlan removeFetchGroups(String ... groups) {
        return this.removeFetchGroups(Arrays.asList(groups));
    }

    @Override
    public FetchPlan removeFetchGroups(Collection groups) {
        this._fetch.removeFetchGroups(groups);
        return this;
    }

    @Override
    public FetchPlan clearFetchGroups() {
        this._fetch.clearFetchGroups();
        return this;
    }

    @Override
    public FetchPlan resetFetchGroups() {
        this._fetch.resetFetchGroups();
        return this;
    }

    @Override
    public Collection<String> getFields() {
        return this._fetch.getFields();
    }

    @Override
    public boolean hasField(String field) {
        return this._fetch.hasField(field);
    }

    @Override
    public boolean hasField(Class cls, String field) {
        return this.hasField(FetchPlanImpl.toFieldName(cls, field));
    }

    @Override
    public FetchPlan addField(String field) {
        this._fetch.addField(field);
        return this;
    }

    @Override
    public FetchPlan addField(Class cls, String field) {
        return this.addField(FetchPlanImpl.toFieldName(cls, field));
    }

    @Override
    public FetchPlan addFields(String ... fields) {
        return this.addFields(Arrays.asList(fields));
    }

    @Override
    public FetchPlan addFields(Class cls, String ... fields) {
        return this.addFields(cls, Arrays.asList(fields));
    }

    @Override
    public FetchPlan addFields(Collection fields) {
        this._fetch.addFields(fields);
        return this;
    }

    @Override
    public FetchPlan addFields(Class cls, Collection fields) {
        return this.addFields(FetchPlanImpl.toFieldNames(cls, fields));
    }

    @Override
    public FetchPlan removeField(String field) {
        this._fetch.removeField(field);
        return this;
    }

    @Override
    public FetchPlan removeField(Class cls, String field) {
        return this.removeField(FetchPlanImpl.toFieldName(cls, field));
    }

    @Override
    public FetchPlan removeFields(String ... fields) {
        return this.removeFields(Arrays.asList(fields));
    }

    @Override
    public FetchPlan removeFields(Class cls, String ... fields) {
        return this.removeFields(cls, Arrays.asList(fields));
    }

    @Override
    public FetchPlan removeFields(Collection fields) {
        this._fetch.removeFields(fields);
        return this;
    }

    @Override
    public FetchPlan removeFields(Class cls, Collection fields) {
        return this.removeFields(FetchPlanImpl.toFieldNames(cls, fields));
    }

    @Override
    public FetchPlan clearFields() {
        this._fetch.clearFields();
        return this;
    }

    private static String toFieldName(Class cls, String field) {
        return cls.getName() + "." + field;
    }

    private static Collection toFieldNames(Class cls, Collection fields) {
        if (fields.isEmpty()) {
            return fields;
        }
        ArrayList<String> names = new ArrayList<String>(fields);
        for (Object field : fields) {
            names.add(FetchPlanImpl.toFieldName(cls, (String)field));
        }
        return names;
    }

    @Override
    public int getLockTimeout() {
        return this._fetch.getLockTimeout();
    }

    @Override
    public FetchPlan setLockTimeout(int timeout) {
        this._fetch.setLockTimeout(timeout);
        return this;
    }

    @Override
    public PessimisticLockScope getLockScope() {
        return LockScopesHelper.fromLockScope(this._fetch.getLockScope());
    }

    @Override
    public FetchPlan setLockScope(PessimisticLockScope scope) {
        this._fetch.setLockScope(LockScopesHelper.toLockScope(scope));
        return this;
    }

    @Override
    public int getQueryTimeout() {
        return this._fetch.getQueryTimeout();
    }

    @Override
    public FetchPlan setQueryTimeout(int timeout) {
        this._fetch.setQueryTimeout(timeout);
        return this;
    }

    @Override
    public LockModeType getReadLockMode() {
        return MixedLockLevelsHelper.fromLockLevel(this._fetch.getReadLockLevel());
    }

    @Override
    public FetchPlan setReadLockMode(LockModeType mode) {
        this._fetch.setReadLockLevel(MixedLockLevelsHelper.toLockLevel(mode));
        return this;
    }

    @Override
    public LockModeType getWriteLockMode() {
        return MixedLockLevelsHelper.fromLockLevel(this._fetch.getWriteLockLevel());
    }

    @Override
    public FetchPlan setWriteLockMode(LockModeType mode) {
        this._fetch.setWriteLockLevel(MixedLockLevelsHelper.toLockLevel(mode));
        return this;
    }

    @Override
    public boolean getExtendedPathLookup() {
        return this._fetch.getExtendedPathLookup();
    }

    @Override
    public FetchPlan setExtendedPathLookup(boolean flag) {
        this._fetch.setExtendedPathLookup(flag);
        return this;
    }

    @Override
    public Object getHint(String key) {
        return this._fetch.getHint(key);
    }

    @Override
    public void setHint(String key, Object value) {
        if (!this.isRecognizedHint(key)) {
            return;
        }
        if (_precedence.containsKey(key)) {
            List<String> higherKeys = _precedence.get(key);
            for (String higherKey : higherKeys) {
                if (!this._fetch.isHintSet(higherKey)) continue;
                return;
            }
        }
        Object newValue = this.convertHintValue(key, value);
        this._fetch.setHint(key, newValue, value);
    }

    public void setHints(Map<String, Object> hints) {
        if (hints == null || hints.isEmpty()) {
            return;
        }
        for (Map.Entry<String, Object> hint : hints.entrySet()) {
            this.setHint(hint.getKey(), hint.getValue());
        }
    }

    @Override
    public Map<String, Object> getHints() {
        return this._fetch.getHints();
    }

    public int hashCode() {
        return this._fetch == null ? 0 : this._fetch.hashCode();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null || other.getClass() != this.getClass()) {
            return false;
        }
        if (this._fetch == null) {
            return false;
        }
        return this._fetch.equals((Object)((FetchPlanImpl)other)._fetch);
    }

    @Override
    public DataCacheRetrieveMode getCacheRetrieveMode() {
        return this._fetch.getCacheRetrieveMode();
    }

    @Override
    public DataCacheStoreMode getCacheStoreMode() {
        return this._fetch.getCacheStoreMode();
    }

    @Override
    public FetchPlan setCacheStoreMode(DataCacheStoreMode mode) {
        this._fetch.setCacheStoreMode(mode);
        return this;
    }

    @Override
    public FetchPlan setCacheRetrieveMode(DataCacheRetrieveMode mode) {
        this._fetch.setCacheRetrieveMode(mode);
        return this;
    }

    Object convertHintValue(String key, Object value) {
        if (value == null) {
            return null;
        }
        HintValueConverter[] converters = _hints.get(key);
        if (converters == null) {
            return value;
        }
        for (HintValueConverter converter : converters) {
            if (!converter.canConvert(value.getClass())) continue;
            return converter.convert(value);
        }
        return value;
    }

    boolean isRecognizedHint(String key) {
        if (key == null) {
            return false;
        }
        if (_hints.containsKey(key)) {
            return true;
        }
        return key.startsWith("openjpa.");
    }

    boolean intersects(Collection<String> keys, Collection<String> b) {
        if (keys == null || keys.isEmpty() || b == null || b.isEmpty()) {
            return false;
        }
        for (String key : keys) {
            if (!b.contains(key)) continue;
            return true;
        }
        return false;
    }

    static {
        FetchPlanImpl.registerHint(new String[]{"openjpa.FetchPlan.ExtendedPathLookup"}, new HintValueConverter.StringToBoolean());
        FetchPlanImpl.registerHint(new String[]{"openjpa.FetchBatchSize", "openjpa.FetchPlan.FetchBatchSize"}, new HintValueConverter.StringToInteger());
        FetchPlanImpl.registerHint(new String[]{"openjpa.MaxFetchDepth", "openjpa.FetchPlan.MaxFetchDepth"}, new HintValueConverter.StringToInteger());
        FetchPlanImpl.registerHint(new String[]{"openjpa.LockTimeout", "openjpa.FetchPlan.LockTimeout", "jakarta.persistence.lock.timeout"}, new HintValueConverter.StringToInteger());
        FetchPlanImpl.registerHint(new String[]{"openjpa.QueryTimeout", "openjpa.FetchPlan.QueryTimeout", "jakarta.persistence.query.timeout"}, new HintValueConverter.StringToInteger());
        FetchPlanImpl.registerHint(new String[]{"openjpa.FlushBeforeQueries", "openjpa.FetchPlan.FlushBeforeQueries"}, new HintValueConverter.StringToInteger(new String[]{"0", "1", "2"}, new int[]{0, 1, 2}));
        FetchPlanImpl.registerHint(new String[]{"openjpa.ReadLockMode", "openjpa.FetchPlan.ReadLockMode"}, new MixedLockLevelsHelper());
        FetchPlanImpl.registerHint(new String[]{"openjpa.ReadLockLevel", "openjpa.FetchPlan.ReadLockLevel"}, new MixedLockLevelsHelper());
        FetchPlanImpl.registerHint(new String[]{"openjpa.WriteLockMode", "openjpa.FetchPlan.WriteLockMode"}, new MixedLockLevelsHelper());
        FetchPlanImpl.registerHint(new String[]{"openjpa.WriteLockLevel", "openjpa.FetchPlan.WriteLockLevel"}, new MixedLockLevelsHelper());
    }
}

