/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.validation;

import jakarta.persistence.ValidationMode;
import jakarta.validation.ConstraintViolationException;
import jakarta.validation.TraversableResolver;
import jakarta.validation.Validator;
import jakarta.validation.ValidatorFactory;
import jakarta.validation.groups.Default;
import jakarta.validation.metadata.BeanDescriptor;
import java.security.AccessController;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.openjpa.conf.OpenJPAConfiguration;
import org.apache.openjpa.lib.conf.Configuration;
import org.apache.openjpa.lib.log.Log;
import org.apache.openjpa.lib.util.J2DoPrivHelper;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.lib.util.StringUtil;
import org.apache.openjpa.persistence.validation.TraversableResolverImpl;
import org.apache.openjpa.validation.AbstractValidator;
import org.apache.openjpa.validation.ValidationException;

public class ValidatorImpl
extends AbstractValidator {
    private static final Localizer _loc = Localizer.forPackage(ValidatorImpl.class);
    private ValidatorFactory _validatorFactory = null;
    private Validator _validator = null;
    private ValidationMode _mode = ValidationMode.AUTO;
    private OpenJPAConfiguration _conf = null;
    private transient Log _log = null;
    private Map<Integer, Class<?>[]> _validationGroups = new HashMap<Integer, Class<?>[]>();
    private static HashMap<String, Integer> _vgMapping = new HashMap();

    public ValidatorImpl() {
        this.initialize();
    }

    public ValidatorImpl(Configuration conf) {
        if (conf instanceof OpenJPAConfiguration) {
            this._conf = (OpenJPAConfiguration)conf;
            this._log = this._conf.getLog("openjpa.Runtime");
            Object validatorFactory = this._conf.getValidationFactoryInstance();
            String mode = this._conf.getValidationMode();
            this._mode = Enum.valueOf(ValidationMode.class, mode);
            if (validatorFactory != null) {
                if (validatorFactory instanceof ValidatorFactory) {
                    this._validatorFactory = (ValidatorFactory)validatorFactory;
                } else {
                    throw new IllegalArgumentException(_loc.get("invalid-factory").getMessage());
                }
            }
        }
        this.initialize();
    }

    public ValidatorImpl(ValidatorFactory validatorFactory, ValidationMode mode) {
        if (mode != null) {
            this._mode = mode;
        }
        if (validatorFactory != null) {
            this._validatorFactory = validatorFactory;
        }
        this.initialize();
    }

    private void initialize() {
        if (this._mode != ValidationMode.NONE) {
            if (this._validatorFactory == null) {
                this._validatorFactory = this.getDefaultValidatorFactory();
            }
            if (this._validatorFactory == null) {
                throw new RuntimeException(_loc.get("no-default-factory").getMessage());
            }
            this._validator = this._validatorFactory.usingContext().traversableResolver((TraversableResolver)new TraversableResolverImpl()).getValidator();
            if (this._validator == null) {
                throw new RuntimeException(_loc.get("no-validator").getMessage());
            }
            if (this._conf != null) {
                this.addValidationGroup("jakarta.persistence.validation.group.pre-persist", this._conf.getValidationGroupPrePersist());
                this.addValidationGroup("jakarta.persistence.validation.group.pre-update", this._conf.getValidationGroupPreUpdate());
                this.addValidationGroup("jakarta.persistence.validation.group.pre-remove", this._conf.getValidationGroupPreRemove());
            } else {
                this.addDefaultValidationGroups();
            }
        } else {
            throw new RuntimeException(_loc.get("no-validation").getMessage());
        }
    }

    public void addValidationGroup(String validationGroupName, Class<?> ... vgs) {
        Integer event = this.findEvent(validationGroupName);
        if (event != null) {
            this._validationGroups.put(event, vgs);
            return;
        }
        throw new IllegalArgumentException(_loc.get("no-group-events", (Object)validationGroupName).getMessage());
    }

    public void addValidationGroup(Integer event, Class<?> ... validationGroup) {
        this._validationGroups.put(event, validationGroup);
    }

    public void addValidationGroup(String validationGroupName, String group) {
        Integer event = this.findEvent(validationGroupName);
        if (event != null) {
            Class<?>[] vgs = this.getValidationGroup(validationGroupName, group);
            if (vgs != null) {
                this.addValidationGroup(event, vgs);
            }
        } else {
            throw new IllegalArgumentException(_loc.get("no-group-events", (Object)validationGroupName).getMessage());
        }
    }

    private Class<?>[] getValidationGroup(String vgName, String group) {
        Class[] vgGrp = null;
        if (group == null || group.trim().length() == 0) {
            return null;
        }
        String[] strClasses = group.split(",");
        if (strClasses.length > 0) {
            vgGrp = new Class[strClasses.length];
            for (int i = 0; i < strClasses.length; ++i) {
                try {
                    vgGrp[i] = Class.forName(StringUtil.trim((String)strClasses[i]));
                    continue;
                }
                catch (Throwable t) {
                    throw new IllegalArgumentException(_loc.get("invalid-validation-group", (Object)StringUtil.trim((String)strClasses[i]), (Object)vgName).getMessage(), t);
                }
            }
        }
        return vgGrp;
    }

    public Class<?>[] getValidationGroup(Integer event) {
        return this._validationGroups.get(event);
    }

    public boolean isValidating(Integer event) {
        return this._validationGroups.get(event) != null;
    }

    public BeanDescriptor getConstraintsForClass(Class<?> cls) {
        return this._validator.getConstraintsForClass(cls);
    }

    public <T> ValidationException validate(T arg0, int event) {
        if (!this.isValidating(event)) {
            return null;
        }
        Set violations = (Set)AccessController.doPrivileged(J2DoPrivHelper.validateAction((Validator)this._validator, arg0, (Class[])this.getValidationGroup(event)));
        if (violations != null && violations.size() > 0) {
            return new ValidationException((RuntimeException)new ConstraintViolationException(_loc.get("validate-failed", (Object)arg0.getClass().getName()).getMessage(), violations), true);
        }
        return null;
    }

    public <T> ValidationException validateProperty(T arg0, String property, int event) {
        if (!this.isValidating(event)) {
            return null;
        }
        Set violations = this._validator.validateProperty(arg0, property, (Class[])this.getValidationGroup(event));
        if (violations != null && violations.size() > 0) {
            return new ValidationException((RuntimeException)new ConstraintViolationException(_loc.get("valdiate-property-failed", (Object)arg0.getClass().getName(), (Object)property).getMessage(), violations), true);
        }
        return null;
    }

    public <T> ValidationException validateValue(Class<T> arg0, String arg1, Object arg2, int event) {
        if (!this.isValidating(event)) {
            return null;
        }
        Set violations = this._validator.validateValue(arg0, arg1, arg2, (Class[])this.getValidationGroup(event));
        if (violations != null && violations.size() > 0) {
            return new ValidationException((RuntimeException)new ConstraintViolationException(_loc.get("validate-value-failed", (Object)arg0.getName(), (Object)arg1, (Object)arg2.toString()).getMessage(), violations), true);
        }
        return null;
    }

    public <T> boolean validating(T arg0, int event) {
        return this.isValidating(event);
    }

    private Integer findEvent(String validationProperty) {
        return _vgMapping.get(validationProperty);
    }

    private ValidatorFactory getDefaultValidatorFactory() {
        ValidatorFactory factory;
        block2: {
            factory = null;
            try {
                factory = (ValidatorFactory)AccessController.doPrivileged(J2DoPrivHelper.buildDefaultValidatorFactoryAction());
            }
            catch (jakarta.validation.ValidationException e) {
                if (this._log == null || !this._log.isTraceEnabled()) break block2;
                this._log.trace((Object)_loc.get("factory-create-failed"), (Throwable)e);
            }
        }
        return factory;
    }

    private void addDefaultValidationGroups() {
        this.addValidationGroup("jakarta.persistence.validation.group.pre-persist", Default.class);
        this.addValidationGroup("jakarta.persistence.validation.group.pre-update", Default.class);
    }

    static {
        _vgMapping.put("jakarta.persistence.validation.group.pre-persist", 0);
        _vgMapping.put("jakarta.persistence.validation.group.pre-remove", 7);
        _vgMapping.put("jakarta.persistence.validation.group.pre-update", 20);
    }
}

