/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence;

import jakarta.persistence.FlushModeType;
import jakarta.persistence.LockModeType;
import jakarta.persistence.NoResultException;
import jakarta.persistence.NonUniqueResultException;
import jakarta.persistence.Parameter;
import jakarta.persistence.ParameterMode;
import jakarta.persistence.PersistenceException;
import jakarta.persistence.Query;
import jakarta.persistence.StoredProcedureQuery;
import jakarta.persistence.TemporalType;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.openjpa.kernel.DelegatingResultList;
import org.apache.openjpa.kernel.QueryResultCallback;
import org.apache.openjpa.lib.rop.ResultList;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.meta.MultiQueryMetaData;
import org.apache.openjpa.persistence.OpenJPAQuery;
import org.apache.openjpa.persistence.ParameterImpl;
import org.apache.openjpa.persistence.PersistenceExceptions;
import org.apache.openjpa.persistence.QueryImpl;
import org.apache.openjpa.util.RuntimeExceptionTranslator;
import org.apache.openjpa.util.UserException;

public class StoredProcedureQueryImpl
implements StoredProcedureQuery {
    private static final Localizer _loc = Localizer.forPackage(QueryImpl.class);
    private final String _name;
    private final QueryImpl<?> _delegate;
    private final MultiQueryMetaData _meta;
    private QueryResultCallback _callback;
    private boolean _declaredParams;

    public StoredProcedureQueryImpl(String procedureName, MultiQueryMetaData meta, QueryImpl<?> delegate) {
        this._name = procedureName;
        if (!this.isValidProcedureName(procedureName)) {
            throw new RuntimeException(procedureName + " is not a valid procedure name");
        }
        this._meta = meta;
        this._delegate = delegate;
        this._delegate.compile();
    }

    public OpenJPAQuery<?> getDelegate() {
        return this._delegate;
    }

    public org.apache.openjpa.kernel.Query getExecutableQuery() {
        return this._delegate.getDelegate();
    }

    private void buildParametersIfNeeded() {
        if (!this._declaredParams) {
            for (MultiQueryMetaData.Parameter entry : this._meta.getParameters()) {
                ParameterImpl param;
                Object key;
                if (entry.getName() == null) {
                    key = entry.getPosition();
                    param = new ParameterImpl(entry.getPosition(), entry.getType());
                } else {
                    key = entry.getName();
                    param = new ParameterImpl(entry.getName(), entry.getType());
                }
                this._delegate.declareParameter(key, param);
            }
            this._declaredParams = true;
        }
    }

    public boolean execute() {
        if (this._callback == null) {
            this._callback = (QueryResultCallback)this.getExecutableQuery().execute(this._delegate.getParameterValues());
        }
        return this._callback.getExecutionResult();
    }

    public List getResultList() {
        this.execute();
        try {
            Object list = this._callback.callback();
            RuntimeExceptionTranslator trans = PersistenceExceptions.getRollbackTranslator(this._delegate.getEntityManager());
            return new DelegatingResultList((ResultList)list, trans);
        }
        catch (Exception ex) {
            throw new PersistenceException((Throwable)ex);
        }
    }

    public Object getSingleResult() {
        this.execute();
        try {
            ResultList result = (ResultList)this._callback.callback();
            if (result == null || result.isEmpty()) {
                throw new NoResultException(_loc.get("no-result", (Object)this._name).getMessage());
            }
            if (result.size() > 1) {
                throw new NonUniqueResultException(_loc.get("non-unique-result", (Object)this._name, (Object)result.size()).getMessage());
            }
            RuntimeExceptionTranslator trans = PersistenceExceptions.getRollbackTranslator(this._delegate.getEntityManager());
            return new DelegatingResultList(result, trans).iterator().next();
        }
        catch (Exception ex) {
            throw new PersistenceException((Throwable)ex);
        }
    }

    public boolean hasMoreResults() {
        return this._callback != null && this._callback.hasMoreResults();
    }

    public int getUpdateCount() {
        this.assertExecuted();
        return this._callback.getUpdateCount();
    }

    public int executeUpdate() {
        this.execute();
        return this._callback.getUpdateCount();
    }

    public <T> Parameter<T> getParameter(String name, Class<T> type) {
        return this._delegate.getParameter(name, type);
    }

    public <T> Parameter<T> getParameter(int position, Class<T> type) {
        return this._delegate.getParameter(position, type);
    }

    public boolean isBound(Parameter<?> param) {
        return this._delegate.isBound(param);
    }

    public <T> T getParameterValue(Parameter<T> param) {
        return this._delegate.getParameterValue(param);
    }

    public <T> T unwrap(Class<T> cls) {
        return this._delegate.unwrap(cls);
    }

    public <T> StoredProcedureQuery setParameter(Parameter<T> param, T value) {
        this.buildParametersIfNeeded();
        this._delegate.setParameter((Parameter)param, (Object)value);
        return this;
    }

    public StoredProcedureQuery setParameter(Parameter<Calendar> param, Calendar cal, TemporalType temporalType) {
        this.buildParametersIfNeeded();
        this._delegate.setParameter(param, cal, temporalType);
        return this;
    }

    public StoredProcedureQuery setParameter(Parameter<Date> param, Date value, TemporalType temporalType) {
        this.buildParametersIfNeeded();
        this._delegate.setParameter((Parameter)param, value, temporalType);
        return this;
    }

    public StoredProcedureQuery registerStoredProcedureParameter(int position, Class type, ParameterMode mode) {
        this.buildParametersIfNeeded();
        ParameterImpl param = new ParameterImpl(position, type);
        this._delegate.declareParameter(position, param);
        return this;
    }

    public StoredProcedureQuery registerStoredProcedureParameter(String name, Class type, ParameterMode mode) {
        this.buildParametersIfNeeded();
        ParameterImpl param = new ParameterImpl(name, type);
        this._delegate.declareParameter(name, param);
        return this;
    }

    public Object getOutputParameterValue(int position) {
        return this._callback == null ? null : this._callback.getOut(position);
    }

    public Object getOutputParameterValue(String parameterName) {
        return this._callback == null ? null : this._callback.getOut(parameterName);
    }

    public Query setMaxResults(int maxResult) {
        return this._delegate.setMaxResults(maxResult);
    }

    public int getMaxResults() {
        return this._delegate.getMaxResults();
    }

    public Query setFirstResult(int startPosition) {
        return this._delegate.setFirstResult(startPosition);
    }

    public int getFirstResult() {
        return this._delegate.getFirstResult();
    }

    public Map<String, Object> getHints() {
        return this._delegate.getHints();
    }

    public Set<Parameter<?>> getParameters() {
        this.buildParametersIfNeeded();
        return this._delegate.getParameters();
    }

    public Parameter<?> getParameter(String name) {
        this.buildParametersIfNeeded();
        return this._delegate.getParameter(name);
    }

    public Parameter<?> getParameter(int position) {
        this.buildParametersIfNeeded();
        return this._delegate.getParameter(position);
    }

    public Object getParameterValue(String name) {
        this.buildParametersIfNeeded();
        return this._delegate.getParameterValue(name);
    }

    public Object getParameterValue(int position) {
        this.buildParametersIfNeeded();
        return this._delegate.getParameter(position);
    }

    public FlushModeType getFlushMode() {
        return this._delegate.getFlushMode();
    }

    public Query setLockMode(LockModeType lockMode) {
        return this._delegate.setLockMode(lockMode);
    }

    public LockModeType getLockMode() {
        return this._delegate.getLockMode();
    }

    public StoredProcedureQuery setHint(String hintName, Object value) {
        this._delegate.setHint(hintName, value);
        return this;
    }

    public StoredProcedureQuery setParameter(String name, Object value) {
        this.buildParametersIfNeeded();
        this._delegate.setParameter(name, value);
        return this;
    }

    public StoredProcedureQuery setParameter(String name, Calendar cal, TemporalType temporalType) {
        this.buildParametersIfNeeded();
        this._delegate.setParameter(name, cal, temporalType);
        return this;
    }

    public StoredProcedureQuery setParameter(String name, Date date, TemporalType temporalType) {
        this.buildParametersIfNeeded();
        this._delegate.setParameter(name, date, temporalType);
        return this;
    }

    public StoredProcedureQuery setParameter(int position, Object value) {
        this.buildParametersIfNeeded();
        this._delegate.setParameter(position, value);
        return this;
    }

    public StoredProcedureQuery setParameter(int position, Calendar value, TemporalType temporalType) {
        this.buildParametersIfNeeded();
        this._delegate.setParameter(position, value, temporalType);
        return this;
    }

    public StoredProcedureQuery setParameter(int position, Date value, TemporalType temporalType) {
        this.buildParametersIfNeeded();
        this._delegate.setParameter(position, value, temporalType);
        return this;
    }

    public StoredProcedureQuery setFlushMode(FlushModeType flushMode) {
        this._delegate.setFlushMode(flushMode);
        return this;
    }

    void assertExecuted() {
        if (this._callback == null) {
            throw new UserException(this + " has not been executed");
        }
    }

    boolean isValidProcedureName(String s) {
        if (s == null || s.trim().length() == 0) {
            return false;
        }
        for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            if (ch == '#' || ch == '$' || Character.isJavaIdentifierPart(ch)) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return this._name;
    }
}

