/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.tools.maven;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.openjpa.lib.util.Options;
import org.codehaus.plexus.util.FileUtils;

public abstract class AbstractOpenJpaMojo
extends AbstractMojo {
    @Parameter(property="openjpa.workdir", defaultValue="${project.build.directory}/openjpa-work", required=true)
    protected File workDir;
    @Parameter(property="openjpa.classes", defaultValue="${project.build.outputDirectory}", required=true)
    protected File classes;
    @Parameter(defaultValue="**/*.class")
    private String includes;
    @Parameter(defaultValue="")
    private String excludes;
    @Parameter
    private Properties toolProperties;
    @Parameter
    private String persistenceXmlFile;
    @Parameter(defaultValue="${openjpa.persistenceUnitName}")
    private String persistenceUnitName;
    @Parameter
    private String connectionDriverName;
    protected static final String OPTION_CONNECTION_DRIVER_NAME = "ConnectionDriverName";
    @Parameter
    private String connectionProperties;
    protected static final String OPTION_CONNECTION_PROPERTIES = "ConnectionProperties";
    @Parameter(defaultValue="${project.compileClasspathElements}", required=true, readonly=true)
    protected List<String> compileClasspathElements;
    @Parameter(property="forceOpenJpaExecution", defaultValue="false", required=true)
    private boolean forceMojoExecution;
    @Parameter(defaultValue="${project}", required=true, readonly=true)
    protected MavenProject project;
    protected static final String OPTION_PROPERTIES_FILE = "propertiesFile";
    protected static final String OPTION_PROPERTIES = "properties";
    @Parameter(defaultValue="false")
    private boolean skip;

    protected File getEntityClasses() {
        return this.classes;
    }

    protected List<String> getClasspathElements() {
        return this.compileClasspathElements;
    }

    protected abstract Options getOptions() throws MojoExecutionException;

    protected boolean skipMojo() {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skip sql execution");
            return true;
        }
        if (!this.forceMojoExecution && this.project != null && "pom".equals(this.project.getPackaging())) {
            this.getLog().info((CharSequence)"Skipping sql execution for project with packaging type 'pom'");
            return true;
        }
        return false;
    }

    protected Options createOptions() throws MojoExecutionException {
        Options opts = new Options();
        if (this.toolProperties != null) {
            opts.putAll((Map)this.toolProperties);
        }
        String persistenceXmlResource = "META-INF/persistence.xml";
        if (this.persistenceXmlFile != null && this.persistenceXmlFile.length() > 0) {
            this.fixPersistenceXmlIfNeeded(Thread.currentThread().getContextClassLoader());
            opts.put((Object)OPTION_PROPERTIES_FILE, (Object)this.persistenceXmlFile);
            this.getLog().debug((CharSequence)("using special persistence XML file: " + this.persistenceXmlFile));
            persistenceXmlResource = this.persistenceXmlFile;
        }
        if (this.persistenceUnitName != null && this.persistenceUnitName.length() > 0) {
            opts.put((Object)OPTION_PROPERTIES, (Object)(persistenceXmlResource + "#" + this.persistenceUnitName));
        } else if (!new File(this.classes, "META-INF/persistence.xml").exists()) {
            this.persistenceXmlFile = "META-INF/persistence.xml";
            if (!this.fixPersistenceXmlIfNeeded(Thread.currentThread().getContextClassLoader())) {
                this.persistenceXmlFile = null;
            } else {
                opts.put((Object)OPTION_PROPERTIES_FILE, (Object)this.persistenceXmlFile);
            }
        }
        if (this.connectionDriverName != null) {
            opts.put((Object)OPTION_CONNECTION_DRIVER_NAME, (Object)this.connectionDriverName);
        }
        if (this.connectionProperties != null) {
            opts.put((Object)OPTION_CONNECTION_PROPERTIES, (Object)this.connectionProperties);
        }
        return opts;
    }

    private boolean fixPersistenceXmlIfNeeded(ClassLoader loader) throws MojoExecutionException {
        return !new File(this.persistenceXmlFile).exists() && (this.findPersistenceXmlFromLoader(loader) || this.findPersistenceXmlInArtifacts(this.project.getCompileArtifacts()) || this.findPersistenceXmlInArtifacts(this.project.getRuntimeArtifacts()));
    }

    private boolean findPersistenceXmlFromLoader(ClassLoader loader) throws MojoExecutionException {
        URL url = loader.getResource(this.persistenceXmlFile);
        if (url != null) {
            File tmpPersistenceXml = new File(this.workDir, "persistence" + System.currentTimeMillis() + ".xml");
            if (!tmpPersistenceXml.getParentFile().exists() && !tmpPersistenceXml.getParentFile().mkdirs()) {
                throw new MojoExecutionException("Can't create " + tmpPersistenceXml.getParentFile().getAbsolutePath());
            }
            try {
                FileUtils.copyURLToFile((URL)url, (File)tmpPersistenceXml);
            }
            catch (IOException e) {
                throw new MojoExecutionException(e.getMessage(), (Exception)e);
            }
            this.persistenceXmlFile = tmpPersistenceXml.getAbsolutePath();
            return true;
        }
        return false;
    }

    private boolean findPersistenceXmlInArtifacts(List<Artifact> artifacts) throws MojoExecutionException {
        for (Artifact artifact : artifacts) {
            File file = artifact.getFile();
            if (file == null || !file.exists()) continue;
            try {
                if (!this.findPersistenceXmlFromLoader(new URLClassLoader(new URL[]{file.toURI().toURL()}, ClassLoader.getSystemClassLoader()))) continue;
                return true;
            }
            catch (MalformedURLException malformedURLException) {
            }
        }
        return false;
    }

    protected void extendRealmClasspath() throws MojoExecutionException {
        ArrayList<URL> urls = new ArrayList<URL>();
        for (String fileName : this.getClasspathElements()) {
            File pathElem = new File(fileName);
            try {
                URL url = pathElem.toURI().toURL();
                urls.add(url);
                this.getLog().debug((CharSequence)("Added classpathElement URL " + String.valueOf(url)));
            }
            catch (MalformedURLException e) {
                throw new MojoExecutionException("Error in adding the classpath " + String.valueOf(pathElem), (Exception)e);
            }
        }
        URLClassLoader jpaRealm = new URLClassLoader(urls.toArray(new URL[urls.size()]), ((Object)((Object)this)).getClass().getClassLoader());
        Thread.currentThread().setContextClassLoader(jpaRealm);
    }

    protected List<File> findEntityClassFiles() throws MojoExecutionException {
        ArrayList<File> files = new ArrayList();
        try {
            files = FileUtils.getFiles((File)this.getEntityClasses(), (String)this.includes, (String)this.excludes);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error while scanning for '" + this.includes + "' in '" + this.getEntityClasses().getAbsolutePath() + "'.", (Exception)e);
        }
        return files;
    }

    protected String[] getFilePaths(List<File> files) {
        String[] args = new String[files.size()];
        for (int i = 0; i < files.size(); ++i) {
            File file = files.get(i);
            args[i] = file.getAbsolutePath();
        }
        return args;
    }
}

