/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.tools.maven;

import java.io.File;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.openjpa.enhance.PCEnhancer;
import org.apache.openjpa.lib.util.Options;
import org.apache.openjpa.tools.maven.AbstractOpenJpaMojo;
import org.codehaus.plexus.util.FileUtils;

public abstract class AbstractOpenJpaEnhancerMojo
extends AbstractOpenJpaMojo {
    @Parameter(defaultValue="true")
    protected boolean addDefaultConstructor;
    private static final String OPTION_ADD_DEFAULT_CONSTRUCTOR = "addDefaultConstructor";
    @Parameter(defaultValue="false")
    protected boolean enforcePropertyRestrictions;
    private static final String OPTION_ENFORCE_PROPERTY_RESTRICTION = "enforcePropertyRestrictions";
    @Parameter(defaultValue="false")
    protected boolean tmpClassLoader;
    private static final String OPTION_USE_TEMP_CLASSLOADER = "tcl";

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skipMojo()) {
            return;
        }
        if (!this.getEntityClasses().exists()) {
            FileUtils.mkdir((String)this.getEntityClasses().getAbsolutePath());
        }
        List<File> entities = this.findEntityClassFiles();
        this.enhance(entities);
    }

    @Override
    protected Options getOptions() throws MojoExecutionException {
        Options opts = this.createOptions();
        opts.put((Object)OPTION_ADD_DEFAULT_CONSTRUCTOR, (Object)Boolean.toString(this.addDefaultConstructor));
        opts.put((Object)OPTION_ENFORCE_PROPERTY_RESTRICTION, (Object)Boolean.toString(this.enforcePropertyRestrictions));
        opts.put((Object)OPTION_USE_TEMP_CLASSLOADER, (Object)Boolean.toString(this.tmpClassLoader));
        return opts;
    }

    private void enhance(List<File> files) throws MojoExecutionException {
        Options opts = this.getOptions();
        String[] args = this.getFilePaths(files);
        boolean ok = false;
        if (!this.tmpClassLoader) {
            this.extendRealmClasspath();
        }
        if (!(ok = PCEnhancer.run((String[])args, (Options)opts))) {
            throw new MojoExecutionException("The OpenJPA Enhancer tool detected an error!");
        }
    }
}

