/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.openjpa.enhance;

import org.apache.openjpa.enhance.asm.AsmSpi;
import org.apache.openjpa.enhance.asm.AsmSpi9;
import serp.bytecode.BCClass;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ServiceLoader;
import java.util.stream.StreamSupport;


/**
 * Use ASM to add required StackMapTable attribute to the byte code generated by
 * Serp.
 */
public final class AsmAdaptor {
    private final static AsmSpi impl;
    static {
        impl = StreamSupport.stream(ServiceLoader.load(AsmSpi.class).spliterator(), false).min((a, b) -> {
            final int v1;
            try {
                v1 = Integer.parseInt(a.getClass().getName().replace("AsmSpi", ""));
            } catch (final Exception e) {
                // not matching our default naming so an user impl so let's use it
                return -1;
            }
            final int v2;
            try {
                v2 = Integer.parseInt(b.getClass().getName().replace("AsmSpi", ""));
            } catch (final Exception e) {
                // not matching our default naming so an user impl so let's use it
                return 1;
            }
            return v2 - v1; // reverse since we want the higher
        }).orElseGet(AsmSpi9::new);
    }

    @SuppressWarnings("deprecation")
    public static void write(BCClass bc) throws IOException {
        impl.write(bc);
    }

    public static void write(BCClass bc, File outFile) throws IOException {
        impl.write(bc, outFile);
    }

    public static void write(BCClass bc, OutputStream os) throws IOException {
        impl.write(bc, os);
    }

    public static byte[] toByteArray(BCClass bc, byte[] returnBytes) throws IOException {
        return impl.toByteArray(bc, returnBytes);
    }

    public static boolean isEnhanced(final byte[] b)
    {
        return impl.isEnhanced(b);
    }
}
