/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.test;

import java.io.IOException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.spi.PersistenceUnitInfo;
import org.apache.openjpa.lib.util.J2DoPrivHelper;
import org.apache.openjpa.persistence.OpenJPAEntityManagerFactorySPI;
import org.apache.openjpa.persistence.PersistenceProductDerivation;
import org.apache.openjpa.persistence.PersistenceProviderImpl;
import org.apache.openjpa.persistence.PersistenceUnitInfoImpl;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public abstract class ContainerEMFTest
extends SingleEMFTestCase {
    public static final String PERSISTENT_CLASS_LIST = "PERSISTENT_CLASS_LIST";

    public String getPersistenceResourceName() {
        return "META-INF/persistence.xml";
    }

    @Override
    public void setUp(Object ... props) {
        Map<String, Object> map = this.getPropertiesMap(props);
        this.emf = this.createContainerEMF(this.getPersistenceUnitName(), this.getPersistenceResourceName(), map);
    }

    protected OpenJPAEntityManagerFactorySPI createContainerEMF(String pu, String persistenceFile, Map<String, Object> map) {
        List clist = null;
        OpenJPAEntityManagerFactorySPI oemf = null;
        HashMap<Object, Object> config = new HashMap<Object, Object>(System.getProperties());
        if (map != null) {
            config.putAll(map);
            clist = (List)map.remove(PERSISTENT_CLASS_LIST);
        }
        PersistenceProductDerivation.ConfigurationParser cfgParser = new PersistenceProductDerivation.ConfigurationParser(config);
        try {
            URL url = ContainerEMFTest.getResourceURL(persistenceFile);
            cfgParser.parse(url);
            List units = cfgParser.getResults();
            PersistenceUnitInfoImpl puinf = null;
            for (PersistenceUnitInfoImpl pui : units) {
                if (!pu.equals(pui.getPersistenceUnitName())) continue;
                puinf = pui;
                break;
            }
            if (clist != null) {
                for (Class cl : clist) {
                    puinf.addManagedClassName(cl.getName());
                }
            }
            oemf = this.createContainerEMF(pu, (PersistenceUnitInfo)puinf, (Map<String, Object>)config);
        }
        catch (IOException ioe) {
            throw new RuntimeException("Failed to parse: " + this.getPersistenceResourceName(), ioe);
        }
        if (oemf == null) {
            throw new NullPointerException("Expected an entity manager factory for the persistence unit named: \"" + pu + "\"");
        }
        return oemf;
    }

    private OpenJPAEntityManagerFactorySPI createContainerEMF(String puName, PersistenceUnitInfo pui, Map<String, Object> map) {
        PersistenceProviderImpl ppi = new PersistenceProviderImpl();
        return (OpenJPAEntityManagerFactorySPI)ppi.createContainerEntityManagerFactory(pui, map);
    }

    private static URL getResourceURL(String rsrc) throws IOException {
        Enumeration urls = null;
        try {
            ClassLoader cl = ContainerEMFTest.class.getClassLoader();
            urls = (Enumeration)AccessController.doPrivileged(J2DoPrivHelper.getResourcesAction((ClassLoader)cl, (String)rsrc));
        }
        catch (PrivilegedActionException pae) {
            throw (IOException)pae.getException();
        }
        return (URL)Collections.list(urls).get(0);
    }
}

