/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.integration.slf4j;

import javax.persistence.EntityManagerFactory;
import org.apache.openjpa.lib.log.Log;
import org.apache.openjpa.lib.log.SLF4JLogFactory;
import org.apache.openjpa.persistence.OpenJPAEntityManagerSPI;
import org.apache.openjpa.persistence.test.SingleEMFTestCase;

public class TestLogFactory
extends SingleEMFTestCase {
    String systemPropLog = null;

    @Override
    public void setUp() throws Exception {
        this.systemPropLog = System.getProperty("openjpa.Log");
        System.getProperties().remove("openjpa.Log");
        super.setUp();
    }

    @Override
    public void tearDown() throws Exception {
        super.tearDown();
        if (this.systemPropLog != null) {
            System.setProperty("openjpa.Log", this.systemPropLog);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSLF4J() {
        try {
            OpenJPAEntityManagerSPI em = this.emf.createEntityManager();
            Log log = this.getLog();
            String logFactory = log.getClass().getName();
            log.info((Object)("Log class=" + logFactory));
            TestLogFactory.assertEquals((String)SLF4JLogFactory.LogAdapter.class.getName(), (String)logFactory);
            log.trace((Object)"TRACE level logging");
            em.close();
        }
        finally {
            this.closeEMF((EntityManagerFactory)this.emf);
        }
    }

    @Override
    public String getPersistenceUnitName() {
        return "openjpa-integration-slf4j";
    }
}

